-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  ANTI-G SYSTEM
--  An anti-G system provides partial protection against the
--  physiological effects of high G maneuvers. The system utilizes
--  engine bleed air to supply pressure to each pilot's anti-G
--  suit. Each anti-G valve is a weighted rod with an orifice
--  which is displaced towards full open by gravity during positive
--  G acceleration. As the weighted valve moves further
--  open with increasing G, the pressure in the anti-G suit
--  increases proportionally.
--  A shutoff valve is electrically connected to the inflow
--  switch of the environmental control system (ECS) to prevent
--  bleed air from entering the system when the inflow
--  valve is closed. A heat exchanger cools engine bleed air so
--  that the bleed air is provided to the suit at a comfortable
--  temperature.
--  A water drain tank is incorporated in the system to protect
--  the anti-G valves from contamination. A safety valve is also
--  included in the system to automatically relieve pressure
--  should a pressure condition greater than 7 psig occur.
--  A control panel is located on the left console of each cockpit.
--  Quick disconnect couplings are provided at each hose
--  connection. A test button is provided on the left console of
--  each cockpit to check the system by allowing bleed air to
--  flow through the anti-G valve.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------

private package Jpats_Environmental.Anti_Gravity_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Environmental.Anti_Gravity_Controller;
