-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  INFLOW SYSTEM
--  Inflow air is routed based on the position of the vent control
--  lever, placarded AIR, located in the front cockpit only.
--  When the vent control lever is set to footwarmer, placarded
--  FOOT, the defog shutoff valve is closed and bleed air flows
--  through the bi-level flow control valve. From the bi-level
--  flow control valve, bleed air is routed to the heat exchanger
--  bypass valve. After passing through or bypassing the heat
--  exchanger, bleed air flows through the ejector bypass valve
--  and into the cockpit
--  When the vent control lever is set to canopy defog, placarded
--  DEFOG, the bi-level flow control bypass valve opens
--  and all bleed air bypasses the bi-level flow control valve,
--  automatically closing the bi-level flow control valve. Bleed
--  air then passes through or bypasses the heat exchanger. The
--  ejector bypass valve closes and all bleed air then passes
--  through the ejector. The ejector takes the high pressure
--  bleed air and passes the air through a venturi which sucks in
--  cockpit ambient air. The ambient air and bleed air mix to
--  provide a high volume of warm air for canopy defog.
--  Cooling air for the heat exchanger is supplied by two
--  sources. For ground operations, a blower supplies the necessary
--  cooling air flow. With weight off the landing gear, electrical
--  power to the blower is terminated and ram air from the
--  inlet is ducted to the heat exchanger. Flappers in the heat
--  exchanger inlet duct divert the airflow, depending on
--  whether the cooling air is blower or ram air supplied.
--  After passing through the bypass valve, the bleed air is
--  ducted to the cockpit, passing across a temperature sensor
--  which is part of the automatic temperature control. A manually
--  actuated shutoff valve is located at the firewall. This
--  valve is connected by linkage to the hydraulic and fuel systems
--  shutoff valves, and is actuated from the front cockpit
--  by pulling the emergency firewall shutoff handle on the
--  front instrument panel (Figure 1-3). The air flow is divided
--  downstream of the inflow firewall shutoff valve to feed the
--  front cockpit foot warmer and windscreen defog ducts and
--  aft to feed the rear cockpit foot warmer and canopy side
--  defog ducts. A manually operated butterfly valve, located
--  under the instrument panel in each cockpit, diverts air flow
--  to either the defog or foot warmer outlets. A blower control
--  switch, placarded EVAP BLWR, is located on the environmental
--  control panel in the front cockpit, and on the engine
--  electrical switch panel in the rear cockpit. The blower control
--  switches may be used to select low or high flow settings
--  for the respective cockpit blower.
--  Cockpit temperature is normally controlled automatically.
--  The temperature controller receives input from the inflow
--  duct temperature sensor, the environmental control panel
--  temperature selector position and the cockpit space temperature
--  sensor. This results in an output signal from the controller
--  to the heat exchanger bypass valve to direct more or
--  less bleed air through the heat exchanger as necessary to
--  achieve and maintain the selected temperature. The controller
--  also monitors the temperature of the inflow air at the
--  duct sensor, and limits inflow air temperature to 190 F.
--  For other than normal operation, the cockpit air temperature
--  can be manually selected between 60 F and 90 F by positioning
--  and holding the selector to either cold (C) or hot (H)
--  until the desired temperature is achieved. This manually
--  adjusts the butterfly valve controlling the amount of Air
--  going through the heat exchanger bypass valve to either
--  raise or lower cockpit temperature.
--  Fresh air ventilation during ground operations and unpressurized
--  flight is obtained from the inlet. Air flows from the
--  inlet duct through the motor driven ram air shutoff valve,
--  when opened, to the main inflow duct just forward of the
--  firewall. The valve has three positions: closed, mid open,
--  and full open. On the ground, a blower supplies the airflow.
--  In flight, electrical power to the blower is terminated and
--  ram air supplies the airflow.

--  COCKPIT COOLING SYSTEM
--  Cockpit cooling is provided by a vapor cycle system, which
--  includes an engine driven refrigerant compressor, condenser
--  and blower, two air conditioner evaporator and blower
--  assemblies, high and low pressure switches, and service fittings.
--  The compressor is belt-driven at the front of the
--  engine, just aft of the propeller spinner base plate.
--  Refrigerant is pumped in vapor form to the condenser in the
--  aft fuselage, where the vapor changes into a high pressure
--  liquid as the refrigerant exits the condenser. The refrigerant
--  then flows to front and rear cockpit evaporator expansion
--  valves, where the refrigerant is metered into the evaporator
--  coils and changes state back to vapor as the refrigerant
--  absorbs the heat in the air flowing across the coils. The
--  refrigerant then returns to the compressor as a vapor.
--  The evaporator module assembly in each cockpit includes a
--  coil, expansion valve, blower assembly and shroud. Each
--  cockpit blower produces up to 200 cubic feet per minute
--  flow at the HI setting. Cooled air is discharged through one
--  louvered type outlet mounted in the center console of each
--  cockpit. Power for the cockpit cooling system is provided
--  through a circuit breaker placarded AIR COND, located on
--  the generator bus circuit breaker panel in the front cockpit.
--  Cockpit cooling air is available only when the engine is on
--  and functioning. The blowers will function whenever the
--  generator bus is powered and the generator switch is ON.
--  The system has an overpressure cut-out switch which will
--  interrupt electrical power to the compressor clutch in the
--  event of abnormally high system pressure. This switch is
--  located at the service panel in the aft fuselage and automatically
--  resets when tripped. Should a low pressure condition
--  exist for more than 30 seconds, a relay closes, interrupting
--  power to the compressor clutch. The low pressure relay
--  must be manually reset by maintenance personnel.
--  The ECS has two temperature sensing sources to alert the
--  pilot of overtemperature conditions in the ECS ducting. A
--  200 F temperature sensor is located at the canopy defog
--  selector valve in the front cockpit. If bleed air temperature at
--  the valve exceeds 200 F with the system in defog mode, the
--  amber DUCT TEMP annunciator will illuminate. There is
--  also a 300 F temperature sensor upstream of the 200 sensor,
--  in the environmental systems duct near the inflow valve.
--  If bleed air temperature in the environmental systems duct
--  exceeds 300 at any time, the amber DUCT TEMP annunciator
--  will illuminate.

--  WINDSHIELD DEFOGGING SYSTEM
--  The environmental control system utilizes warm engine
--  bleed air to defog the canopy windshield and transparencies.
--  To select canopy and windshield defog, set the vent control
--  lever, placarded AIR, located on the center console in the
--  front cockpit, to DEFOG. If the windshield or transparencies
--  begin to fog, set the environmental inflow rate and temperature
--  controls as required to keep windshield and
--  transparencies clear of condensation.
--  ENVIRONMENTAL CONTROL PANEL
--  The environmental control panel (Figure 1-41) is located in
--  the front cockpit right side console. The panel includes four
--  toggle switches and one rotary switch/potentiometer.
--  The fan control switch, placarded EVAP BLOWER in each
--  cockpit (Figure 1-40), is a two position toggle switch providing
--  LOW and HI speed control of the respective blower.
--  NOTE
--  The fan control switch in the rear cockpit is
--  the only environmental control switch
--  located in the rear cockpit.
--  Power for the evaporator blower fan in each cockpit is provided
--  through a circuit breaker placarded EVAP BLWR,
--  located on the generator bus circuit breaker panel in the
--  front and rear cockpits.
--  The inflow control switch, placarded BLEED AIR
--  INFLOW, is a three position toggle providing OFF, NORM
--  and HI flow.
--  The pressurization control switch, placarded PRESSURIZATION,
--  is a guarded three position toggle switch. The
--  switch positions are NORM, DUMP, and RAM/DUMP. The
--  switch guard must be raised to select the DUMP or RAM/
--  DUMP position. When the pressurization control switch is
--  in the NORM position, the pressurization system operates
--  automatically. Selecting DUMP opens the dump solenoid
--  electrically, which mechanically opens the control valve;
--  however, bleed air inflow continues. Selecting RAM/DUMP
--  shuts off bleed air inflow and opens the ram air ventilation
--  shutoff valves, allowing ram air into the cockpit.
--  The ram air control switch, placarded RAM AIR FLOW, is
--  a three position toggle switch with OFF, NORM and HI
--  positions. This switch controls the ram air valve during
--  ground operation and unpressurized flight.
--  The temperature control switch, placarded TEMP CONTROL,
--  is a combination potentiometer and three position
--  rotary switch. The potentiometer portion of the switch,
--  labeled AUTO, is used for automatic temperature control.
--  To increase cockpit temperature, rotate the switch knob
--  towards HOT, to decrease cockpit temperature, rotate the
--  switch knob towards COLD. Rotating the switch knob to the
--  6 oclock position changes control to the manual mode. In
--  the manual mode, the rotary switch is spring loaded to off or
--  null at the MANUAL position. Rotating the switch clock-wise
--  or counterclockwise towards COLD or HOT results in
--  directional control of the heat exchanger bypass valve,
--  resulting in warmer or cooler temperatures. Power for the
--  environmental control panel and temperature controller is
--  provided through a circuit breaker placarded CKPT TEMP,
--  located on the generator bus circuit breaker panel in the
--  front cockpit.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------

private package Jpats_Environmental.Air_Conditioner_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Environmental.Air_Conditioner_Controller;
