-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Cockpit_Temperature_Controller_G is

   --------------
   -- Decrease --
   --------------

   function Decrease
     (An_Instance : in Instance)
      return Boolean
   is
   begin
      return An_Instance.Decrease;
   exception
      when others =>
         Log.Report(Package_Name & ".Decrease()");
         raise;
   end Decrease;

   --------------
   -- Increase --
   --------------

   function Increase
     (An_Instance : in Instance)
      return Boolean
   is
   begin
      return An_Instance.Increase;
   exception
      when others =>
         Log.Report(Package_Name & ".Increase()");
         raise;
   end Increase;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Increase := False;
      An_Instance.Decrease := False;
      An_Instance.Load := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".()");
         raise;
   end Initialize;

   ------------
   -- Update --
   ------------

   procedure Update
     (An_Instance       : in out Instance;
      Ckpt_Temp         : in     Temperature_Type;
      Temp_Demanded     : in     Temperature_Type;
      Voltage_In        : in     Boolean;
      Auto_In           : in     Boolean;
      Man_Cold          : in     Boolean;
      Man_Hot           : in     Boolean;
      Auto_Ovrheat_Malf : in     Boolean)
   is
   begin

      if Voltage_In and Auto_In then
         if Auto_Ovrheat_Malf then
            An_Instance.Increase := True;
            An_Instance.Decrease := False;
            An_Instance.Load     := 1.5;
         elsif Ckpt_Temp < Temp_Demanded then
            An_Instance.Increase := True;
            An_Instance.Decrease := False;
            An_Instance.Load     := 1.5;
         elsif Ckpt_Temp > Temp_Demanded then
            An_Instance.Increase := False;
            An_Instance.Decrease := True;
            An_Instance.Load     := 1.5;
         else
            An_Instance.Increase := False;
            An_Instance.Decrease := False;
            An_Instance.Load     := 0.0;
         end if;
      elsif Voltage_In and Man_Cold then
         null; --| don't know why controller needs man_cold in
      elsif Voltage_In and Man_Hot then
         null; --| don't know why controller needs man_hot in
      else
         An_Instance.Load     := 0.0;
         An_Instance.Increase := False;
         An_Instance.Decrease := False;
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   ----------
   -- Load --
   ----------

   function Load
     (An_Instance : in Instance)
      return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;




end Cockpit_Temperature_Controller_G;

