-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic

   type Altitude_Type is digits <>;
   type Temperature_Type is digits <>;
   type Flow_Rate_Type is digits <>;
   type Pressure_Type is digits <>;
   type Mass_Type is digits <>;
   type Volume_Type is digits <>;
   Volume : in Volume_Type;
   type Velocity_Type is digits <>;
   Package_Name : in String;

package Cockpit_Pressure_Vessel_G is

   type Instance is private;

   procedure Set_Differential_Pressure
     (An_Instance : in out Instance;
      Value       : in     Pressure_Type);
   procedure Set_Temperature
     (An_Instance : in out Instance;
      Value       : in     Temperature_Type);

   procedure Set_Flow_In
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type);
   procedure Set_Flow_Out
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type);
   procedure Set_Flow_In_For_Eng
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type);
   procedure Set_Flow_Out_For_Eng
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type);
   procedure Set_Bleed_Pressure
     (An_Instance    : in out Instance;
      Bleed_Pressure : in     Pressure_Type);
   procedure Set_Air_Mass
     (An_Instance : in out Instance;
      Mass        : in     Mass_Type);
   procedure Set_Air_Pressure
     (An_Instance : in out Instance;
      Pressure    : in     Pressure_Type);
   procedure Set_Pressure_Altitude
     (An_Instance : in out Instance;
      Altitude    : in     Altitude_Type);
   procedure Set_Rate_Of_Climb
     (An_Instance : in out Instance;
      Roc         : in     Velocity_Type);
   function Pressure_Altitude
     (An_Instance : in Instance)
      return Altitude_Type;
   function Pressure_Altitude_Last_Pass
     (An_Instance : in Instance)
      return Altitude_Type;
   function Differential_Pressure
     (An_Instance : in Instance)
      return Pressure_Type;
   function Temperature
     (An_Instance : in Instance)
      return Temperature_Type;
   function Bleed_Pressure
     (An_Instance : in Instance)
      return Pressure_Type;
   function Air_Mass
     (An_Instance : in Instance)
      return Mass_Type;
   function Air_Pressure
     (An_Instance : in Instance)
      return Pressure_Type;
   function Rate_Of_Climb
     (An_Instance : in Instance)
      return Velocity_Type;
   function Flow_Out
     (An_Instance : in Instance)
      return Flow_Rate_Type;
   function Flow_In
     (An_Instance : in Instance)
     return Flow_Rate_Type;
   function Flow_Out_For_Eng
     (An_Instance : in Instance)
      return Flow_Rate_Type;
   function Flow_In_For_Eng
     (An_Instance : in Instance)
     return Flow_Rate_Type;

   function Cockpit_Volume
     (An_Instance : in Instance)
     return Volume_Type;

   procedure Initialize
     (An_Instance : in out Instance);
private
   type Instance is
      record
         Flow_In               : Flow_Rate_Type;
         Flow_Out              : Flow_Rate_Type;
         Flow_In_For_Eng       : Flow_Rate_Type;
         Flow_Out_For_Eng      : Flow_Rate_Type;
         Air_Mass              : Mass_Type;
         Air_Pressure          : Pressure_Type;
         Pressure_Altitude     : Altitude_Type;
         Pressure_Altitude_Last_Pass : Altitude_Type;
         Differential_Pressure : Pressure_Type;
         Rate_Of_Climb         : Velocity_Type;

         Temperature           : Temperature_Type;
         Bleed_Pressure        : Pressure_Type;      -- pressure of flow into cockpit
      end record;
end Cockpit_Pressure_Vessel_G;
