-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Cockpit_Pressure_Vessel_G is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Flow_In                      := 0.0;
      An_Instance.Flow_Out                     := 0.0;
      An_Instance.Flow_In_For_Eng              := 0.0;
      An_Instance.Flow_Out_For_Eng             := 0.0;
      An_Instance.Air_Mass                     := 0.0;
      An_Instance.Air_Pressure                 := 0.0;
      An_Instance.Pressure_Altitude            := 0.0;
      An_Instance.Pressure_Altitude_Last_Pass  := 0.0;
      An_Instance.Differential_Pressure        := 0.0;
      An_Instance.Rate_Of_Climb                := 0.0;
      An_Instance.Temperature                  := 0.0;
      An_Instance.Bleed_Pressure               := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Set_Differential_Pressure
     (An_Instance : in out Instance;
      Value       : in     Pressure_Type)
   is
   begin
      An_Instance.Differential_Pressure := Value;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Differential_Pressure()");
         raise;
   end Set_Differential_Pressure;

   procedure Set_Temperature
     (An_Instance : in out Instance;
      Value       : in     Temperature_Type)
   is
   begin
     An_Instance.Temperature := Value;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Temperature()");
         raise;
   end Set_Temperature;

   procedure Set_Flow_In
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type)
   is
   begin
      An_Instance.Flow_In := Amount;
      An_Instance.Flow_Out := Amount;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Flow_In()");
         raise;
   end Set_Flow_In;

   procedure Set_Flow_Out
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type)
   is
   begin
      An_Instance.Flow_Out := Amount;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Flow_Out()");
         raise;
   end Set_Flow_Out;

   procedure Set_Flow_In_For_Eng
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type)
   is
   begin
      An_Instance.Flow_In_For_Eng := Amount;
      An_Instance.Flow_Out_For_Eng := Amount;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Flow_In_For_Eng()");
         raise;
   end Set_Flow_In_For_Eng;

   procedure Set_Flow_Out_For_Eng
     (An_Instance : in out Instance;
      Amount      : in     Flow_Rate_Type)
   is
   begin
      An_Instance.Flow_Out_For_Eng := Amount;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Flow_Out_For_Eng()");
         raise;
   end Set_Flow_Out_For_Eng;

   procedure Set_Bleed_Pressure
     (An_Instance    : in out Instance;
      Bleed_Pressure : in     Pressure_Type)
   is
   begin
      An_Instance.Bleed_Pressure := Bleed_Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Bleed_Pressure()");
         raise;
   end Set_Bleed_Pressure;

   procedure Set_Air_Mass
     (An_Instance : in out Instance;
      Mass        : in     Mass_Type)
   is
   begin
      An_Instance.Air_Mass := Mass;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Air_Mass()");
         raise;
   end Set_Air_Mass;

   procedure Set_Air_Pressure
     (An_Instance : in out Instance;
      Pressure    : in     Pressure_Type)
   is
   begin
      An_Instance.Air_Pressure := Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Air_Pressure()");
         raise;
   end Set_Air_Pressure;

   procedure Set_Pressure_Altitude
     (An_Instance : in out Instance;
      Altitude    : in     Altitude_Type)
   is
   begin
      An_Instance.Pressure_Altitude_Last_Pass := An_Instance.Pressure_Altitude;
      An_Instance.Pressure_Altitude := Altitude;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Pressure_Altitude()");
         raise;
   end Set_Pressure_Altitude;

   procedure Set_Rate_Of_Climb
     (An_Instance : in out Instance;
      Roc         : in     velocity_Type)
   is
   begin
      An_Instance.Rate_Of_Climb := Roc;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Rate_Of_Climb()");
         raise;
   end Set_Rate_Of_Climb;

   function Pressure_Altitude
     (An_Instance : in Instance)
     return Altitude_Type
   is
   begin
      return An_Instance.Pressure_Altitude;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure_Altitude()");
         raise;
   end Pressure_Altitude;

   function Pressure_Altitude_Last_Pass
     (An_Instance : in Instance)
     return Altitude_Type
   is
   begin
      return An_Instance.Pressure_Altitude_Last_Pass;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure_Altitude_Last_Pass()");
         raise;
   end Pressure_Altitude_Last_Pass;

   function Differential_Pressure
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Differential_Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Differential_Pressure()");
         raise;
   end Differential_Pressure;

   function Temperature
     (An_Instance : in Instance)
     return Temperature_Type
   is
   begin
      return An_Instance.Temperature;
   exception
      when others =>
         Log.Report(Package_Name & ".Temperature()");
         raise;
   end Temperature;

   function Bleed_Pressure
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Bleed_Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Bleed_Pressure()");
         raise;
   end Bleed_Pressure ;

   function Air_Mass
     (An_Instance : in Instance)
     return Mass_Type
   is
   begin
      return An_Instance.Air_Mass;
   exception
      when others =>
         Log.Report(Package_Name & ".Air_Mass()");
         raise;
   end Air_Mass;

   function Air_Pressure
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Air_Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Air_Pressure()");
         raise;
   end Air_Pressure;

   function Rate_Of_Climb
     (An_Instance : in Instance)
     return velocity_Type
   is
   begin
      return An_Instance.Rate_Of_Climb;
   exception
      when others =>
         Log.Report(Package_Name & ".Rate_Of_Climb()");
         raise;
   end Rate_Of_Climb;

   function Flow_Out
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_Out()");
         raise;
   end Flow_Out;

   function Flow_In
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_In;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_In()");
         raise;
   end Flow_In;

   function Flow_Out_For_Eng
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_Out_For_Eng;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_Out_For_Eng()");
         raise;
   end Flow_Out_For_Eng;


   function Flow_In_For_Eng
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_In_For_Eng;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_In_For_Eng()");
         raise;
   end Flow_In_For_Eng;


   function Cockpit_Volume
     (An_Instance : in Instance)
     return Volume_Type
   is
   begin
     return Volume;
   exception
      when others =>
         Log.Report(Package_Name & ".Cockpit_Volume()");
         raise;
   end Cockpit_Volume;

end Cockpit_Pressure_Vessel_G;
