-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Canopy_G is

   procedure Latch
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Latched := True;
   exception
      when others =>
         Log.Report(Package_Name & ".Latch()");
         raise;
   end Latch;

   procedure Unlatch
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Latched := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Unlatch()");
         raise;
   end Unlatch;

   function Is_Latched
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Latched;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Latched()");
         raise;
   end Is_Latched;

   function Is_Fractured
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Fractured;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Fractured()");
         raise;
   end Is_Fractured;


   procedure Update
     (An_Instance  : in out Instance;
      Latched      : in     Boolean;
      Latch_Malf   : in     Boolean;
      Fracture_Cmd : in     Boolean)

   is
   begin
      if Fracture_Cmd then
         An_Instance.Is_Fractured := True;
      else
         An_Instance.Is_Fractured := False;
      end if;

      if Latched and not Is_Latched (An_Instance) then
         Latch (An_Instance);
      elsif not Latched and Is_Latched (An_Instance) then
         Unlatch (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Latched := False;
      An_Instance.Is_Fractured := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


end Canopy_G;

