-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Bypass_Valve_G is

   procedure Open
     (An_Instance       : in out Instance;
      Amount            : in     Position_Type)
   is
   begin
      if Position_Type'Last - An_Instance.Position < Amount then
         An_Instance.Position := Position_Type'Last;
      else
         An_Instance.Position := An_Instance.Position + Amount;
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Close
     (An_Instance       : in out Instance;
      Amount            : in     Position_Type)
   is
   begin
      if An_Instance.Position - Position_Type'First < Amount then
         An_Instance.Position := Position_Type'First;
      else
         An_Instance.Position := An_Instance.Position - Amount;
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   function Position
     (An_Instance : in Instance)
     return Position_Type
   is
   begin
      return An_Instance.Position;
   exception
      when others =>
         Log.Report(Package_Name & ".Position()");
         raise;
   end Position;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Position := 0.0;
      An_Instance.Load     := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Load
     (An_Instance : in Instance)
     return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   function Full_Cold
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Position = Position_Type'First;
   exception
      when others =>
         Log.Report(Package_Name & ".()");
         raise;
   end Full_Cold;

   function Full_Hot
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Position = Position_Type'Last;
   exception
      when others =>
         Log.Report(Package_Name & ".Full_Hot()");
         raise;
   end Full_Hot;


   procedure Update
     (An_Instance     : in out Instance;
      Iconst          : in     Float;
      Cold_Pin        : in     Boolean;
      Hot_Pin         : in     Boolean)
   is

      Old_Position : constant Position_Type := An_Instance.Position;

   begin

      if Cold_Pin and Hot_Pin then
         null;
      elsif Cold_Pin and not (An_Instance.Position = Position_Type'First) then
         Close (An_Instance, ((Position_Type'Last-Position_Type'First)/(30.0))*Position_Type(Iconst));
      elsif Hot_Pin and not (An_Instance.Position = Position_Type'Last) then
         Open (An_Instance, ((Position_Type'Last-Position_Type'First)/(30.0))*Position_Type(Iconst));
      end if;

      if An_Instance.Position /= Old_Position then
         An_Instance.Load := 2.5;
      else
         An_Instance.Load := 0.0;
      end if;

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

end Bypass_Valve_G;




