-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Blower_G is

   procedure Turn_On
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State         := On;
      An_Instance.Load          := Engaged_Load;
      An_Instance.Flow_Rate_Out := Flow_Rate_When_On;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_On()");
         raise;
   end Turn_On;

   procedure Turn_Off
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State         := Off;
      An_Instance.Load          := 0.0;
      An_Instance.Flow_Rate_Out := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_Off()");
         raise;
   end Turn_Off;

   function State
     (An_Instance : in Instance)
     return State_Type
   is
   begin
      return An_Instance.State;
   exception
      when others =>
         Log.Report(Package_Name & ".State()");
         raise;
   end State;

   function Is_On
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = On;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

   function Is_Off
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Off;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Off()");
         raise;
   end Is_Off;

   function Load
     (An_Instance : in Instance)
     return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   function Flow_Rate_Out
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_Rate_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_Rate_Out()");
         raise;
   end Flow_Rate_Out;

   procedure Update
     (An_Instance : in out Instance;
      Power_In    : in     Boolean)
   is
   begin
      if Power_In and Is_Off (An_Instance) then
         Turn_On (An_Instance);
      elsif not Power_In and Is_On (An_Instance) then
         Turn_Off (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State         := Off;
      An_Instance.Load          := 0.0;
      An_Instance.Flow_Rate_Out := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

end ;
