-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Anti_Gravity_Valve_G is


   function Pressure_Out
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Pressure_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure_Out()");
         raise;
   end Pressure_Out;

   function Flow_Rate_Out
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_Rate_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_Rate_Out()");
         raise;
   end Flow_Rate_Out;

   function Pressure_Available
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Pressure_Out > 2.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure_Available()");
         raise;
   end Pressure_Available;

   procedure Update
     (An_Instance  : in out Instance;
      Pressure_In  : in     Pressure_Type;
      Flow_Rate_In : in     Flow_Rate_Type)
   is
   begin
      if Pressure_In > 7.0 then
         An_Instance.Pressure_Out := 7.0;
      else
         An_Instance.Pressure_Out := Pressure_In;
      end if;

      An_Instance.Flow_Rate_Out := Flow_Rate_In;

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Pressure_Out  := 0.0;
      An_Instance.Flow_Rate_Out := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


end Anti_Gravity_Valve_G;

