-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Current_Type is digits <>;
   Powered_Load : in Current_Type;
   type Pressure_Type is digits <>;
   type Flow_Rate_Type is digits <>;
   K_Open   : in Float;
   K_Closed : in Float;
   Package_Name : in String;
package Anti_Gravity_Shutoff_Valve_G is

   type Instance is private;

   procedure Update
     (An_Instance  : in out Instance;
      Power_In     : in     Boolean;
      Pressure_In  : in     Pressure_Type;
      Flow_Rate_In : in     Flow_Rate_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Pressure_Out
     (An_Instance : in Instance)
      return Pressure_Type;

   function Flow_Rate_Out
     (An_Instance : in Instance)
      return Flow_Rate_Type;

   function Load
     (An_Instance : in Instance)
     return Current_Type;

private

   type State_Type is (Closed,Open);

   type Instance is
      record
         State         : State_Type;
         Pressure_Out  : Pressure_Type;
         Flow_Rate_Out : Flow_Rate_Type;
         Load          : Current_Type;
         K             : Float;
      end record;

end Anti_Gravity_Shutoff_Valve_G;

