-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Anti_Gravity_Shutoff_Valve_G is

   function Pressure_Out
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Pressure_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure_Out()");
         raise;
   end Pressure_Out;

   function Flow_Rate_Out
     (An_Instance : in Instance)
     return Flow_Rate_Type
   is
   begin
      return An_Instance.Flow_Rate_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Flow_Rate_Out()");
         raise;
   end Flow_Rate_Out;

   function Load
     (An_Instance : in Instance)
     return Current_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   function Is_Closed
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Closed;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;

   function Is_Open
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Open;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

   procedure Close
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Closed;
      An_Instance.Load  := Powered_Load;
      An_Instance.K     := K_Closed;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   procedure Open
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Open;
      An_Instance.Load  := 0.0;
      An_Instance.K     := K_Open;
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Update
     (An_Instance  : in out Instance;
      Power_In     : in     Boolean;
      Pressure_In  : in     Pressure_Type;
      Flow_Rate_In : in     Flow_Rate_Type)
   is
   begin

      if Power_In and not Is_Closed (An_Instance) then
         Close (An_Instance);
      elsif not Power_In and not Is_Open (An_Instance) then
         Open (An_Instance);
      end if;

      An_Instance.Pressure_Out  := Pressure_In  * Pressure_Type (An_Instance.K);
      An_Instance.Flow_Rate_Out := Flow_Rate_In * Flow_Rate_Type (An_Instance.K);

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State         := Open;
      An_Instance.Pressure_Out  := 0.0;
      An_Instance.Flow_Rate_Out := 0.0;
      An_Instance.Load          := 0.0;
      An_Instance.K             := 1.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;



end Anti_Gravity_Shutoff_Valve_G;


