-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Altitude_Type is digits <>;
   Altitude_Threshold : in Altitude_Type;
   Package_Name : in String;
package Altitude_Switch_G is

   type Instance is private;

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance : in out Instance;
      Altitude    : in     Altitude_Type);

   function Is_Open
     (An_Instance : in Instance)
      return Boolean;

   function Is_Closed
     (An_Instance : in Instance)
      return Boolean;

private

   type State_Type is (Open, Closed);

   type Instance is
      record
         State : State_Type;
      end record;

end Altitude_Switch_G;
