-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic
   type Ampere_Type is digits <>;
   type Torque_Type is digits <>;
   type Rpm_Type is digits <>;
   type Shaft_Horsepower_Type is digits <>;
   Engaged_Load : in Ampere_Type;
   Engaged_Shaft_Horsepower : in Shaft_Horsepower_Type;
   Package_Name : in String;
package Ac_Compressor_G is

   type Instance is private;

   function Is_On
     (An_Instance : in Instance)
      return Boolean;

   function Is_Off
     (An_Instance : in Instance)
      return Boolean;

   function Load
     (An_Instance : in Instance)
      return Ampere_Type;

   function Torque
     (An_Instance : in Instance)
      return Torque_Type;

   function Shaft_Horsepower
     (An_Instance : in Instance)
      return Shaft_Horsepower_Type;

   procedure Update
     (An_Instance     : in out Instance;
      Engage_demanded : in     Boolean;
      Engine_Rpm      : in     Rpm_Type);

   procedure Initialize
     (An_Instance : in out Instance);

private

   type State_Type is (Off, On);

   type Instance is
      record
         State            : State_Type;
         Load             : Ampere_Type;
         Torque           : Torque_Type;
         Shaft_Horsepower : Shaft_Horsepower_Type;
      end record;

end Ac_Compressor_G;
