-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Engine_Data_Manager;
with Jpats_Engine_Data_Manager.Container;

package body Jpats_Engine_Data_Manager is

  -- Access Oil_Press_Lo_Signal
  function  Oil_Pressure_Annunciator_Request
    return Boolean is
  begin
    return Engine_Data_Manager.Oil_Press_Lo_Signal
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Oil_Pressure_Annunciator_Request;

  -- Access Auto_Balance_Fail_Output
  function  Auto_Balance_Fail_Output
    return Boolean is
  begin
    return Engine_Data_Manager.Auto_Balance_Fail_Output
      ( An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Auto_Balance_Fail_Output;

  -- Access Cockpit_Alt_Hi_Output
  function  Cockpit_Alt_Hi_Output
    return Boolean is
  begin
    return Engine_Data_Manager.Cockpit_Alt_Hi_Output
      ( An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Cockpit_Alt_Hi_Output;

  -- Access Cockpit_Press_Hi_Output
  function  Cockpit_Press_Hi_Output
    return Boolean is
  begin
    return Engine_Data_Manager.Cockpit_Press_Hi_Output
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Cockpit_Press_Hi_Output;

  -- Access Hyd_Press_Lo_Output
  function  Hyd_Press_Lo_Output
    return Boolean is
  begin
    return Engine_Data_Manager.Hyd_Press_Lo_Output
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Hyd_Press_Lo_Output;

  -- Access Left_Transfer_Valve_Out
  function  Left_Transfer_Valve_Out
    return Boolean is
  begin
    return Engine_Data_Manager.Left_Transfer_Valve_Out
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Left_Transfer_Valve_Out;

  -- Access Right_Transfer_Valve_Out
  function  Right_Transfer_Valve_Out
    return Boolean is
  begin
    return Engine_Data_Manager.Right_Transfer_Valve_Out
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Right_Transfer_Valve_Out;

  -- Access Collector_Fuel_Quantity
  function  Collector_Fuel_Quantity
    return Mass_Types.Lbm is
  begin
    return Engine_Data_Manager.Collector_Fuel_Quantity
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Collector_Fuel_Quantity;

  -- Access Left_Fuel_Quantity
  function  Left_Fuel_Quantity
    return Mass_Types.Lbm is
  begin
    return Engine_Data_Manager.Left_Fuel_Quantity
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Left_Fuel_Quantity;

  -- Access Right_Fuel_Quantity
  function  Right_Fuel_Quantity
    return Mass_Types.Lbm is
  begin
    return Engine_Data_Manager.Right_Fuel_Quantity
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Right_Fuel_Quantity;

  -- Access Nose Wheel Steering Enable
  function Nws_Enable
    return Boolean is
  begin
    return Engine_Data_Manager.Nws_Enable
      (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end Nws_Enable;

  -- Access A429_TX_EDM_A_302_N1
  function  A429_TX_EDM_A_302_N1
    return Arinc_429_Types.Message_Type is
  begin
     return Engine_Data_Manager.A429_TX_EDM_A_302_N1
       (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end A429_TX_EDM_A_302_N1;

  -- Access A429_TX_EDM_A_317_Oil_Pressure
  function  A429_TX_EDM_A_317_Oil_Pressure
    return Arinc_429_Types.Message_Type is
  begin
     return Engine_Data_Manager.A429_TX_EDM_A_317_Oil_Pressure
       (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end A429_TX_EDM_A_317_Oil_Pressure;

  -- Access A429_TX_EDM_B_302_N1
  function  A429_TX_EDM_B_302_N1
    return Arinc_429_Types.Message_Type is
  begin
     return Engine_Data_Manager.A429_TX_EDM_B_302_N1
       (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end A429_TX_EDM_B_302_N1;

  -- Access A429_TX_EDM_B_317_Oil_Pressure
  function  A429_TX_EDM_B_317_Oil_Pressure
    return Arinc_429_Types.Message_Type is
  begin
     return Engine_Data_Manager.A429_TX_EDM_B_317_Oil_Pressure
       (An_Instance => Container.This_Subsystem.The_Engine_Data_Manager);
  end A429_TX_EDM_B_317_Oil_Pressure;

end Jpats_Engine_Data_Manager;









