--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------
with Normalized_Types;
with Temperature_Types;
with Force_Types;
with Electrical_Units_Types;
with Length_Types;
with Mass_Types;

package JPATS_Engine_Data_Manager.Ios_Interface is

  type Instance is record
    Engine_Torque_Percent                 : Normalized_Types.Normalize;
    Propeller_Speed_Percent               : Normalized_Types.Normalize;
    Gas_Generator_Speed_Percent           : Normalized_Types.Normalize;
    Internal_Turbine_Temperature          : Temperature_Types.Celsius;
    Outside_Air_Temperature               : Temperature_Types.Celsius;
    Oil_Temperature                       : Temperature_Types.Celsius;
    Oil_Pressure                          : Force_Types.Psi;
    Hydraulic_Pressure                    : Force_Types.Psi;
    DC_Volts                              : Electrical_Units_Types.Volts_DC;
    DC_Amps                               : Electrical_Units_Types.Amps;
    Raw_Internal_Turbine_Temperature      : Temperature_Types.Celsius;
    Cockpit_Altitude                      : Length_Types.Feet;
    Fuel_Flow                             : Mass_Types.Pph;
    Differential_Pressure                 : Force_Types.Psi;
    Left_Fuel_Quantity                    : Mass_Types.Lbm;
    Right_Fuel_Quantity                   : Mass_Types.Lbm;
    Alternate_Gas_Generator_Speed_Percent : Normalized_Types.Normalize;
    Alternate_Engine_Torque_Percent       : Normalized_Types.Normalize;
    Mfav07                                : Boolean;
    Mfhy04                                : Boolean;
    Mffu06                                : Boolean;
    A_Ram_Self_Test_Failure               : Boolean;
    A_Arinc_Self_Test_Failure             : Boolean;
    A_Program_Integrity_Failure           : Boolean;
    A_Power_Supply_Failure                : Boolean;
    Left_Ob_Probe_Fail                    : Boolean;
    Left_Mid_Probe_Fail                   : Boolean;
    Left_Ib_Probe_Fail                    : Boolean;
    Right_Ob_Probe_Fail                   : Boolean;
    Right_Mid_Probe_Fail                  : Boolean;
    Right_Ib_Probe_Fail                   : Boolean;
    Collector_Probe_Fail                  : Boolean;
    B_Ram_Self_Test_Failure               : Boolean;
    B_Arinc_Self_Test_Failure             : Boolean;
    B_Program_Integrity_Failure           : Boolean;
    B_Power_Supply_Failure                : Boolean;
    Vm_Fail                               : Boolean;
    Vp_Fail                               : Boolean;
    Vdd_Fail                              : Boolean;
    Vin_Fail                              : Boolean;
    Edm_Channel_Id                        : Boolean;
    Anti_Ice                              : Boolean;
    Weight_On_Wheels                      : Boolean;
    Aed_Power                             : Boolean;
  end record;

  This_Ios_Interface : Instance;

  procedure Register_Ios_Variables;

end Jpats_Engine_Data_Manager.Ios_Interface;

