-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------
with Jpats_Ios_Interface;

package body JPATS_Engine_Data_Manager.Ios_Interface is

   procedure Mfav07
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfav07 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfav07;

   procedure Mfhy04
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfhy04 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfhy04;

   procedure Mffu06
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mffu06 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mffu06;

  procedure Register_Ios_Variables is

  begin
    -- Simulation Labels needed by IOS that are Arinc 429 on
    -- actual aircraft hardware.
    Jpats_Ios_Interface.Register
      ( Name        => "Engine_Torque_Percent",
        Variable    => This_Ios_Interface.Engine_Torque_Percent'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Propeller_Speed_Percent",
        Variable    => This_Ios_Interface.Propeller_Speed_Percent'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Gas_Generator_Speed_Percent",
        Variable    => This_Ios_Interface.Gas_Generator_Speed_Percent'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Internal_Turbine_Temperature",
        Variable    => This_Ios_Interface.Internal_Turbine_Temperature'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Outside_Air_Temperature",
        Variable    => This_Ios_Interface.Outside_Air_Temperature'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Oil_Temperature",
        Variable    => This_Ios_Interface.Oil_Temperature'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Oil_Pressure",
        Variable    => This_Ios_Interface.Oil_Pressure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Hydraulic_Pressure",
        Variable    => This_Ios_Interface.Hydraulic_Pressure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "DC_Volts",
        Variable    => This_Ios_Interface.DC_Volts'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "DC_Amps",
        Variable    => This_Ios_Interface.DC_Amps'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Raw_Internal_Turbine_Temperature",
        Variable    => This_Ios_Interface.Raw_Internal_Turbine_Temperature'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Cockpit_Altitude",
        Variable    => This_Ios_Interface.Cockpit_Altitude'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Fuel_Flow",
        Variable    => This_Ios_Interface.Fuel_Flow'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Differential_Pressure",
        Variable    => This_Ios_Interface.Differential_Pressure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Left_Fuel_Quantity",
        Variable    => This_Ios_Interface.Left_Fuel_Quantity'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Right_Fuel_Quantity",
        Variable    => This_Ios_Interface.Right_Fuel_Quantity'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Alternate_Engine_Torque_Percent",
        Variable    => This_Ios_Interface.Alternate_Engine_Torque_Percent'Address );

    Jpats_Ios_Interface.Register
      ( Name         => "Alternate_Gas_Generator_Speed_Percent",
        Variable    => This_Ios_Interface.Alternate_Gas_Generator_Speed_Percent'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "A_Ram_Self_Test_Failure",
        Variable    => This_Ios_Interface.A_Ram_Self_Test_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "A_Arinc_Self_Test_Failure",
        Variable    => This_Ios_Interface.A_Arinc_Self_Test_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "A_Program_Integrity_Failure",
        Variable    => This_Ios_Interface.A_Program_Integrity_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "A_Power_Supply_Failure",
        Variable    => This_Ios_Interface.A_Power_Supply_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Left_Ob_Probe_Fail",
        Variable    => This_Ios_Interface.Left_Ob_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Left_Mid_Probe_Fail",
        Variable    => This_Ios_Interface.Left_Mid_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Left_Ib_Probe_Fail",
        Variable    => This_Ios_Interface.Left_Ib_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Right_Ob_Probe_Fail",
        Variable    => This_Ios_Interface.Right_Ob_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Right_Mid_Probe_Fail",
        Variable    => This_Ios_Interface.Right_Mid_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Right_Ib_Probe_Fail",
        Variable    => This_Ios_Interface.Right_Ib_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Collector_Probe_Fail",
        Variable    => This_Ios_Interface.Collector_Probe_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "B_Ram_Self_Test_Failure",
        Variable    => This_Ios_Interface.B_Ram_Self_Test_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "B_Arinc_Self_Test_Failure",
        Variable    => This_Ios_Interface.B_Arinc_Self_Test_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "B_Program_Integrity_Failure",
        Variable    => This_Ios_Interface.B_Program_Integrity_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "B_Power_Supply_Failure",
        Variable    => This_Ios_Interface.B_Power_Supply_Failure'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Vm_Fail",
        Variable    => This_Ios_Interface.Vm_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Vp_Fail",
        Variable    => This_Ios_Interface.Vp_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Vdd_Fail",
        Variable    => This_Ios_Interface.Vdd_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Vin_Fail",
        Variable    => This_Ios_Interface.Vin_Fail'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Edm_Channel_Id",
        Variable    => This_Ios_Interface.Edm_Channel_Id'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Anti_Ice",
        Variable    => This_Ios_Interface.Anti_Ice'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Weight_On_Wheels",
        Variable    => This_Ios_Interface.Weight_On_Wheels'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "Aed_Power",
        Variable    => This_Ios_Interface.Aed_Power'Address );

    Jpats_Ios_Interface.Register
      ( Name        => "MFAV07",
        Variable    => This_Ios_Interface.mfav07'Address,
        Set_Routine => Mfav07'Access );

    Jpats_Ios_Interface.Register
      ( Name        => "MFHY04",
        Variable    => This_Ios_Interface.mfhy04'Address,
        Set_Routine => Mfhy04'Access );

    Jpats_Ios_Interface.Register
      ( Name        => "MFFU06",
        Variable    => This_Ios_Interface.mffu06'Address,
        Set_Routine => Mffu06'Access );

  end Register_Ios_Variables;

end Jpats_Engine_Data_Manager.Ios_Interface;







