--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------
with Arinc_429_Types;
with Interfaces.C;

private package JPATS_Engine_Data_Manager.Io_Interface is

  type Instance is record
    Primary_Eid_Pwr             : Boolean;
    Secondary_Eid_Pwr           : Boolean;
    Alternate_Eid_Pwr           : Boolean;
    A429_TX_EDM_A_101           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_103           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_130           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_174           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_203           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_243           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_244           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_256           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_257           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_270           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_301           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_302           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_316           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_317           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_336           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_344           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_345           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_346           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_A_350           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_101           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_103           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_130           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_174           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_203           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_243           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_244           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_256           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_257           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_270           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_301           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_302           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_316           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_317           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_336           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_344           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_345           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_346           : Arinc_429_Types.Message_Type;
    A429_TX_EDM_B_350           : Arinc_429_Types.Message_Type;
  end record;

  Io_Size : constant := Interfaces.C.Int'Size;

  for Instance use record
    Primary_Eid_Pwr             at 000*Io_Size range 0 .. 31;
    Secondary_Eid_Pwr           at 001*Io_Size range 0 .. 31;
    Alternate_Eid_Pwr           at 002*Io_Size range 0 .. 31;
    A429_TX_EDM_A_101           at 003*Io_Size range 0 .. 31;
    A429_TX_EDM_A_103           at 004*Io_Size range 0 .. 31;
    A429_TX_EDM_A_130           at 005*Io_Size range 0 .. 31;
    A429_TX_EDM_A_174           at 006*Io_Size range 0 .. 31;
    A429_TX_EDM_A_203           at 007*Io_Size range 0 .. 31;
    A429_TX_EDM_A_243           at 008*Io_Size range 0 .. 31;
    A429_TX_EDM_A_244           at 009*Io_Size range 0 .. 31;
    A429_TX_EDM_A_256           at 010*Io_Size range 0 .. 31;
    A429_TX_EDM_A_257           at 011*Io_Size range 0 .. 31;
    A429_TX_EDM_A_270           at 012*Io_Size range 0 .. 31;
    A429_TX_EDM_A_301           at 013*Io_Size range 0 .. 31;
    A429_TX_EDM_A_302           at 014*Io_Size range 0 .. 31;
    A429_TX_EDM_A_316           at 015*Io_Size range 0 .. 31;
    A429_TX_EDM_A_317           at 016*Io_Size range 0 .. 31;
    A429_TX_EDM_A_336           at 017*Io_Size range 0 .. 31;
    A429_TX_EDM_A_344           at 018*Io_Size range 0 .. 31;
    A429_TX_EDM_A_345           at 019*Io_Size range 0 .. 31;
    A429_TX_EDM_A_346           at 020*Io_Size range 0 .. 31;
    A429_TX_EDM_A_350           at 021*Io_Size range 0 .. 31;
    A429_TX_EDM_B_101           at 022*Io_Size range 0 .. 31;
    A429_TX_EDM_B_103           at 023*Io_Size range 0 .. 31;
    A429_TX_EDM_B_130           at 024*Io_Size range 0 .. 31;
    A429_TX_EDM_B_174           at 025*Io_Size range 0 .. 31;
    A429_TX_EDM_B_203           at 026*Io_Size range 0 .. 31;
    A429_TX_EDM_B_243           at 027*Io_Size range 0 .. 31;
    A429_TX_EDM_B_244           at 028*Io_Size range 0 .. 31;
    A429_TX_EDM_B_256           at 029*Io_Size range 0 .. 31;
    A429_TX_EDM_B_257           at 030*Io_Size range 0 .. 31;
    A429_TX_EDM_B_270           at 031*Io_Size range 0 .. 31;
    A429_TX_EDM_B_301           at 032*Io_Size range 0 .. 31;
    A429_TX_EDM_B_302           at 033*Io_Size range 0 .. 31;
    A429_TX_EDM_B_316           at 034*Io_Size range 0 .. 31;
    A429_TX_EDM_B_317           at 035*Io_Size range 0 .. 31;
    A429_TX_EDM_B_336           at 036*Io_Size range 0 .. 31;
    A429_TX_EDM_B_344           at 037*Io_Size range 0 .. 31;
    A429_TX_EDM_B_345           at 038*Io_Size range 0 .. 31;
    A429_TX_EDM_B_346           at 039*Io_Size range 0 .. 31;
    A429_TX_EDM_B_350           at 040*Io_Size range 0 .. 31;
  end record;

  This_Io_Interface : Instance;

  procedure Register_Io_Variables;

end Jpats_Engine_Data_Manager.Io_Interface;
