-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------
with Jpats_Io;
with Io_Types;
with Jpats_Io_Types;

package body JPATS_Engine_Data_Manager.Io_Interface is


  procedure Register_Io_Variables is

  begin

    -- Map Primary_Eid_Pwr
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "PEID_28VDC_PWR",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.Primary_Eid_Pwr'Address,
       A_Size          => This_Io_Interface.Primary_Eid_Pwr'Size );

    -- Map Secondary_Eid_Pwr
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "SEID_28VDC_PWR",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.Secondary_Eid_Pwr'Address,
       A_Size          => This_Io_Interface.Secondary_Eid_Pwr'Size );

    -- Map Secondary_Eid_Pwr
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "FCWEID_28VDC_PWR",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.Alternate_Eid_Pwr'Address,
       A_Size          => This_Io_Interface.Alternate_Eid_Pwr'Size );


    -- Arinc 429 Driver
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l101",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_101'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_101'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l101",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_101'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_101'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l103",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_103'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_103'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l103",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_103'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_103'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l130",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_130'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_130'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l130",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_130'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_130'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l174",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_174'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_174'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l174",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_174'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_174'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l203",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_203'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_203'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l203",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_203'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_203'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l243",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_243'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_243'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l243",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_243'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_243'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l244",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_244'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_244'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l244",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_244'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_244'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l256",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_256'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_256'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l256",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_256'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_256'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l257",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_257'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_257'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l257",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_257'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_257'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l270",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_270'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_270'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l270",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_270'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_270'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l301",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_301'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_301'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l301",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_301'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_301'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l302",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_302'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_302'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l302",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_302'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_302'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l316",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_316'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_316'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l316",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_316'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_316'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l317",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_317'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_317'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l317",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_317'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_317'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l336",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_336'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_336'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l336",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_336'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_336'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l344",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_344'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_344'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l344",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_344'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_344'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l345",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_345'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_345'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l345",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_345'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_345'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l346",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_346'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_346'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l346",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_346'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_346'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_a_l350",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_A_350'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_A_350'Size );

    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_a429_edm_b_l350",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.A429_TX_EDM_B_350'Address,
       A_Size          => This_Io_Interface.A429_TX_EDM_B_350'Size );

  end Register_Io_Variables;

end Jpats_Engine_Data_Manager.Io_Interface;
