-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Engine_Data_Manager;
with Jpats_Engine_Data_Manager.Io_Interface;
with Jpats_Engine_Data_Manager.Ios_Interface;
with Temperature_Types;
with Normalized_Types;
with Mass_Types;
with Length_Types;
with Force_Types;
with Angle_Types;
with Electrical_Units_Types;
with Jpats_Powerplant;
with Jpats_Propeller;
with Jpats_Propeller_Types;
with Arinc_429_Types;
with Jpats_Engine_Data_Manager.Container;
with Engine_Data_Manager_Arinc_Labels;
with Jpats_Fuel;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;
with Jpats_Hydraulics;
with Jpats_Environmental;
with Jpats_Engine_Data_Manager_Types;
-- with Log;
package body Jpats_Engine_Data_Manager.Controller is

  package A429 renames Engine_Data_Manager_Arinc_Labels;
  package Edm_T renames Jpats_Engine_Data_Manager_Types;
  No_Discretes : Arinc_429_Types.No_Discretes_Type;

  procedure Update
    (Next_Subsystem : in out Jpats_Engine_Data_Manager.Container.Instance_Ptr;
     This_Subsystem : in     Jpats_Engine_Data_Manager.Container.Instance_Ptr;
     Iconst         : in     Float )

  is

--  Sdi                    : A429.Edm_Bnr_Sdi_Type;
    Sdi                    : Edm_T.Edm_Bnr_Sdi_Type;
    Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;

    Alternate_Itt_Input_Hi                     : Temperature_Types.Celsius       := Jpats_Powerplant.Internal_Turbine_Temperature; -- := Itt Sensor On Engine  Terminal Block 7731TB1
    Alternate_N1_Input_Hi                      : Angle_Types.Rpm                 := Jpats_Powerplant.Gas_Generator_Speed_Sensor;          -- := 76-11-03 W311(WH)
    Anti_Ice_On                                : Boolean                         := False;
    Auto_Balance_Selected                      : Boolean                         := Jpats_Fuel.Auto_Balance_Selected;
    Bat_Bus_28_VDC                             : Boolean                         := Jpats_Electrical.Is_Powered(Jpats_Electrical_Types.Edm_Cb_Fwd_Batt_Bus);
    Collector_Probe_0_Signal                   : Mass_Types.Lbm                  := Jpats_Fuel.Collector_Probe_Quantity;
    Collector_Probe_0_Signal_Fail              : Boolean                         := False;
    DC_Amps                                    : Electrical_Units_Types.Amps     := Jpats_Electrical.Display_Load;
    Dc_Volts                                   : Electrical_Units_Types.Volts_DC := Jpats_Electrical.Display_Voltage;
    Fuel_Balance_28_VDC                        : Boolean                         := Jpats_Electrical.Is_Powered(Jpats_Electrical_Types.Fuel_Bal_Cb);
    Fuel_Flow_Input_Hi                         : Mass_Types.Pph                  := Jpats_Powerplant.Fuel_Flow;
    Gen_Bus_28_Vdc                             : Boolean                         := Jpats_Electrical.Is_Powered(Jpats_Electrical_Types.Edm_Cb_Fwd_Gen_Bus);
    Hyd_Press_Input_Hi                         : Force_Types.Psi                 := Jpats_Hydraulics.Primary_Hyd_Px
                                                                                     *Float(Boolean'Pos(not Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Mfhy04))
                                                                                     *Float(Boolean'Pos(Jpats_Electrical.Is_Powered(Jpats_Electrical_Types.Hyd_Sys_Cb))); -- 73-31-01 W192Wh
    L_Fuel_Probe_1_Signal                      : Mass_Types.Lbm                  := Jpats_Fuel.Left_Inside_Probe_Quantity;
    L_Fuel_Probe_3_Signal                      : Mass_Types.Lbm                  := Jpats_Fuel.Left_Middle_Probe_Quantity;     --               29-31.01 W169(Wh)
    L_Fuel_Probe_5_Signal                      : Mass_Types.Lbm                  := Jpats_Fuel.Left_Outside_Probe_Quantity;    --               28-41-01
    L_Fuel_Probe_5_Fail                        : Boolean                         := Jpats_Fuel.Left_Outside_Probe_Failed or Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Mffu06;
    L_Fuel_Probe_3_Fail                        : Boolean                         := Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Mffu06;
    L_Fuel_Probe_1_Fail                        : Boolean                         := Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Mffu06;
    L_Wheel_Spd_Sig_Hi                         : Float                           := 0.0;                    --               28-41-01
    Oil_Press_Input_Hi                         : Force_Types.Psi                 := Jpats_Powerplant.Engine_Oil_Pressure_Transducer;     -- : in     -- pin 28-41-01
    Oil_Temp_Signal_Hi                         : Temperature_Types.Celsius       := Jpats_Powerplant.Engine_Oil_Temperature_Transducer;  -- : in     -- pin 32-62-01 W301(WH)
    A429_TX_PMU_A_336_Engine_Torque            : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_A_336_Torque;           -- : in     -- Label 336
    A429_TX_PMU_A_344_Engine_Rpm               : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_A_344_N1;              -- : in     -- Label 344
    A429_TX_PMU_A_345_Engine_ITT               : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_A_345_ITT;              -- : in     -- Label 345
    A429_TX_PMU_A_346_Propeller_Rpm            : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_A_346_Np;           -- : in     -- Label 346
    A429_TX_PMU_A_130_Outside_Air_Temperature  : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_A_130_Outside_Air_Temperature; -- : in     -- Label 130
    A429_TX_PMU_A_134_Power_Lever_Angle        : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_A_134_Pla;       -- : in     -- Label 134
    A429_TX_PMU_B_336_Engine_Torque            : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_B_336_Torque;           -- : in     -- Label 336
    A429_TX_PMU_B_344_Engine_Rpm               : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_B_344_N1;              -- : in     -- Label 344
    A429_TX_PMU_B_345_Engine_ITT               : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_B_345_ITT;              -- : in     -- Label 345
    A429_TX_PMU_B_346_Propeller_Rpm            : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_B_346_Np;           -- : in     -- Label 346
    A429_TX_PMU_B_130_Outside_Air_Temperature  : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_B_130_Outside_Air_Temperature; -- : in     -- Label 130
    A429_TX_PMU_B_134_Power_Lever_Angle        : Arinc_429_Types.Message_Type    := Jpats_Powerplant.A429_TX_PMU_B_134_Pla;       -- : in     -- Label 134
    R_Fuel_Probe_2_Signal                      : Mass_Types.Lbm                  := Jpats_Fuel.Right_Inside_Probe_Quantity;  -- 28-41-01
    R_Fuel_Probe_4_Signal                      : Mass_Types.Lbm                  := Jpats_Fuel.Right_Middle_Probe_Quantity;
    R_Fuel_Probe_6_Signal                      : Mass_Types.Lbm                  := Jpats_Fuel.Right_Outside_Probe_Quantity;
    R_Fuel_Probe_2_Fail                        : Boolean                         := Jpats_Fuel.Right_Inside_Probe_Failed;
    R_Wheel_Spd_Sig_Hi                         : Float                           := 0.0;
    Weight_On_Wheels                           : Boolean                         := Jpats_Landing_Gear.Is_Open(Jpats_Landing_Gear_Types.Right_Landing_Gear_A2_WOW_Relay);
    Cockpit_Pressure_Altitude                  : Length_Types.Feet               := Jpats_Environmental.Ckpt_Alt;  -- 32-62-02 W311(WH)
    Cockpit_Differential_Pressure              : Force_Types.Psi                 := Jpats_Environmental.Diff_Px;
    Edm_Test                                   : Boolean                         := False;
    Edm_Fail                                   : Boolean                         := Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Mfav07; -- JPATS_Powerplant.Edm_Data_Bus_Fail;
--    Auto_Balance_Fail_Command                  : Boolean                         := Jpats_Fuel.Auto_Balance_Fail_Command;
    Auto_Balance_Fail_Malfunction              : Boolean                         := JPATS_Fuel.Mffu03;
  begin

        -- Power the Engine Instrument Displays based on the Circuit Breakers.
    Jpats_Engine_Data_Manager.Io_Interface.This_Io_Interface.Primary_EID_Pwr
      := Jpats_Electrical.Is_Powered(Name => Jpats_Electrical_Types.Pri_Eng_Dis_Cb);
    Jpats_Engine_Data_Manager.Io_Interface.This_Io_Interface.Secondary_EID_Pwr
      := Jpats_Electrical.Is_Powered(Name => Jpats_Electrical_Types.Alt_Eng_Dis_Cb);
    Jpats_Engine_Data_Manager.Io_Interface.This_Io_Interface.Alternate_EID_Pwr
      := Jpats_Electrical.Is_Powered(Name => Jpats_Electrical_Types.Eng_Sys_Dis_Cb);

    -- IOS flag to gray out the AED on the instrument repeater page
    Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Aed_Power
      := Jpats_Electrical.Is_Powered(Name => Jpats_Electrical_Types.Alt_Eng_Dis_Cb);

--    Log.Report("Controller: The battery cb is " & Boolean'Image(Bat_Bus_28_Vdc));
--    Log.Report("Controller: The generator cb is " & Boolean'Image(Gen_Bus_28_Vdc));
    -- Read External Category Data

    -- The Engine Data Manager class takes input, computes logic, and then packs
    -- results in to Arinc 429.
    Engine_Data_Manager.Update
      (Next_Instance                              => Next_Subsystem.The_Engine_Data_Manager,
       This_Instance                              => This_Subsystem.The_Engine_Data_Manager,
       Iconst                                     => Iconst,
       Alternate_Itt_Input_Hi                     => Alternate_Itt_Input_Hi,
       Alternate_N1_Input_Hi                      => Alternate_N1_Input_Hi,
       Anti_Ice_On                                => Anti_Ice_On,
       Auto_Balance_Selected                      => Auto_Balance_Selected,
       Bat_Bus_28_VDC                             => Bat_Bus_28_VDC,
       Collector_Probe_0_Signal                   => Collector_Probe_0_Signal,
       Collector_Probe_0_Signal_Malfunction       => Collector_Probe_0_Signal_Fail,
       DC_Amps                                    => DC_Amps,
       Dc_Volts                                   => Dc_Volts,
       Fuel_Balance_28_VDC                        => Fuel_Balance_28_VDC,
       Fuel_Flow_Input_Hi                         => Fuel_Flow_Input_Hi,
       Gen_Bus_28_Vdc                             => Gen_Bus_28_Vdc,
       Hyd_Press_Input_Hi                         => Hyd_Press_Input_Hi,
       L_Fuel_Probe_1_Signal                      => L_Fuel_Probe_1_Signal,
       L_Fuel_Probe_3_Signal                      => L_Fuel_Probe_3_Signal,
       L_Fuel_Probe_5_Signal                      => L_Fuel_Probe_5_Signal,
       L_Fuel_Probe_1_Signal_Malfunction          => L_Fuel_Probe_1_Fail,
       L_Fuel_Probe_3_Signal_Malfunction          => L_Fuel_Probe_3_Fail,
       L_Fuel_Probe_5_Signal_Malfunction          => L_Fuel_Probe_5_Fail,
       L_Wheel_Spd_Sig_Hi                         => L_Wheel_Spd_Sig_Hi,
       Oil_Press_Input_Hi                         => Oil_Press_Input_Hi,
       Oil_Temp_Signal_Hi                         => Oil_Temp_Signal_Hi,
       A429_RX_PMU_A_336_Engine_Torque            => A429_TX_PMU_A_336_Engine_Torque,
       A429_RX_PMU_A_344_Engine_Rpm               => A429_TX_PMU_A_344_Engine_Rpm,
       A429_RX_PMU_A_345_Engine_ITT               => A429_TX_PMU_A_345_Engine_ITT,
       A429_RX_PMU_A_346_Propeller_Rpm            => A429_TX_PMU_A_346_Propeller_Rpm,
       A429_RX_PMU_A_130_Outside_Air_Temperature  => A429_TX_PMU_A_130_Outside_Air_Temperature,
       A429_RX_PMU_A_134_Power_Lever_Angle        => A429_TX_PMU_A_134_Power_Lever_Angle,
       A429_RX_PMU_B_336_Engine_Torque            => A429_TX_PMU_B_336_Engine_Torque,
       A429_RX_PMU_B_344_Engine_Rpm               => A429_TX_PMU_B_344_Engine_Rpm,
       A429_RX_PMU_B_345_Engine_ITT               => A429_TX_PMU_B_345_Engine_ITT,
       A429_RX_PMU_B_346_Propeller_Rpm            => A429_TX_PMU_B_346_Propeller_Rpm,
       A429_RX_PMU_B_130_Outside_Air_Temperature  => A429_TX_PMU_B_130_Outside_Air_Temperature,
       A429_RX_PMU_B_134_Power_Lever_Angle        => A429_TX_PMU_B_134_Power_Lever_Angle,
       R_Fuel_Probe_2_Signal                      => R_Fuel_Probe_2_Signal,
       R_Fuel_Probe_4_Signal                      => R_Fuel_Probe_4_Signal,
       R_Fuel_Probe_6_Signal                      => R_Fuel_Probe_6_Signal,
       R_Fuel_Probe_2_Signal_Malfunction          => R_Fuel_Probe_2_Fail,
       R_Fuel_Probe_4_Signal_Malfunction          => False,
       R_Fuel_Probe_6_Signal_Malfunction          => False,
       R_Wheel_Spd_Sig_Hi                         => R_Wheel_Spd_Sig_Hi,
       Weight_On_Wheels                           => Weight_On_Wheels,
       Cockpit_Pressure_Altitude                  => Cockpit_Pressure_Altitude,
       Cockpit_Differential_Pressure              => Cockpit_Differential_Pressure,
       EDM_Test                                   => Edm_Test,
       EDM_Fail                                   => Edm_Fail,
       Auto_Balance_Fail_Malfunction              => Auto_Balance_Fail_Malfunction);





    -- Assign Labels to Io Interface
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_101
      := Engine_Data_Manager.A429_TX_EDM_A_101_Dc_Amps(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_103
      := Engine_Data_Manager.A429_TX_EDM_A_103_Dc_Volts(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_130
      := Engine_Data_Manager.A429_TX_EDM_A_130_Outside_Air_Temperature(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_174
      := Engine_Data_Manager.A429_TX_EDM_A_174_Hydraulic_Pressure(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_203
      := Engine_Data_Manager.A429_TX_EDM_A_203_Cockpit_Pressure_Altitude(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_243
      := Engine_Data_Manager.A429_TX_EDM_A_243_Cockpit_Differential_Pressure(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_244
      := Engine_Data_Manager.A429_TX_EDM_A_244_Fuel_Flow(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_256
      := Engine_Data_Manager.A429_TX_EDM_A_256_Left_Fuel_Quantity(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_257
      := Engine_Data_Manager.A429_TX_EDM_A_257_Right_Fuel_Quantity(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_270
      := Engine_Data_Manager.A429_TX_EDM_A_270_Engine_Data_Discretes(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_301
      := Engine_Data_Manager.A429_TX_EDM_A_301_ITT(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_302
      := Engine_Data_Manager.A429_TX_EDM_A_302_N1(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_316
      := Engine_Data_Manager.A429_TX_EDM_A_316_Oil_Temperature(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_317
      := Engine_Data_Manager.A429_TX_EDM_A_317_Oil_Pressure(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_336
      := Engine_Data_Manager.A429_TX_EDM_A_336_Engine_Torque(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_344
      := Engine_Data_Manager.A429_TX_EDM_A_344_Engine_Rpm(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_345
      := Engine_Data_Manager.A429_TX_EDM_A_345_Engine_ITT(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_346
      := Engine_Data_Manager.A429_TX_EDM_A_346_Propeller_Rpm(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_A_350
      := Engine_Data_Manager.A429_TX_EDM_A_350_Discrete_Diagnostics(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_101
      := Engine_Data_Manager.A429_TX_EDM_B_101_Dc_Amps(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_103
      := Engine_Data_Manager.A429_TX_EDM_B_103_Dc_Volts(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_130
      := Engine_Data_Manager.A429_TX_EDM_B_130_Outside_Air_Temperature(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_174
      := Engine_Data_Manager.A429_TX_EDM_B_174_Hydraulic_Pressure(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_203
      := Engine_Data_Manager.A429_TX_EDM_B_203_Cockpit_Pressure_Altitude(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_243
      := Engine_Data_Manager.A429_TX_EDM_B_243_Cockpit_Differential_Pressure(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_244
      := Engine_Data_Manager.A429_TX_EDM_B_244_Fuel_Flow(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_256
      := Engine_Data_Manager.A429_TX_EDM_B_256_Left_Fuel_Quantity(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_257
      := Engine_Data_Manager.A429_TX_EDM_B_257_Right_Fuel_Quantity(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_270
      := Engine_Data_Manager.A429_TX_EDM_B_270_Engine_Data_Discretes(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_301
      := Engine_Data_Manager.A429_TX_EDM_B_301_ITT(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_302
      := Engine_Data_Manager.A429_TX_EDM_B_302_N1(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_316
      := Engine_Data_Manager.A429_TX_EDM_B_316_Oil_Temperature(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_317
      := Engine_Data_Manager.A429_TX_EDM_B_317_Oil_Pressure(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_336
      := Engine_Data_Manager.A429_TX_EDM_B_336_Engine_Torque(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_344
      := Engine_Data_Manager.A429_TX_EDM_B_344_Engine_Rpm(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_345
      := Engine_Data_Manager.A429_TX_EDM_B_345_Engine_ITT(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_346
      := Engine_Data_Manager.A429_TX_EDM_B_346_Propeller_Rpm(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_350
      := Engine_Data_Manager.A429_TX_EDM_B_350_Discrete_Diagnostics(An_Instance => Next_Subsystem.The_Engine_Data_Manager);



    -- Assign Labels to Ios Interface
    A429.Label_101.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_101_Dc_Amps
                      (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_interface.This_Ios_Interface.Dc_Amps,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes);

    A429.Label_103.Unpack
      ( A_Message =>  Engine_Data_Manager.A429_TX_EDM_A_103_Dc_Volts
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_interface.This_Ios_Interface.Dc_Volts,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes);

    A429.Label_130.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_130_Outside_Air_Temperature
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Outside_Air_Temperature,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_174.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_174_Hydraulic_Pressure
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_interface.This_Ios_Interface.Hydraulic_Pressure,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes);

    A429.Label_203.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_203_Cockpit_Pressure_Altitude
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Cockpit_Altitude,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes);

    A429.Label_243.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_243_Cockpit_Differential_Pressure
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Differential_Pressure,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes);

    A429.Label_244.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_244_Fuel_Flow
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Fuel_Flow,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes);

    A429.Label_256.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_256_Left_Fuel_Quantity
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Left_Fuel_Quantity,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_257.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_257_Right_Fuel_Quantity
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Right_Fuel_Quantity,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    declare
      Label_270_Discrete : Engine_Data_Manager_Arinc_Labels.Label_270_Discrete_Type;
    begin

      A429.Label_270.Unpack
        (A_Message => Engine_Data_Manager.A429_Tx_EDM_A_270_Engine_Data_Discretes
                      (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
         A_Discretes_Value => Label_270_Discrete,
         A_Sdi     => Sdi,
         A_Ssm     => Ssm);

      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Vm_Fail                        := Label_270_Discrete.Vm_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Vp_Fail                        := Label_270_Discrete.Vp_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Vdd_Fail                       := Label_270_Discrete.Vdd_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Vin_Fail                       := Label_270_Discrete.Vin_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Edm_Channel_Id                 := Label_270_Discrete.Edm_Channel_Id;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Anti_Ice                       := Label_270_Discrete.Anti_Ice;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Weight_On_Wheels               := Label_270_Discrete.Weight_On_Wheels;

    end;

    A429.Label_301.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_301_ITT
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Raw_Internal_Turbine_Temperature,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_302.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_302_N1
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Alternate_Gas_Generator_Speed_Percent,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_316.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_316_Oil_Temperature
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Oil_Temperature,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_317.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_317_Oil_Pressure
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Oil_Pressure,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_336.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_336_Engine_Torque
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Engine_Torque_Percent,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_336.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_336_Engine_Torque
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Alternate_Engine_Torque_Percent,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_344.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_344_Engine_Rpm
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Gas_Generator_Speed_Percent,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    A429.Label_345.Unpack
      ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_345_Engine_ITT
                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Internal_Turbine_Temperature,
        A_Sdi     => Sdi,
        A_Ssm     => Ssm,
        A_Discretes_Value => No_Discretes );

    declare
      Tmp : Float;

    begin

      A429.Label_346.Unpack
        ( A_Message => Engine_Data_Manager.A429_TX_EDM_A_346_Propeller_Rpm
          (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
          A_Value   => Tmp,
          A_Sdi     => Sdi,
          A_Ssm     => Ssm,
          A_Discretes_Value => No_Discretes );

      Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Propeller_Speed_Percent := (Float'Rounding(Tmp/2.0)*2.0);
    end;

    declare
      Label_350_Discrete : Engine_Data_Manager_Arinc_Labels.Label_350_Discrete_Type;
    begin

      A429.Label_350.Unpack
        (A_Message => Engine_Data_Manager.A429_TX_EDM_A_350_Discrete_Diagnostics
                      (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
         A_Discretes_Value => Label_350_Discrete,
         A_Sdi     => Sdi,
         A_Ssm     => Ssm);

      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.A_Ram_Self_Test_Failure        := Label_350_Discrete.A_Ram_Self_Test_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.A_Arinc_Self_Test_Failure      := Label_350_Discrete.A_Arinc_Self_Test_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.A_Program_Integrity_Failure    := Label_350_Discrete.A_Program_Integrity_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.A_Power_Supply_Failure         := Label_350_Discrete.A_Power_Supply_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Left_Ob_Probe_Fail             := Label_350_Discrete.Left_Ob_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Left_Mid_Probe_Fail            := Label_350_Discrete.Left_Mid_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Left_Ib_Probe_Fail             := Label_350_Discrete.Left_Ib_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Right_Ob_Probe_Fail            := Label_350_Discrete.Right_Ob_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Right_Mid_Probe_Fail           := Label_350_Discrete.Right_Mid_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Right_Ib_Probe_Fail            := Label_350_Discrete.Right_Ib_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Collector_Probe_Fail           := Label_350_Discrete.Collector_Probe_Fail;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.B_Ram_Self_Test_Failure        := Label_350_Discrete.B_Ram_Self_Test_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.B_Arinc_Self_Test_Failure      := Label_350_Discrete.B_Arinc_Self_Test_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.B_Program_Integrity_Failure    := Label_350_Discrete.B_Program_Integrity_Failure;
      JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.B_Power_Supply_Failure         := Label_350_Discrete.B_Power_Supply_Failure;
    end;

--|     A429.Label_101.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_101_Dc_Amps
--|                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_interface.This_Ios_Interface.Dc_Amps,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes);
--|
--|     A429.Label_103.Unpack
--|       ( A_Message =>  Engine_Data_Manager.A429_TX_EDM_B_103_Dc_Volts
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_interface.This_Ios_Interface.Dc_Volts,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes);
--|
--|     A429.Label_130.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_130_Outside_Air_Temperature
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Outside_Air_Temperature,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_174.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_174_Hydraulic_Pressure
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_interface.This_Ios_Interface.Hydraulic_Pressure,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes);
--|
--|     A429.Label_203.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_203_Cockpit_Pressure_Altitude
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Cockpit_Altitude,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes);
--|
--|     A429.Label_243.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_243_Cockpit_Differential_Pressure
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Differential_Pressure,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes);
--|
--|     A429.Label_244.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_244_Fuel_Flow
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Fuel_Flow,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes);
--|
--|     A429.Label_256.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_256_Left_Fuel_Quantity
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Left_Fuel_Quantity,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_257.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_257_Right_Fuel_Quantity
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Right_Fuel_Quantity,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     -- discretes have many outputs
--| --    Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_270
--| --      := Engine_Data_Manager.A429_TX_EDM_B_270_Engine_Data_Discretes(An_Instance => Next_Subsystem.The_Engine_Data_Manager);
--|
--|     A429.Label_301.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_301_ITT
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Raw_Internal_Turbine_Temperature,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_302.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_302_N1
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Alternate_Gas_Generator_Speed_Percent,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_316.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_316_Oil_Temperature
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Oil_Temperature,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_317.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_317_Oil_Pressure
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Oil_Pressure,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|    A429.Label_336.Unpack
--|      ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_336_Engine_Torque
--|                       (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|        A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Engine_Torque_Percent,
--|        A_Sdi     => Sdi,
--|        A_Ssm     => Ssm,
--|        A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_336.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_336_Engine_Torque
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Alternate_Engine_Torque_Percent,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_344.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_344_Engine_Rpm
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Gas_Generator_Speed_Percent,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_345.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_345_Engine_ITT
--|                        (An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Internal_Turbine_Temperature,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     A429.Label_346.Unpack
--|       ( A_Message => Engine_Data_Manager.A429_TX_EDM_B_346_Propeller_Rpm(An_Instance => Next_Subsystem.The_Engine_Data_Manager),
--|         A_Value   => Jpats_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.Propeller_Speed_Percent,
--|         A_Sdi     => Sdi,
--|         A_Ssm     => Ssm,
--|         A_Discretes_Value => No_Discretes );
--|
--|     -- discretes have many outputs
--| --      Jpats_Engine_Data_Manager.Io_interface.This_Io_Interface.A429_TX_EDM_B_350
--| --      := Engine_Data_Manager.A429_TX_EDM_B_350_Discrete_Diagnostics(An_Instance => Next_Subsystem.The_Engine_Data_Manager);

  end Update;

  procedure Update
    ( Integration_Constant : in Float ) is

  begin

    --    JPATS_Powerplant.Auto_Test_Controller.Update
    --       (Next_Subsystem => Container.Next_Subsystem,
    --        This_Subsystem => Container.This_Subsystem,
    --        Iconst         => Integration_Constant);
    Update
      (Next_Subsystem => Container.Next_Subsystem,
       This_Subsystem => Container.This_Subsystem,
       Iconst         => Integration_Constant);

    Container.Swap_Ptr := Container.This_Subsystem;
    Container.This_Subsystem := Container.Next_Subsystem;
    Container.Next_Subsystem := Container.Swap_Ptr;
    Container.Next_Subsystem.all := Container.This_Subsystem.all;

  end Update;

  procedure Initialize
    (A_Subsystem : in out Jpats_Engine_Data_Manager.Container.Instance_Ptr)
  is

  begin

    Engine_Data_Manager.Initialize
      (An_Instance => A_Subsystem.The_Engine_Data_Manager);

  end Initialize;

  procedure Initialize is
  begin
    Initialize
      (A_Subsystem => Container.Next_Subsystem);
    Initialize
      (A_Subsystem => Container.This_Subsystem);

  end Initialize;


end Jpats_Engine_Data_Manager.Controller;














