-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--            Keith H. Rehm
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Arinc_429_Types;
with Arinc_429_Bnr;
with Arinc_429_Discrete;
with Jpats_Engine_Data_Manager_Types;

package Engine_Data_Manager_Arinc_Labels is

  --
  -- Ada LRM 13.2 describes Boolean types as always
  -- represented as 1 bit.  If any other types, i.e.
  -- enumerated types are used, a "For" Use" statement
  -- may be needed for the discrete type.  Otherwise,
  -- a simple pragma pack command should suffice.
  --

-- In Jpats_Engine_Data_Manager_Types:
--     type Edm_Bnr_Sdi_Type is
--       ( Not_Used, Channel_A, Channel_B, Not_Used_3);
   package Edm_T renames Jpats_Engine_Data_Manager_Types;


  -- Engine Torque
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 17 - 28 Engine Torque / 0.0625 % Torque
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_336_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--   for Label_336_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_336_Discrete_Type'Size use 6;
  package Label_336 is new Arinc_429_Bnr
    ( Label              => 8#336#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Engine Rpm - N1
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 15 - 28 Engine Rpm / 0.015625 % rpm
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_344_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--  end record;
--
--   for Label_344_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--   end record;
--
--  for Label_344_Discrete_Type'Size use 4;
  package Label_344 is new Arinc_429_Bnr
    ( Label              => 8#344#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 14,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type );

  ----------------------------------------------------------------
  -- Interstage Turbine Temperature
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Itt / 0.5 deg C
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_345_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--   for Label_345_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_345_Discrete_Type'Size use 6;
  package Label_345 is new Arinc_429_Bnr
    ( Label              => 8#345#,
      Value_Type         => Float,
      Scale              => 2048.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Propeller RPM - Np
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 15 - 28 Prop rpm  / 0.015625  % rpm
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_346_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--  end record;
--
--   for Label_346_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--   end record;
--
--  for Label_346_Discrete_Type'Size use 4;
  package Label_346 is new Arinc_429_Bnr
    ( Label              => 8#346#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 14,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Outside Air Temperature
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 OAT/0.03125 Degrees C
  -- Bit 29      Sign Bit
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_130_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--   for Label_130_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_130_Discrete_Type'Size use 6;
  package Label_130 is new Arinc_429_Bnr
    ( Label              => 8#130#,
      Value_Type         => Float,
      Scale              => 128.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Power Lever Angle
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Power Lever Angle/0.04395 Degrees
  -- Bit 29      Sign Bit (2's complement)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_134_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--   for Label_134_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_134_Discrete_Type'Size use 6;
  package Label_134 is new Arinc_429_Bnr
    ( Label              => 8#134#,
      Value_Type         => Float,
      Scale              => 180.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);


  ----------------------------------------------------------------
  -- DC Amps
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi (
  -- Bit 11 - 16 pad
  -- Bit 17 - 28 Dc Amps/0.125
  -- Bit 29      Sign Bit
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_101_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--   for Label_101_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_101_Discrete_Type'Size use 6;
  package Label_101 is new Arinc_429_Bnr
    ( Label              => 8#101#,
      Value_Type         => Float,
      Scale              => 512.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- DC Volts
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi (
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Dc Volts/0.015625  VDC
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_103_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--   for Label_103_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_103_Discrete_Type'Size use 6;
  package Label_103 is new Arinc_429_Bnr
    ( Label              => 8#103#,
      Value_Type         => Float,
      Scale              => 64.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Hydraulic Pressure
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Hydraulic Pressure/1 psi
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_174_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_174_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_174_Discrete_Type'Size use 6;
  package Label_174 is new Arinc_429_Bnr
    ( Label              => 8#174#,
      Value_Type         => Float,
      Scale              => 4096.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Cockpit Altitude
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 12 Pad
  -- Bit 13 - 28 Cockpit Altitude/2 ft
  -- Bit 29      Sign Bit
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_203_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--  end record;
--
--  for Label_203_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--   end record;
--
--  for Label_203_Discrete_Type'Size use 2;
  package Label_203 is new Arinc_429_Bnr
    ( Label              => 8#203#,
      Value_Type         => Float,
      Scale              => 131072.0,
      Significant_Digits => 16,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Cockpit Differential Pressure
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Cockpit Differential Pressure/0.015625 psid
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_243_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_243_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_243_Discrete_Type'Size use 6;
  package Label_243 is new Arinc_429_Bnr
    ( Label              => 8#243#,
      Value_Type         => Float,
      Scale              => 64.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Fuel Flow
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Fuel Flow/ 0.25 pph
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_244_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_244_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_244_Discrete_Type'Size use 6;
  package Label_244 is new Arinc_429_Bnr
    ( Label              => 8#244#,
      Value_Type         => Float,
      Scale              => 1024.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Left Fuel Quantity
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Left Fuel Quantity/ 0.25 lbs
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_256_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_256_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_256_Discrete_Type'Size use 6;
  package Label_256 is new Arinc_429_Bnr
    ( Label              => 8#256#,
      Value_Type         => Float,
      Scale              => 1024.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Right Fuel Quantity
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Right Fuel Quantity/ 0.25 lbs
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_257_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_257_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--   end record;
--
--  for Label_257_Discrete_Type'Size use 6;
  package Label_257 is new Arinc_429_Bnr
    ( Label              => 8#257#,
      Value_Type         => Float,
      Scale              => 1024.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Engine Data Discretes
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 19 Pad
  -- Bit 20 - 28 Engine Data Discretes
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

  type Label_270_Discrete_Type is record
    Pad_11           : Boolean := False;
    Pad_12           : Boolean := False;
    Pad_13           : Boolean := False;
    Pad_14           : Boolean := False;
    Pad_15           : Boolean := False;
    Pad_16           : Boolean := False;
    Pad_17           : Boolean := False;
    Pad_18           : Boolean := False;
    Pad_19           : Boolean := False;
    Vm_Fail          : Boolean := False;
    Vp_Fail          : Boolean := False;
    Vdd_Fail         : Boolean := False;
    Vin_Fail         : Boolean := False;
    Edm_Channel_Id   : Boolean := False;
    Pad_25           : Boolean := False;
    Pad_26           : Boolean := False;
    Anti_Ice         : Boolean := False;
    Weight_On_Wheels : Boolean := False;
    Sign_Bit         : Boolean := False;
  end record;

  for Label_270_Discrete_Type use record
    Pad_11              at 000 range 0 .. 0;
    Pad_12              at 000 range 1 .. 1;
    Pad_13              at 000 range 2 .. 2;
    Pad_14              at 000 range 3 .. 3;
    Pad_15              at 000 range 4 .. 4;
    Pad_16              at 000 range 5 .. 5;
    Pad_17              at 000 range 6 .. 6;
    Pad_18              at 000 range 7 .. 7;
    Pad_19              at 000 range 8 .. 8;
    Vm_Fail             at 000 range 9 .. 9;
    Vp_Fail             at 000 range 10 .. 10;
    Vdd_Fail            at 000 range 11 .. 11;
    Vin_Fail            at 000 range 12 .. 12;
    Edm_Channel_Id      at 000 range 13 .. 13;
    Pad_25              at 000 range 14 .. 14;
    Pad_26              at 000 range 15 .. 15;
    Anti_Ice            at 000 range 16 .. 16;
    Weight_On_Wheels    at 000 range 17 .. 17;
    Sign_Bit            at 000 range 18 .. 18;
   end record;

  for Label_270_Discrete_Type'Size use 19;
  package Label_270 is new Arinc_429_Discrete
    ( Label              => 8#270#,
      Discretes_Type     => Label_270_Discrete_Type,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      No_Sdi             => False);

  ----------------------------------------------------------------
  -- Raw Interstage Turbine Temperature
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Itt/ 0.5 deg C
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_301_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_301_Discrete_Type use record
--    Pad_11              at 000 range 0 .. 0;
--    Pad_12              at 000 range 1 .. 1;
--    Pad_13              at 000 range 2 .. 2;
--    Pad_14              at 000 range 3 .. 3;
--    Pad_15              at 000 range 4 .. 4;
--    Pad_16              at 000 range 5 .. 5;
--   end record;
--
--  for Label_301_Discrete_Type'Size use 6;
  package Label_301 is new Arinc_429_Bnr
    ( Label              => 8#301#,
      Value_Type         => Float,
      Scale              => 2048.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);
  ----------------------------------------------------------------

  -- Alternate Engine Rpm -- N1
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 15 - 28 Alternate Engine Rpm / 0.015625 % rpm
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_302_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--  end record;
--
--  for Label_302_Discrete_Type use record
--    Pad_11              at 000 range 0 .. 0;
--    Pad_12              at 000 range 1 .. 1;
--    Pad_13              at 000 range 2 .. 2;
--    Pad_14              at 000 range 3 .. 3;
--   end record;
--
--  for Label_302_Discrete_Type'Size use 4;
  package Label_302 is new Arinc_429_Bnr
    ( Label              => 8#302#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 14,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Oil Temperature
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 17 - 28 Oil Temperature / 0.03125 deg C
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_316_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_316_Discrete_Type use record
--    Pad_11              at 000 range 0 .. 0;
--    Pad_12              at 000 range 1 .. 1;
--    Pad_13              at 000 range 2 .. 2;
--    Pad_14              at 000 range 3 .. 3;
--    Pad_15              at 000 range 4 .. 4;
--    Pad_16              at 000 range 5 .. 5;
--   end record;
--
--  for Label_316_Discrete_Type'Size use 6;
  package Label_316 is new Arinc_429_Bnr
    ( Label              => 8#316#,
      Value_Type         => Float,
      Scale              => 128.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Oil Pressure
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 17 - 28 Oil Pressure/ 0.0625 Psi
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_317_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_317_Discrete_Type use record
--    Pad_11              at 000 range 0 .. 0;
--    Pad_12              at 000 range 1 .. 1;
--    Pad_13              at 000 range 2 .. 2;
--    Pad_14              at 000 range 3 .. 3;
--    Pad_15              at 000 range 4 .. 4;
--    Pad_16              at 000 range 5 .. 5;
--   end record;
--
--  for Label_317_Discrete_Type'Size use 6;
  package Label_317 is new Arinc_429_Bnr
    ( Label              => 8#317#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Diagnostics
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 15 - 28 Prop rpm  / 0.015625  % rpm
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

  type Label_350_Discrete_Type is record
    A_Ram_Self_Test_Failure     : Boolean := False; -- Bit 11
    A_Arinc_Self_Test_Failure   : Boolean := False; -- Bit 12
    A_Program_Integrity_Failure : Boolean := False; -- Bit 13
    A_Power_Supply_Failure      : Boolean := False; -- Bit 14
    Left_Ob_Probe_Fail          : Boolean := False; -- Bit 15
    Left_Mid_Probe_Fail         : Boolean := False; -- Bit 16
    Left_Ib_Probe_Fail          : Boolean := False; -- Bit 17
    Right_Ob_Probe_Fail         : Boolean := False; -- Bit 18
    Right_Mid_Probe_Fail        : Boolean := False; -- Bit 19
    Right_Ib_Probe_Fail         : Boolean := False; -- Bit 20
    Collector_Probe_Fail        : Boolean := False; -- Bit 21
    Pad_11                      : Boolean := False; -- Bit 22
    Pad_12                      : Boolean := False; -- Bit 23
    Pad_13                      : Boolean := False; -- Bit 24
    B_Ram_Self_Test_Failure     : Boolean := False; -- Bit 25
    B_Arinc_Self_Test_Failure   : Boolean := False; -- Bit 26
    B_Program_Integrity_Failure : Boolean := False; -- Bit 27
    B_Power_Supply_Failure      : Boolean := False; -- Bit 28
    Sign_Bit                    : Boolean := False; -- Bit 29
  end record;

  for Label_350_Discrete_Type use record
    A_Ram_Self_Test_Failure     at 000 range 0  .. 0 ;
    A_Arinc_Self_Test_Failure   at 000 range 1  .. 1 ;
    A_Program_Integrity_Failure at 000 range 2  .. 2 ;
    A_Power_Supply_Failure      at 000 range 3  .. 3 ;
    Left_Ob_Probe_Fail          at 000 range 4  .. 4 ;
    Left_Mid_Probe_Fail         at 000 range 5  .. 5 ;
    Left_Ib_Probe_Fail          at 000 range 6  .. 6 ;
    Right_Ob_Probe_Fail         at 000 range 7  .. 7 ;
    Right_Mid_Probe_Fail        at 000 range 8  .. 8 ;
    Right_Ib_Probe_Fail         at 000 range 9  .. 9 ;
    Collector_Probe_Fail        at 000 range 10 .. 10;
    Pad_11                      at 000 range 11 .. 11;
    Pad_12                      at 000 range 12 .. 12;
    Pad_13                      at 000 range 13 .. 13;
    B_Ram_Self_Test_Failure     at 000 range 14 .. 14;
    B_Arinc_Self_Test_Failure   at 000 range 15 .. 15;
    B_Program_Integrity_Failure at 000 range 16 .. 16;
    B_Power_Supply_Failure      at 000 range 17 .. 17;
    Sign_Bit                    at 000 range 18 .. 18;
  end record;

  for Label_350_Discrete_Type'Size use 19;
  package Label_350 is new Arinc_429_Discrete
    ( Label              => 8#350#,
      Discretes_Type     => Label_350_Discrete_Type,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      No_Sdi             => False);

end Engine_Data_Manager_Arinc_Labels;







