-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--            Keith H. Rehm
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Temperature_Types;
with Mass_Types;
with Angle_Types;
with Force_Types;
with Length_Types;
with Temperature_Types;
with Electrical_Units_Types;
with Normalized_Types;
with Arinc_429_Types;
with Engine_Data_Manager_Arinc_Labels;
with Jpats_Engine_Data_Manager_Types;
--use type Engine_Data_Manager_Arinc_Labels.Edm_Bnr_Sdi_Type;
use type Jpats_Engine_Data_Manager_Types.Edm_Bnr_Sdi_Type;

package Engine_Data_Manager is

  package A429 renames Engine_Data_Manager_Arinc_Labels;
  package Edm_T renames Jpats_Engine_Data_Manager_Types;

  type Instance is private;

  --| ENGINE DATA MANAGER (EDM)
  --| The engine data manager (EDM) is a
  --| computer unit which --| monitors engine operating parameters and
  --| illuminates the --| appropriate advisory, caution or warning
  --| annunciator as --| necessary. The EDM also drives the primary and
  --| alternate --| engine systems displays, and the engine fluids
  --| display. Non-engine --| related functions performed by the EDM
  --| include fuel --| balancing and fuel quantity
  --| indication. Redundant power for --| the engine data manager is
  --| provided through a circuit --| breaker placarded EDM, located on
  --| the battery bus circuit --| breaker panel in the front cockpit,
  --| and through a circuit --| breaker placarded EDM on the generator
  --| bus circuit breaker --| panel in the front cockpit. In the event
  --| of battery or genera-tor --| malfunction, the EDM continues to
  --| operate with power --| supplied by the remaining system.  --| The
  --| EDM transmits engine data outputs over the data bus, --| using
  --| EDM A and EDM B channels. If an output is bad, or --| if either
  --| data bus channel fails, the affected electronic instru-ment --|
  --| display (EID) will display EDM A or EDM B FAIL in --| amber text,
  --| respectively. If the EDM fails, the affected EIDs --| will
  --| display EDM FAIL in amber text.
  --|
  --|
  --| Ref. AIR FORCE TO
  --| 1T-6A-1 --| NAVY (NAVAIR) A1-T6AAA-NFM-100 --| Page 1-4 - 1-6 CVV
  --| DRAFT DECEMBER 1998
  --| ---------------------------------------------------------------------------
  --| The engine indicating system monitors engine and aircraft
  --| operating systems and conditions necessary To operate the
  --| aircraft. This information is displayed through three electronic
  --| instrumentation displays (EIDS) located on the instrument panels
  --| of each cockpit.
  --| Probes and sensors at different engine and aircraft locations
  --| transmit analog electrical signals through The aircraft wiring
  --| harnesses to the engine data manager (EDM). Refer to Figure 1. The
  --| EDM also Receives engine related signals directly from the power
  --| management unit (PMU) in a digital electronic format (ARINC
  --| 429). As a safety factor, two paths of signal inputs are provided
  --| to the EDM for engine parameters which Are required to set engine
  --| power.
  --| The PMU receives direct sensor inputs for engine torque, engine
  --| RPM (N 1 ), interturbine temperature (ITT), propeller RPM (N p ),
  --| outside air temperature (OAT), and power control lever (PCL)
  --| angle. The PMU Converts these inputs to a digital format and uses
  --| this information to manage engine operation. The PMU also
  --| trans-Mits this information to the EDM for instrument display.
  --| Direct analog input data from the aircraft sensors is
  --| processed into digital format by the EDM. This data and the
  --| digital data received from the PMU are transmitted by the EDM
  --| through redundant ARINC 429 Data buses to the EIDs.
  --| The EDM processes interturbine temperature signals from
  --| data received directly from the T5 Thermocouple network. The EDM
  --| identifies and transmits this data as raw ITT which is displayed
  --| in the cockpit on the alter-Nate engine display EID. The EDM
  --| identifies the digital ITT signal received from the PMU as
  --| primary ITT which is displayed in the cockpit on the primary
  --| engine display EID.
  --| The EDM processes analog engine RPM data received through a
  --| direct electrical path to from the Second coil of the engine
  --| speed sensor. The EDM identifies and transmits this data as
  --| alternate N 1 which is dis-Played in the cockpit on the alternate
  --| engine display EID. The digital N 1 input signal, received
  --| through The PMU path, is identified as primary N 1 which is
  --| displayed on the primary engine display EID.
  --| Ref. Raytheon Aircraft
  --|      Model 3000 Maintenance Manual
  --|      Chapter 77-00-00 page 1
  --|      CVV Draft March 1999
  ----------------------------------------------------------------------------
  -- Access A429_TX_EDM_A_101_Dc_Amps
  function  A429_TX_EDM_A_101_Dc_Amps
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_101_Dc_Amps
    (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_103_Dc_Volts
  function  A429_TX_EDM_A_103_Dc_Volts (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_103_Dc_Volts (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_130_Outside_Air_Temperature
  function  A429_TX_EDM_A_130_Outside_Air_Temperature (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_130_Outside_Air_Temperature (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_174_Hydraulic_Pressure
  function  A429_TX_EDM_A_174_Hydraulic_Pressure (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_174_Hydraulic_Pressure (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_203_Cockpit_Pressure_Altitude
  function  A429_TX_EDM_A_203_Cockpit_Pressure_Altitude (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_203_Cockpit_Pressure_Altitude (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_243_Cockpit_Differential_Pressure
  function  A429_TX_EDM_A_243_Cockpit_Differential_Pressure (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_243_Cockpit_Differential_Pressure (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_244_Fuel_Flow
  function  A429_TX_EDM_A_244_Fuel_Flow (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_244_Fuel_Flow (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_256_Left_Fuel_Quantity
  function  A429_TX_EDM_A_256_Left_Fuel_Quantity (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_256_Left_Fuel_Quantity (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_257_Right_Fuel_Quantity
  function  A429_TX_EDM_A_257_Right_Fuel_Quantity (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_257_Right_Fuel_Quantity (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_270_Engine_Data_Discretes
  function  A429_TX_EDM_A_270_Engine_Data_Discretes (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_270_Engine_Data_Discretes (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_301_ITT
  function  A429_TX_EDM_A_301_ITT (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_301_ITT (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_302_N1
  function  A429_TX_EDM_A_302_N1 (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_302_N1 (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_316_Oil_Temperature
  function  A429_TX_EDM_A_316_Oil_Temperature (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_316_Oil_Temperature (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_317_Oil_Pressure
  function  A429_TX_EDM_A_317_Oil_Pressure (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_317_Oil_Pressure (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_336_Engine_Torque
  function  A429_TX_EDM_A_336_Engine_Torque (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_336_Engine_Torque (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_344_Engine_Rpm
  function  A429_TX_EDM_A_344_Engine_Rpm (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_344_Engine_Rpm (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_345_Engine_ITT
  function  A429_TX_EDM_A_345_Engine_ITT (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_345_Engine_ITT (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_346_Propeller_Rpm
  function  A429_TX_EDM_A_346_Propeller_Rpm (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_346_Propeller_Rpm (An_Instance : in out Instance);

  -- Access A429_TX_EDM_A_350_Discrete_Diagnostics
  function  A429_TX_EDM_A_350_Discrete_Diagnostics (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_A_350_Discrete_Diagnostics (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_101_Dc_Amps
  function  A429_TX_EDM_B_101_Dc_Amps (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_101_Dc_Amps (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_103_Dc_Volts
  function  A429_TX_EDM_B_103_Dc_Volts (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_103_Dc_Volts (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_130_Outside_Air_Temperature
  function  A429_TX_EDM_B_130_Outside_Air_Temperature (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_130_Outside_Air_Temperature (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_174_Hydraulic_Pressure
  function  A429_TX_EDM_B_174_Hydraulic_Pressure (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_174_Hydraulic_Pressure (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_203_Cockpit_Pressure_Altitude
  function  A429_TX_EDM_B_203_Cockpit_Pressure_Altitude (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_203_Cockpit_Pressure_Altitude (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_243_Cockpit_Differential_Pressure
  function  A429_TX_EDM_B_243_Cockpit_Differential_Pressure (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_243_Cockpit_Differential_Pressure (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_244_Fuel_Flow
  function  A429_TX_EDM_B_244_Fuel_Flow (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_244_Fuel_Flow (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_256_Left_Fuel_Quantity
  function  A429_TX_EDM_B_256_Left_Fuel_Quantity (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_256_Left_Fuel_Quantity (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_257_Right_Fuel_Quantity
  function  A429_TX_EDM_B_257_Right_Fuel_Quantity (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_257_Right_Fuel_Quantity (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_270_Engine_Data_Discretes
  function  A429_TX_EDM_B_270_Engine_Data_Discretes (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_270_Engine_Data_Discretes (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_301_ITT
  function  A429_TX_EDM_B_301_ITT (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_301_ITT (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_302_N1
  function  A429_TX_EDM_B_302_N1 (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_302_N1 (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_316_Oil_Temperature
  function  A429_TX_EDM_B_316_Oil_Temperature (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_316_Oil_Temperature (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_317_Oil_Pressure
  function  A429_TX_EDM_B_317_Oil_Pressure (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_317_Oil_Pressure (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_336_Engine_Torque
  function  A429_TX_EDM_B_336_Engine_Torque (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_336_Engine_Torque (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_344_Engine_Rpm
  function  A429_TX_EDM_B_344_Engine_Rpm (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_344_Engine_Rpm (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_345_Engine_ITT
  function  A429_TX_EDM_B_345_Engine_ITT (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_345_Engine_ITT (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_346_Propeller_Rpm
  function  A429_TX_EDM_B_346_Propeller_Rpm (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_346_Propeller_Rpm (An_Instance : in out Instance);

  -- Access A429_TX_EDM_B_350_Discrete_Diagnostics
  function  A429_TX_EDM_B_350_Discrete_Diagnostics (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
  procedure Set_A429_TX_EDM_B_350_Discrete_Diagnostics (An_Instance : in out Instance);

  -- Access Nose Wheel Steering Enable
  function Nws_Enable (An_Instance : Instance) return Boolean;

  -- Access Auto_Balance_Fail_Output
  function  Auto_Balance_Fail_Output
    (An_Instance : in Instance)
    return Boolean;

  -- Access Cockpit_Alt_Hi_Output
  function  Cockpit_Alt_Hi_Output
    (An_Instance : in Instance)
    return Boolean;
  -- Access Cockpit_Press_Hi_Output
  function  Cockpit_Press_Hi_Output
    (An_Instance : in Instance)
    return Boolean;

  -- Access Hyd_Press_Lo_Output
  function  Hyd_Press_Lo_Output
    (An_Instance : in Instance)
    return Boolean;

  -- Access Left_Transfer_Valve_Out
  function  Left_Transfer_Valve_Out
    (An_Instance : in Instance)
    return Boolean;

  -- Access Right_Transfer_Valve_Out
  function  Right_Transfer_Valve_Out
    (An_Instance : in Instance)
    return Boolean;

  -- Access Oil_Press_Lo_Signal
  function  Oil_Press_Lo_Signal
    (An_Instance : in Instance)
    return Boolean;

  -- Access Collector_Fuel_Quantity
  function  Collector_Fuel_Quantity
    (An_Instance : in Instance)
    return Mass_Types.Lbm;

  -- Access Left_Fuel_Quantity
  function  Left_Fuel_Quantity
    (An_Instance : in Instance)
    return Mass_Types.Lbm;

  -- Access Right_Fuel_Quantity
  function  Right_Fuel_Quantity
    (An_Instance : in Instance)
    return Mass_Types.Lbm;

  -- Method Initialize
  procedure Initialize
    (An_Instance : in out Instance);

  -- Method Update
  procedure Update
    (Next_Instance                              : in out Instance;
     This_Instance                              : in out Instance;
     Iconst                                     : in     Float;
     Alternate_Itt_Input_Hi                     : in     Temperature_Types.Celsius;       -- pin   Label 301
     Alternate_N1_Input_Hi                      : in     Normalized_Types.Normalize;      -- pin   Label 302
     Anti_Ice_On                                : in     Boolean;                         -- pin
     Auto_Balance_Selected                      : in     Boolean;                         -- pin
     Bat_Bus_28_VDC                             : in     Boolean;                         -- pin
     Collector_Probe_0_Signal                   : in     Mass_Types.Lbm;                  -- pin
     Collector_Probe_0_Signal_Malfunction       : in     Boolean;
     DC_Amps                                    : in     Electrical_Units_Types.Amps;     -- pin
     Dc_Volts                                   : in     Electrical_Units_Types.Volts_DC; -- pin
     Fuel_Balance_28_VDC                        : in     Boolean;                         -- pin
     Fuel_Flow_Input_Hi                         : in     Mass_Types.Pph;                  -- pin
     Gen_Bus_28_Vdc                             : in     Boolean;                         -- pin
     Hyd_Press_Input_Hi                         : in     Force_Types.Psi;                 -- pin
     L_Fuel_Probe_1_Signal                      : in     Mass_Types.Lbm;                  -- pin
     L_Fuel_Probe_3_Signal                      : in     Mass_Types.Lbm;                  -- pin
     L_Fuel_Probe_5_Signal                      : in     Mass_Types.Lbm;                  -- pin
     L_Fuel_Probe_1_Signal_Malfunction          : in     Boolean;
     L_Fuel_Probe_3_Signal_Malfunction          : in     Boolean;
     L_Fuel_Probe_5_Signal_Malfunction          : in     Boolean;
     L_Wheel_Spd_Sig_Hi                         : in     Float;                           -- pin
     Oil_Press_Input_Hi                         : in     Force_Types.Psi;                 -- pin
     Oil_Temp_Signal_Hi                         : in     Temperature_Types.Celsius;       -- pin
     A429_RX_PMU_A_336_Engine_Torque            : in     Arinc_429_Types.Message_Type;    -- Label 336
     A429_RX_PMU_A_344_Engine_Rpm               : in     Arinc_429_Types.Message_Type;    -- Label 344
     A429_RX_PMU_A_345_Engine_ITT               : in     Arinc_429_Types.Message_Type;    -- Label 345
     A429_RX_PMU_A_346_Propeller_Rpm            : in     Arinc_429_Types.Message_Type;    -- Label 346
     A429_RX_PMU_A_130_Outside_Air_Temperature  : in     Arinc_429_Types.Message_Type;    -- Label 130
     A429_RX_PMU_A_134_Power_Lever_Angle        : in     Arinc_429_Types.Message_Type;    -- Label 134
     A429_RX_PMU_B_336_Engine_Torque            : in     Arinc_429_Types.Message_Type;    -- Label 336
     A429_RX_PMU_B_344_Engine_Rpm               : in     Arinc_429_Types.Message_Type;    -- Label 344
     A429_RX_PMU_B_345_Engine_ITT               : in     Arinc_429_Types.Message_Type;    -- Label 345
     A429_RX_PMU_B_346_Propeller_Rpm            : in     Arinc_429_Types.Message_Type;    -- Label 346
     A429_RX_PMU_B_130_Outside_Air_Temperature  : in     Arinc_429_Types.Message_Type;    -- Label 130
     A429_RX_PMU_B_134_Power_Lever_Angle        : in     Arinc_429_Types.Message_Type;    -- Label 134
     R_Fuel_Probe_2_Signal                      : in     Mass_Types.Lbm;                  -- pin
     R_Fuel_Probe_4_Signal                      : in     Mass_Types.Lbm;                  -- pin
     R_Fuel_Probe_6_Signal                      : in     Mass_Types.Lbm;                  -- pin
     R_Fuel_Probe_2_Signal_Malfunction          : in     Boolean;
     R_Fuel_Probe_4_Signal_Malfunction          : in     Boolean;
     R_Fuel_Probe_6_Signal_Malfunction          : in     Boolean;
     R_Wheel_Spd_Sig_Hi                         : in     Float;                           -- pin
     Weight_On_Wheels                           : in     Boolean;                         -- pin
     Cockpit_Pressure_Altitude                  : in     Length_Types.Feet;
     Cockpit_Differential_Pressure              : in     Force_Types.Psi;
     EDM_Test                                   : in     Boolean;
     EDM_Fail                                   : in     Boolean;
     Auto_Balance_Fail_Malfunction              : in     Boolean);

  --   Fuel_Quantity_Calibrate_Dry : in     Boolean;                                 -- pin
  --   Pmu_Input_hi                : in     Integer;                                 -- pin
  --   L_Wheel_Spd_Excitation      : in     Float;                                   -- pin
  --   R_Wheel_Spd_Excitation      : in     Float;                                   -- pin
  --   L_Dc_Ground                 : in     Electrical_Units_Types.Volts_Dc;         -- pin
  --   R_Dc_Ground                 : in     Electrical_Units_Types.Volts_Dc;         -- pin
  --   R_Wheel_Spd_Sig_Lo          : in     Float;                                   -- pin
  --   Chassis_Ground              : in     Boolean;                                 -- pin
  --   A_28_VDC_Power_Return       : in     Boolean;                                 -- pin
  --   Alternate_Itt_Input_Lo      : in     Temperature_Types.Celsius;               -- pin
  --   Alternate_N1_Input_Lo       : in     Angle_Types.Rpm;                         -- pin
  --   Ann_Discrete_Output_Return  : in     Boolean;                                 -- pin
  --   B_28_VDC_Power_Return       : in     Boolean;                                 -- pin
  --   DC_Amps                     : in     Electrical_Units_Types.Amps;             -- pin
  --   Fuel_Flow_Input_Lo          : in     Mass_Types.Pph;                          -- pin
  --   Hyd_Press_Input_Lo          : in     Force_Types.Psi;                         -- pin
  --   L_Wheel_Spd_Sig_Lo          : in     Float;                                   -- pin
  --   Oil_Press_Input_Lo          : in     Force_Types.Psi;                         -- pin
  --   Oil_Temp_Signal_Lo          : in     Temperature_Types.Celsius;               -- pin
  --   Pmu_Input_lo                : in     Integer;                                 -- pin
  --   Collector_Probe_0_Drive     : in     Mass_Types.Lbm;                          -- pin
  --   Collector_Probe_0_Return    : in     Mass_Types.Lbm;                          -- pin
  --   Dc_Volts_Low                : in     Electrical_Units_Types.Volts_Dc;         -- pin
  --   Discrete_Growth             : in     Boolean;                                 -- pin
  --   Discrete_Growth             : in     Boolean;                                 -- pin
  --   Discrete_Growth             : in     Boolean;                                 -- pin
  --   Discrete_Growth             : in     Boolean;                                 -- pin
  --   Discrete_Growth             : in     Boolean;                                 -- pin
  --   Factory_A_receive           : in     boolean;                                 -- pin
  --   Factory_B_Receive           : in     boolean;                                 -- pin
  --   L_Fuel_Probe_1_Drive        : in     Mass_Types.Lbm;                          -- pin
  --   L_Fuel_Probe_1_Return       : in     Mass_Types.Lbm;                          -- pin
  --   L_Fuel_Probe_3_Drive        : in     Mass_Types.Lbm;                          -- pin
  --   L_Fuel_Probe_3_Return       : in     Mass_Types.Lbm;                          -- pin
  --   L_Fuel_Probe_5_Drive        : in     Mass_Types.Lbm;                          -- pin
  --   L_Fuel_Probe_5_Return       : in     Mass_Types.Lbm;                          -- pin
  --   R_Fuel_Probe_2_Drive        : in     Mass_Types.Lbm;                          -- pin
  --   R_Fuel_Probe_2_Return       : in     Mass_Types.Lbm;                          -- pin
  --   R_Fuel_Probe_4_Drive        : in     Mass_Types.Lbm;                          -- pin
  --   R_Fuel_Probe_4_Return       : in     Mass_Types.Lbm;                          -- pin
  --   R_Fuel_Probe_6_Drive        : in     Mass_Types.Lbm;                          -- pin
  --   R_Fuel_Probe_6_Return       : in     Mass_Types.Lbm;                          -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean;                                 -- pin
  --   Spare                       : in     Boolean);                                -- pin

  private

--  type Arinc_Array_Type is array (A429.Edm_Bnr_Sdi_Type range A429.Channel_A .. A429.Channel_B) of Arinc_429_Types.Message_Type;
    type Arinc_Array_Type is array (Edm_T.Edm_Bnr_Sdi_Type range Edm_T.Channel_A .. Edm_T.Channel_B) of Arinc_429_Types.Message_Type;

    type Instance is record

      Auto_Balance_Fail_Output                      : Boolean;        -- pin 93
      Cockpit_Alt_Hi_Output                         : Boolean;        -- pin 42   *
      Cockpit_Press_Hi_Output                       : Boolean;        -- pin 43   *
      Hyd_Press_Lo_Output                           : Boolean;        -- pin 41   *
      Left_Transfer_Valve_Out                       : Boolean;        -- pin 91
      Right_Transfer_Valve_Out                      : Boolean;        -- pin 92
      Oil_Press_Lo_Signal                           : Boolean;        -- pin 40   *
      NWS_Enable                                    : Boolean;        -- pin      *
      A429_TX_EDM_101_Dc_Amps                       : Arinc_Array_Type; -- Electrical_Units_Types.Amps; -- Label 101;     *
      A429_TX_EDM_103_Dc_Volts                      : Arinc_Array_Type; -- Electrical_Units_Types.Volts_DC; -- Label 103  *
      A429_TX_EDM_130_Outside_Air_Temperature       : Arinc_Array_Type; -- Label 130     *
      A429_TX_EDM_174_Hydraulic_Pressure            : Arinc_Array_Type; -- Label 174;                         *
      A429_TX_EDM_203_Cockpit_Pressure_Altitude     : Arinc_Array_Type; -- Length_Types.Feet; --Label 203  *
      A429_TX_EDM_243_Cockpit_Differential_Pressure : Arinc_Array_Type; -- Force_Types.Psi; --Label 243    *
      A429_TX_EDM_244_Fuel_Flow                     : Arinc_Array_Type; -- Mass_Types.pph; -- Label 244;   *
      A429_TX_EDM_256_Left_Fuel_Quantity            : Arinc_Array_Type; -- Mass_Types.Lbm; -- Label 256
      A429_TX_EDM_257_Right_Fuel_Quantity           : Arinc_Array_Type; -- Mass_Types.Lbm; -- Label 257
      A429_TX_EDM_270_Engine_Data_Discretes         : Arinc_Array_Type; -- Boolean; -- Label 270;
      A429_TX_EDM_301_ITT                           : Arinc_Array_Type; -- Label 301     *
      A429_TX_EDM_302_N1                            : Arinc_Array_Type; -- Label 302     *
      A429_TX_EDM_316_Oil_Temperature               : Arinc_Array_Type; -- Label 316     *
      A429_TX_EDM_317_Oil_Pressure                  : Arinc_Array_Type; -- Label 317     *
      A429_TX_EDM_336_Engine_Torque                 : Arinc_Array_Type; -- Label 336     *
      A429_TX_EDM_344_Engine_Rpm                    : Arinc_Array_Type; -- Label 344     *
      A429_TX_EDM_345_Engine_ITT                    : Arinc_Array_Type; -- Label 345     *
      A429_TX_EDM_346_Propeller_Rpm                 : Arinc_Array_Type; -- Label 346     *
      A429_TX_EDM_350_Discrete_Diagnostics          : Arinc_Array_Type; -- Boolean; -- Label 350
      Collector_Fuel_Quantity                       : Mass_Types.Lbm;
      Left_Fuel_Quantity                            : Mass_Types.Lbm;
      Right_Fuel_Quantity                           : Mass_Types.Lbm;
      --  Factory_A_Xmit                            : boolean;        -- pin 62
      --  Factory_B_Xmit                            : boolean;        -- pin 64
      --  Factory_Calibration                       : boolean;        -- pin 61
      --  Factory_Program                           : boolean;        -- pin 60
      --  Fuel_Quantity_Calibrate_Complete          : Boolean;        -- pin 81
      Power_Out_Time                                : Float;
      Data_Available_Timer                          : Float;
      Data_Available                                : Boolean;
      L_Wheel_Speed_30                              : Boolean;
      R_Wheel_Speed_30                              : Boolean;
      Normalized_Capacitance                        : Normalized_Types.Normalize;
      Weight_On_Wheels_Timer                        : Float;
      First_Pass                                    : Boolean;
      Auto_Balance_Mode                             : Boolean;
      Auto_Balance_Mode_Timer_20                    : Float;
      Auto_Balance_Mode_Timer_30                    : Float;
      Auto_Balance_Selected                         : Boolean;
      L_Xfr_Vlv_Close_Init                          : Boolean;
      R_Xfr_Vlv_Close_Init                          : Boolean;
    end record;


end Engine_Data_Manager;

