-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Voltmeter_G is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Displayed_Voltage := 0.0;
      An_Instance.Displayed_Load    := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


   procedure Update
     (An_Instance : in out Instance;
      Volts       : in     Voltage_Type;
      Load        : in     Ampere_Type)
   is
   begin
      An_Instance.Displayed_Voltage := Volts;
      An_Instance.Displayed_Load    := Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;



   function Displayed_Voltage
     (An_Instance : in Instance)
     return Voltage_Type
   is
   begin
      return An_Instance.Displayed_Voltage;
   exception
      when others =>
         Log.Report(Package_Name & ".Displayed_Voltage()");
         raise;
   end Displayed_Voltage;

   function Displayed_Load
     (An_Instance : in Instance)
     return Ampere_Type
   is
   begin
      return An_Instance.Displayed_Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Displayed_Load()");
         raise;
   end Displayed_Load;

end Voltmeter_G;
