-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Electrical_Units_Types;
with Angle_Types;
with Torque_Types;

package Power_Supply.Generator is

   type Instance is new Power_Supply.Instance with private;

   procedure Update
     (An_Instance      : in out Instance;
      Starter_Engaged  : in     Boolean;
      Voltage_In       : in     Electrical_Units_Types.Volts_Dc;
      Gen_Shaft_Rpm    : in     Angle_Types.Rpm);


   procedure Initialize
     (An_Instance : in out Instance);

   function Starter_Load
     (An_Instance : in Instance)
      return Electrical_Units_Types.Amps;

   function Torque
     (An_Instance : in Instance)
     return Torque_Types.Ft_Lbf;

   procedure Read_Tables;

private

   type Instance is new Power_Supply.Instance with
      record
         Rpm          : Angle_Types.Rpm;
         Starter_Load : Electrical_Units_Types.Amps;
         Torque       : Torque_Types.Ft_Lbf;
      end record;

end Power_Supply.Generator;
