-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Power_Supply.External_Power is

   procedure Update
     (An_Instance : in out Instance;
      Iconst      : in     Float;
      Power_On    : in     Boolean)
   is

      package Ele_U renames Electrical_Units_Types;

      Voltage         : Ele_U.Volts_Dc renames An_Instance.Voltage;
      Power_Available : Boolean        renames An_Instance.Power_Available;

   begin

      if Power_On then
         Voltage := 28.5;
      else
         Voltage := 0.0;
      end if;

      Power_Available := Voltage > 5.0;

   exception
      when others =>
         Log.Report("Power_Supply.External_Power.Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Voltage := 0.0;
      An_Instance.Load    := 0.0;
      An_Instance.Power_Available := False;
   exception
      when others =>
         Log.Report("Power_Supply.External_Power.Initialize()");
         raise;
   end Initialize;



end Power_Supply.External_Power;
