-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Electrical_Units_Types;
with Temperature_Types;


package Power_Supply.Battery is

   type Instance is new Power_Supply.Instance with private;

   procedure Update
     (An_Instance             : in out Instance;
      Iconst                  : in     Float;
      Outside_Air_Temperature : in     Temperature_Types.Rankine;
      Positive_Post_Voltage   : in     Electrical_Units_Types.Volts_Dc;
      Batt_Bus_Light_Start    : in     Boolean); -- Batt Bus Light during Battery Start EP

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Set_Capacity
     (An_Instance : in out Instance;
      C           : in     Float);

   function Is_Charging
     (An_Instance : in Instance)
      return Boolean;

   function Charge_Current
     (An_Instance : in Instance)
     return Electrical_Units_Types.Amps;

   procedure Read_Tables;

private

   type Instance is new Power_Supply.Instance with
      record
         Is_Charging    : Boolean;
         Capacity       : Float;
         Charge_Current : Electrical_Units_Types.Amps;
         Temperature    : Temperature_Types.Fahrenheit;
      end record;

end Power_Supply.Battery;
