-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Path_G is

   procedure Complete
     (An_Instance  : in out Instance;
      Path_Voltage : in     Voltage_type)
   is
   begin
      An_Instance.Is_Complete := True;
      An_Instance.Voltage     := Path_Voltage;
   exception
      when others =>
         Log.Report(Package_Name & ".Complete()");
         raise;
   end Complete;

   procedure Incomplete
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Complete := False;
      An_Instance.Voltage     := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Incomplete()");
         raise;
   end Incomplete;

   function Is_Complete
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Complete;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Complete()");
         raise;
   end Is_Complete;

   function Voltage
     (An_Instance : in Instance)
     return Voltage_Type
   is
   begin
      return An_Instance.Voltage;
   exception
      when others =>
         Log.Report(Package_Name & ".Voltage()");
         raise;
   end Voltage;

   procedure Update
     (An_Instance : in out Instance;
      Completed   : in     Boolean;
      Voltage     : in     Voltage_Type)
   is
   begin
      if Completed then
         Complete (An_Instance,Voltage);
      elsif not Completed then
         Incomplete (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      Incomplete (An_Instance);
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

end Path_G;


