-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic

   type Voltage_Type is digits <>;
   type Power_Source_Name_Type is (<>);
   type Bus_Name_Type is (<>);
   type Path_Type is private;
   type Array_Of_Path_Type is array (Power_Source_Name_Type, Bus_Name_Type) of Path_Type;
   type Array_Of_Boolean_Type is array (Power_Source_Name_Type, Bus_Name_Type) of Boolean;
   type Array_Of_Power_Source_Voltage_Type is array (Power_Source_Name_Type) of Voltage_Type;
   with procedure Complete_A_Path (A_Path         : in out Path_Type;
                                   A_Path_Voltage : in     Voltage_Type);
   with procedure Incomplete_A_Path (A_Path : in out Path_Type);
   with function Is_A_Path_Complete (A_Path : in Path_Type) return Boolean;
   with function A_Path_Voltage (A_Path : in Path_Type) return Voltage_Type;
   with procedure Update_A_Path (A_Path   : in out Path_Type;
                                 Complete : in     Boolean;
                                 Voltage  : in     Voltage_Type);
   with procedure Initialize_A_Path (A_Path : in out Path_Type);
   Package_Name : in String;

package Path_Collection_G is

   type Instance is private;

   procedure Update
     (An_Instance          : in out Instance;
      Path_Is_Complete     : in     Array_Of_Boolean_Type;
      Power_Source_Voltage : in     Array_Of_Power_Source_Voltage_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Is_Complete
     (An_Instance       : in Instance;
      Power_Source_Name : in Power_Source_Name_Type;
      Bus_Name          : in Bus_Name_Type)
      return Boolean;

   function Voltage
     (An_Instance       : in Instance;
      Power_Source_Name : in Power_Source_Name_Type;
      Bus_Name          : in Bus_Name_Type)
      return Voltage_Type;

private

   type Instance is
      record
         The_Paths : Array_Of_Path_Type;
      end record;

end Path_Collection_G;
