-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Path_Collection_G is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Power_Source_Name in Power_Source_Name_Type
      loop
         for Bus_Name in Bus_Name_Type
         loop
            Initialize_A_Path (An_Instance.The_Paths (Power_Source_Name, Bus_Name));
         end loop;
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance          : in out Instance;
      Path_Is_Complete     : in     Array_Of_Boolean_Type;
      Power_Source_Voltage : in     Array_Of_Power_Source_Voltage_Type)
   is
   begin
      for Power_Source_Name in Power_Source_Name_Type
      loop
         for Bus_Name in Bus_Name_Type
         loop
            Update_A_Path
              (An_Instance.The_Paths (Power_Source_Name, Bus_Name),
               Path_Is_Complete (Power_Source_Name, Bus_Name),
               Power_Source_Voltage (Power_Source_Name));
         end loop;
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   function Is_Complete
     (An_Instance       : in Instance;
      Power_Source_Name : in Power_Source_Name_Type;
      Bus_Name          : in Bus_Name_Type)
     return Boolean
   is
   begin
      return Is_A_Path_Complete (An_Instance.The_Paths (Power_Source_Name, Bus_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Complete()");
         raise;
   end Is_Complete;

   function Voltage
     (An_Instance       : in Instance;
      Power_Source_Name : in Power_Source_Name_Type;
      Bus_Name          : in Bus_Name_Type)
     return Voltage_Type
   is
   begin
      return A_Path_Voltage (An_Instance.The_Paths (Power_Source_Name, Bus_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Voltage()");
         raise;
   end Voltage;

end Path_Collection_G;

