-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package Jpats_Electrical_Types is

   type Circuit_Breaker_Name_Type is (Bus_Tie_Control_Cb,
                                      Generator_Sense_Cb,
                                      Ext_Pwr_Cb,
                                      Aux_Batt_Cb,

                      -- Generator bus
                                      Cond_Blower_Cb,
                                      Heat_Exch_Blower_Cb,
                                      Bus_Sense_Cb,

                      -- Hot battery bus
                                      Spare_Cb,
                                      Ram_Air_Valve_Cb,
                                      Battery_Cb,
                                      Emerg_Flaps_Cb,
                                      Clocks_Cb,
                                      Elt_Cb,
                                      Obogs_Cb,
                                      Fdr_Maint_Epa_Fuel_Pump_Cb,

                      -- Forward battery bus
                                      Ail_El_Trim_Cb,
                                      Rud_Trim_Cb,
                                      Ldg_Gr_Cont_Cb,
                                      Flap_Cont_Cb,
                                      Util_Lt_Cb,
                                      Coll_Lts_Cb,
                                      Inst_Lts_Cb,
                                      Ldg_Lts_Cb,
                                      Cws_Cb_Fwd_Batt_Bus,
                                      Fuel_Qty_Lo_Cb,
                                      Pmu_Cb,
                                      Boost_Pump_Cb,
                                      Ign_Cb,
                                      Start_Cb,
                                      Oil_Trx_Cb,
                                      Batt_Sw_Cb,
                                      Avi_Mstr_Cb,
                                      Fld_Lts_Cb,
                                      Alt_Eng_Dis_Cb,
                                      Edm_Cb_Fwd_Batt_Bus,
                                      Prop_Sys_Cb,
                                      Fdr_Cb,
                                      Aoa_Cb,
                                      Inflow_Sys_Cb,
                                      Hyd_Sys_Cb,
                                      Audio_Cb,
                                      Aft_Battery_Cb,
                                      Aux_Battery_Cb,
                                      Fwd_Avi_Cb_Fwd_Batt_Bus,

                      -- Forward avionics battery bus
                                      Eadi_Cb,
                                      Gps_Cb,
                                      Ahrs_Cb,
                                      Aft_Avi_Cb_Fwd_Avi_Batt_Bus,

                      -- Aft avionics bus
                                      Eadi_Cb_Aft_Avi_Batt_Bus,

                      -- Aft battery bus
                                      Alt_Eng_Dis_Cb_Aft_Batt_Bus,
                                      Audio_Cb_Aft_Batt_Bus,
                                      Util_Lt_Cb_Aft_Batt_Bus,
                                      Inst_Lts_Cb_Aft_Batt_Bus,
                                      Fld_Lts_Cb_Aft_Batt_Bus,

                      -- Aft auxiliary battery bus
                                      Altm_Cb_Aft_Aux_Batt_Bus,
                                      Gyro_Cb_Aft_Aux_Batt_Bus,
                                      Trn_Rt_Cb_Aft_Aux_Batt_Bus,

                      -- Forward auxiliary battery bus
                                      Gyro_Cb,
                                      Altm_Cb_Fwd_Aux_Batt_Bus,
                                      Trn_Rt_Cb,
                                      Uhf_Comm_Cb,
                                      Radio_Rlys_Cb_Fwd_Aux_Batt_Bus,
                                      Fire_Detect_Cb_Fwd_Aux_Batt_Bus,
                                      Stby_Lts_Cb,
                                      Aft_Stby_Cb,

                      -- Forward generator bus
                                      Air_Cond_Cb,
                                      Ckpt_Temp_Cb,
                                      Aural_Warn_Cb,
                                      Evap_Blower_Cb,
                                      Aoa_Ht_Cb,
                                      Pitot_Ht_Cb,
                                      Fuel_Bal_Cb,
                                      Side_Lts_Cb,
                                      Nav_Lts_Cb,
                                      Taxi_Lts_Cb,
                                      Speedbrake_Cb,
                                      Nws_Cb,
                                      Test_Lts_Cb,
                                      Trim_Ind_Cb,
                                      Edm_Cb_Fwd_Gen_Bus,
                                      Gen_Sw_Cb,
                                      Fwd_Avi_Cb_Fwd_Gen_Bus,
                                      Fire_Detect_Cb_Fwd_Gen_Bus,
                                      Eng_Sys_Dis_Cb,
                                      Pri_Eng_Dis_Cb,
                                      Tad_Cb,
                                      Seat_Adj_Cb,
                                      Cws_Cb_Fwd_Gen_Bus,
                                      Aft_Gen_Cb,

                      -- Forward avionics generator bus
                                      Adc_Cb,
                                      Ehsi_Cb,
                                      Xpdr_Cb,
                                      Tas_Cb,
                                      Vhf_Comm_Cb,
                                      Asi_Cb,
                                      Altm_Cb_Fwd_Avi_Gen_Bus,
                                      Vhf_Nav_Cb,
                                      Dme_Cb,
                                      Radio_Rlys_Cb_Fwd_Avi_Gen_Bus,
                                      Vvi_Cb,
                                      Rmu_Cb,
                                      Aft_Avi_Cb_Fwd_Avi_Gen_Bus,

                      -- Aft generator bus
                                      Evap_Blower_Cb_Aft_Gen_Bus,
                                      Seat_Adj_Cb_Aft_Gen_Bus,
                                      Side_Lts_Cb_Aft_Gen_Bus,
                                      Eng_Sys_Dis_Cb_Aft_Gen_Bus,
                                      Pri_Eng_Dis_Cb_Aft_Gen_Bus,
                                      Trim_Ind_Cb_Aft_Gen_Bus,

                      -- Aft avionics generator bus
                                      Ehsi_Cb_Aft_Avi_Gen_Bus,
                                      Rmu_Cb_Aft_Avi_Gen_Bus,
                                      Gps_Cb_Aft_Avi_Gen_Bus,
                                      Altm_Cb_Aft_Avi_Gen_Bus,
                                      Asi_Cb_Aft_Avi_Gen_Bus,
                                      Vvi_Cb_Aft_Avi_Gen_Bus);


   type Relay_Name_Type is (Battery_Relay,
                            Generator_Relay,
                            Generator_On_Relay,
                            Bus_Tie_Relay,
                            Avionics_Master_Battery_Relay,
                            Avionics_Master_Generator_Relay,
                            Starter_On_Relay,
                            External_Power_Relay,
                            Auxiliary_Battery_Relay,
                            External_Power_Voltage_Sense_Relay);

   type Bus_Name_Type is (Forward_Battery_Bus,
                          Forward_Generator_Bus,
                          Forward_Avionics_Battery_Bus,
                          Forward_Avionics_Generator_Bus,
                          Hot_Battery_Bus,
                          Generator_Bus,
                          Aft_Battery_Bus,
                          Aft_Generator_Bus,
                          Aft_Auxiliary_Battery_Bus,
                          Forward_Auxiliary_Battery_Bus,
                          Aft_Avionics_Generator_Bus,
                          Aft_Avionics_Battery_Bus,
                          Starter_Distribution_Bus);



end Jpats_Electrical_Types;
