-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Electrical_Types;
with Electrical_Units_Types;

package Jpats_Electrical is

   function Batt_Bus_Light_Start return Boolean;

   -- cbs
   function Is_Powered
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
      return Boolean;
   procedure Trip
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type);
   procedure Clear_Trip
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type);
   procedure Clear_All_Trip;

   -- relays
   function Is_Closed
     (Name : in Jpats_Electrical_Types.Relay_Name_Type)
     return Boolean;

   -- buses
   function Is_Powered
     (Name : in Jpats_Electrical_Types.Bus_Name_Type)
     return Boolean;

   function Voltage
     (Name : in Jpats_Electrical_Types.Bus_Name_Type)
     return Electrical_Units_Types.Volts_Dc;

   -- master caution panel light requests
   function Bat_Bus_Annunciator_Request return Boolean;
   function Gen_Bus_Annunciator_Request return Boolean;
   function Gen_Annunciator_Request return Boolean;
   function Bus_Tie_Annunciator_Request return Boolean;

   -- starter torque
   function Starter_Torque return Float;

   -- emergency lights
   function Emergency_Lights return Boolean;
   function Aux_Batt_Mnt_Is_Powered return Boolean;


   -- electrical system output (for edm)
   function Display_Voltage return Electrical_Units_Types.Volts_Dc;
   function Display_Load    return Electrical_Units_Types.Amps;

   function Battery_Voltage return Electrical_Units_Types.Volts_Dc;

   function External_Power_On return Boolean;

   procedure Reset_Battery;

end Jpats_electrical;



