-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Electrical.Container;
with Power_Supply.External_Power;
with Jpats_Powerplant;
with Electrical_Units_Types;
with Jpats_Auto_Test;
with Log;

package body Jpats_Electrical.Relay_Controller is

   procedure Initialize
   is
   begin
      Container.Coil_Relay_Collection.Initialize
        (Container.This_Subsystem.The_Relays);
      Container.Current_Limiter_Collection.Initialize
        (Container.This_Subsystem.The_Current_Limiters);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Relay_Controller.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (Iconst : in Float)
   is

      package Ele    renames Jpats_Electrical_Types;
      package Ctnr   renames Container;
      package Cbs    renames Ctnr.Circuit_Breaker_Collection;
      package Relays renames Ctnr.Coil_Relay_Collection;

      Io : Ctnr.Io_Interface_Instance renames
        Ctnr.This_Io_Interface;

      Ios : Ctnr.Ios_Interface_Instance renames
        Ctnr.This_Ios_Interface;

      The_Cbs : Cbs.Instance renames
        Ctnr.This_Subsystem.The_Circuit_Breakers;

      The_Current_Limiters : Ctnr.Current_Limiter_Collection.Instance renames
        Ctnr.This_Subsystem.The_Current_Limiters;

      The_Ext_Pwr : Power_Supply.External_Power.Instance renames
        Ctnr.This_Subsystem.The_External_Power;

      The_Gcu : Ctnr.Generator_Control_Unit.Instance renames
        Ctnr.This_Subsystem.The_Generator_Control_Unit;

      The_Relays : Relays.Instance renames
        Ctnr.This_Subsystem.The_Relays;

      Pwr_And_Grnd : Ctnr.Relay_Array_Of_Boolean;

      Aux_Batt_Mnt_Vdc : constant Electrical_Units_Types.Volts_Dc :=
        Ctnr.Auxiliary_Battery_Mount.Voltage_Out
        (An_Instance => Ctnr.This_Subsystem.The_Auxiliary_Battery_Mount);

      Current_Limiter_Open : Ctnr.Current_Limiter_Boolean_Array;

      Auto_Test_On : constant Boolean := Jpats_Auto_Test.On;

   begin

      -----------------------------------
      -- Get power_and_ground for relays
      -----------------------------------

      -- Battery_Relay

      Pwr_And_Grnd (Ele.Battery_Relay) :=
        (Io.Master_Bat_On_Sw or Auto_Test_On) and then
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Battery_Cb);

      -- Generator_Relay

      Pwr_And_Grnd (Ele.Generator_Relay) :=
        Ctnr.Generator_Control_Unit.Line_Control
        (The_Gcu);

      -- Generator_On_Relay

      Pwr_And_Grnd (Ele.Generator_On_Relay) :=
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Generator_Sense_Cb) and then
        Relays.Is_Closed
        (An_Instance => The_Relays,
         Relay_Name  => Ele.Generator_Relay);

      -- Bus_Tie_Relay

      Pwr_And_Grnd (Ele.Bus_Tie_Relay) :=
        (Cbs.Is_Powered
         (An_Instance => The_Cbs,
          Name        => Ele.Bus_Tie_Control_Cb) and then
        not Io.Bus_Tie_Open_Sw) and not Ios.Open_Bus_Tie_Relay;

      -- Avionics_Master_Battery_Relay

      Pwr_And_Grnd (Ele.Avionics_Master_Battery_Relay) :=
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Avi_Mstr_Cb) and then
        not Io.Avionics_Master_On_Sw;

      -- Avionics_Master_Generator_Relay

      Pwr_And_Grnd (Ele.Avionics_Master_Generator_Relay) :=
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Avi_Mstr_Cb) and then
        not Io.Avionics_Master_On_Sw;

      -- Starter_On_Relay

      Pwr_And_Grnd (Ele.Starter_On_Relay) := Jpats_Powerplant.Start_Relay;

      -- External_Power_Relay

      Pwr_And_Grnd (Ele.External_Power_Relay) :=
        (Io.Master_Bat_On_Sw or Auto_Test_On) and then
        Relays.Is_Closed
        (An_Instance => The_Relays,
         Relay_Name  => Ele.External_Power_Voltage_Sense_Relay) and then
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Ext_Pwr_Cb) and then
        Power_Supply.Power_Available (The_Ext_Pwr);

      -- Auxiliary_Battery_Relay

      Pwr_And_Grnd (Ele.Auxiliary_Battery_Relay) :=
        Io.Aux_Bat_On_Sw and then
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Aux_Batt_Cb);

      -- External_Power_Voltage_Sense_Relay

      Pwr_And_Grnd (Ele.External_Power_Voltage_Sense_Relay) :=
        Cbs.Is_Powered
        (An_Instance => The_Cbs,
         Name        => Ele.Ext_Pwr_Cb) and then
        Power_Supply.Voltage (The_Ext_Pwr) < 32.0;

      -----------------
      -- update relays
      -----------------

      Relays.Update
        (An_Instance      => The_Relays,
         Power_And_Ground => Pwr_And_Grnd);



      ----------------------------
      -- update current limiters
      ----------------------------

      Current_Limiter_Open (Ctnr.Battery_Bus_Current_Limiter) := Ios.Open_Batt_Bus_Current_Limiter;

      Current_Limiter_Open (Ctnr.Generator_Bus_Current_Limiter) := Ios.Open_Gen_Bus_Current_Limiter;

      Ctnr.Current_Limiter_Collection.Update (The_Current_Limiters, Current_Limiter_Open);



   exception
      when others =>
         Log.Report("Jpats_Electrical.Relay_Controller.Update()");
         raise;
   end Update;

end Jpats_Electrical.Relay_Controller;

