-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--   GENERATOR
--   The generator provides 28 Vdc power, which is sufficient to operate
--   all the equipment On the generator bus, and power the battery Bus
--   equipment As well. There is also sufficient excess power to Charge
--   the battery. Application of power from the generator is controlled
--   by a generator control switch, placarded GEN (Figure 1-10),
--   located on the engine/electrical switch panel in each cockpit.
--   The generator control switches are magnetically held
--   and electrically interlocked, which allows the generator to
--   be controlled from either cockpit.
--   If the generator control switch has been set in either cockpit,
--   the occupant of the other cockpit may move the respective
--   generator switch to ON, which trips the switch in the other
--   cockpit to OFF. Once control has been transferred in this
--   manner, generator function is controlled by the switch
--   which is set to ON. While control of the switches is being
--   transferred, generator function remains uninterrupted.
--   If the generator malfunctions in flight, the generator may be
--   reset with the generator reset switch, located on the electrical
--   switch panel on the right console in each cockpit. If
--   there is a malfunction of the starter/generator, a red GEN
--   annunciator on the annunciator panel in each cockpit is illuminated.
--   Power for the generator control switches is provided
--   through a circuit breaker placarded GEN SW, located
--   on the generator bus circuit breaker panel in the front cockpit.

--   BATTERY
--   Secondary aircraft power is provided by an aerobatic, 24
--   VDC, lead acid, 40 ampere-hour battery. The battery provides
--   power for engine starts and powers select aircraft systems
--   if the generator is off line. Application of Battery
--   power is controlled by a master battery switch, placarded
--   BAT, located on the forward right console switch panel in
--   each cockpit. The battery switches are magnetically held
--   and electrically interlocked, so that battery power may be
--   controlled from either cockpit. Operation of the battery
--   switches is identical to that of the generator switches. Power
--   for the battery control switches is provided through a circuit
--   breaker placarded BAT SW, located on the battery bus circuit
--   breaker panel in the front cockpit.

--   AUXILIARY BATTERY
--   Auxiliary power is supplied by a 24 VDC, 5 ampere-hour
--   auxiliary battery in the left avionics compartment. The auxiliary
--   battery is controlled by an auxiliary battery switch,
--   placarded AUX BAT, on the right forward console panel in
--   the front cockpit. Preflight testing of the auxiliary battery
--   power level is accomplished prior to application of battery
--   power, with the auxiliary battery test switch and light, placarded
--   AUX BAT, located on the left console system test
--   panel in the front cockpit. Power for the auxiliary battery
--   control switch is provided through a circuit breaker placarded
--   AUX BAT, located on the battery bus circuit breaker
--   panel in the front cockpit.

--   EXTERNAL POWER
--   An external power receptacle is installed in the left, aft fuselage,
--   below the left avionics bay door. External power is distributed
--   on the battery bus and is controlled by the battery
--   master switches.
--   Data source:  Raytheon Phase X Data Package
--   Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                 Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------


private package Jpats_Electrical.Power_Supply_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Electrical.Power_Supply_Controller;
