-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Electrical.Container;
with Jpats_Simulated_Aircraft;
with Length_Types;
with Electrical_Units_Types;
with Jpats_Ios_Interface;
with Log;

package body Jpats_Electrical.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;

   procedure Fire_1_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fire_1_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fire_1_Cb_Trip_Command()");
         raise;
   end Fire_1_Cb_Trip_Command;

   procedure Cws_Batt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Cws_Batt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Cws_Batt_Cb_Trip_Command()");
         raise;
   end Cws_Batt_Cb_Trip_Command;

   procedure Fuel_Qty_Lo_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fuel_Qty_Lo_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fuel_Qty_Lo_Cb_Trip_Command()");
         raise;
   end Fuel_Qty_Lo_Cb_Trip_Command;

   procedure Fldt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fldt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fldt_Cb_Trip_Command()");
         raise;
   end Fldt_Cb_Trip_Command;

   procedure Aux_Bat_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aux_Bat_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aux_Bat_Cb_Trip_Command()");
         raise;
   end Aux_Bat_Cb_Trip_Command;

   procedure Fwd_Avi_Batt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fwd_Avi_Batt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fwd_Avi_Batt_Cb_Trip_Command()");
         raise;
   end Fwd_Avi_Batt_Cb_Trip_Command;

   procedure Aft_Bat_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aft_Bat_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aft_Bat_Cb_Trip_Command()");
         raise;
   end Aft_Bat_Cb_Trip_Command;

   procedure Avi_Mstr_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Avi_Mstr_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Avi_Mstr_Cb_Trip_Command()");
         raise;
   end Avi_Mstr_Cb_Trip_Command;

   procedure Bat_Sw_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Bat_Sw_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Bat_Sw_Cb_Trip_Command()");
         raise;
   end Bat_Sw_Cb_Trip_Command;

   procedure Ldg_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ldg_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ldg_Cb_Trip_Command()");
         raise;
   end Ldg_Cb_Trip_Command;

   procedure Inst_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Inst_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Inst_Cb_Trip_Command()");
         raise;
   end Inst_Cb_Trip_Command;

   procedure Coll_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Coll_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Coll_Cb_Trip_Command()");
         raise;
   end Coll_Cb_Trip_Command;

   procedure Stby_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Stby_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Stby_Cb_Trip_Command()");
         raise;
   end Stby_Cb_Trip_Command;

   procedure Util_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Util_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Util_Cb_Trip_Command()");
         raise;
   end Util_Cb_Trip_Command;

   procedure Ail_El_Trim_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ail_El_Trim_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ail_El_Trim_Cb_Trip_Command()");
         raise;
   end Ail_El_Trim_Cb_Trip_Command;

   procedure Rud_Trim_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Rud_Trim_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Rud_Trim_Cb_Trip_Command()");
         raise;
   end Rud_Trim_Cb_Trip_Command;

   procedure Ldg_Gr_Cont_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ldg_Gr_Cont_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ldg_Gr_Cont_Cb_Trip_Command()");
         raise;
   end Ldg_Gr_Cont_Cb_Trip_Command;

   procedure Flap_Cont_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Flap_Cont_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Flap_Cont_Cb_Trip_Command()");
         raise;
   end Flap_Cont_Cb_Trip_Command;

   procedure Hyd_Sys_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Hyd_Sys_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Hyd_Sys_Cb_Trip_Command()");
         raise;
   end Hyd_Sys_Cb_Trip_Command;

   procedure Inflow_Sys_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Inflow_Sys_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Inflow_Sys_Cb_Trip_Command()");
         raise;
   end Inflow_Sys_Cb_Trip_Command;

   procedure Alt_Eng_Dis_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Alt_Eng_Dis_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Alt_Eng_Dis_Cb_Trip_Command()");
         raise;
   end Alt_Eng_Dis_Cb_Trip_Command;

   procedure Edm_Batt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Edm_Batt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Edm_Batt_Cb_Trip_Command()");
         raise;
   end Edm_Batt_Cb_Trip_Command;

   procedure Oil_Trx_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Oil_Trx_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Oil_Trx_Cb_Trip_Command()");
         raise;
   end Oil_Trx_Cb_Trip_Command;

   procedure Start_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Start_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Start_Cb_Trip_Command()");
         raise;
   end Start_Cb_Trip_Command;

   procedure Ign_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ign_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ign_Cb_Trip_Command()");
         raise;
   end Ign_Cb_Trip_Command;

   procedure Boost_Pump_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Boost_Pump_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Boost_Pump_Cb_Trip_Command()");
         raise;
   end Boost_Pump_Cb_Trip_Command;

   procedure Pmu_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Pmu_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Pmu_Cb_Trip_Command()");
         raise;
   end Pmu_Cb_Trip_Command;

   procedure Radio_Rlys_Batt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Radio_Rlys_Batt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Radio_Rlys_Batt_Cb_Trip_Command()");
         raise;
   end Radio_Rlys_Batt_Cb_Trip_Command;

   procedure Prop_Sys_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Prop_Sys_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Prop_Sys_Cb_Trip_Command()");
         raise;
   end Prop_Sys_Cb_Trip_Command;

   procedure Fdr_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fdr_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fdr_Cb_Trip_Command()");
         raise;
   end Fdr_Cb_Trip_Command;

   procedure Aoa_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aoa_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aoa_Cb_Trip_Command()");
         raise;
   end Aoa_Cb_Trip_Command;

   procedure Turn_Rt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Turn_Rt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Turn_Rt_Cb_Trip_Command()");
         raise;
   end Turn_Rt_Cb_Trip_Command;

   procedure Altm_Batt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Altm_Batt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Altm_Batt_Cb_Trip_Command()");
         raise;
   end Altm_Batt_Cb_Trip_Command;

   procedure Gyro_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gyro_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Gyro_Cb_Trip_Command()");
         raise;
   end Gyro_Cb_Trip_Command;

   procedure Uhf_Comm_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Uhf_Comm_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Uhf_Comm_Cb_Trip_Command()");
         raise;
   end Uhf_Comm_Cb_Trip_Command;

   procedure Aft_Inst_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aft_Inst_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aft_Inst_Cb_Trip_Command()");
         raise;
   end Aft_Inst_Cb_Trip_Command;

   procedure Gps_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gps_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Gps_Cb_Trip_Command()");
         raise;
   end Gps_Cb_Trip_Command;

   procedure Eadi_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Eadi_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Eadi_Cb_Trip_Command()");
         raise;
   end Eadi_Cb_Trip_Command;

   procedure Aft_Avi_Batt_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aft_Avi_Batt_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aft_Avi_Batt_Cb_Trip_Command()");
         raise;
   end Aft_Avi_Batt_Cb_Trip_Command;

   procedure Ahrs_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ahrs_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ahrs_Cb_Trip_Command()");
         raise;
   end Ahrs_Cb_Trip_Command;

   procedure Audio_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Audio_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Audio_Cb_Trip_Command()");
         raise;
   end Audio_Cb_Trip_Command;



   -- generator bus cb panel D/Os
   procedure Fire_2_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fire_2_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fire_2_Cb_Trip_Command()");
         raise;
   end Fire_2_Cb_Trip_Command;

   procedure Cws_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Cws_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Cws_Gen_Cb_Trip_Command()");
         raise;
   end Cws_Gen_Cb_Trip_Command;

   procedure Aural_Warn_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aural_Warn_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aural_Warn_Cb_Trip_Command()");
         raise;
   end Aural_Warn_Cb_Trip_Command;

   procedure Air_Cond_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Air_Cond_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Air_Cond_Cb_Trip_Command()");
         raise;
   end Air_Cond_Cb_Trip_Command;

   procedure Evap_Blower_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Evap_Blower_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Evap_Blower_Cb_Trip_Command()");
         raise;
   end Evap_Blower_Cb_Trip_Command;

   procedure Ckpt_Temp_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ckpt_Temp_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ckpt_Temp_Cb_Trip_Command()");
         raise;
   end Ckpt_Temp_Cb_Trip_Command;

   procedure Aoa_Ht_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aoa_Ht_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aoa_Ht_Cb_Trip_Command()");
         raise;
   end Aoa_Ht_Cb_Trip_Command;

   procedure Pitot_Ht_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Pitot_Ht_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Pitot_Ht_Cb_Trip_Command()");
         raise;
   end Pitot_Ht_Cb_Trip_Command;

   procedure Fwd_Avi_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fwd_Avi_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fwd_Avi_Gen_Cb_Trip_Command()");
         raise;
   end Fwd_Avi_Gen_Cb_Trip_Command;

   procedure Aft_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aft_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aft_Gen_Cb_Trip_Command()");
         raise;
   end Aft_Gen_Cb_Trip_Command;

   procedure Gen_Sw_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gen_Sw_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Gen_Sw_Cb_Trip_Command()");
         raise;
   end Gen_Sw_Cb_Trip_Command;

   procedure Taxi_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Taxi_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Taxi_Cb_Trip_Command()");
         raise;
   end Taxi_Cb_Trip_Command;

   procedure Side_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Side_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Side_Cb_Trip_Command()");
         raise;
   end Side_Cb_Trip_Command;

   procedure Nav_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Nav_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Nav_Cb_Trip_Command()");
         raise;
   end Nav_Cb_Trip_Command;

   procedure Test_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Test_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Test_Cb_Trip_Command()");
         raise;
   end Test_Cb_Trip_Command;

   procedure Speed_Brake_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Speed_Brake_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Speed_Brake_Cb_Trip_Command()");
         raise;
   end Speed_Brake_Cb_Trip_Command;

   procedure Nws_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Nws_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Nws_Cb_Trip_Command()");
         raise;
   end Nws_Cb_Trip_Command;

   procedure Tad_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Tad_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Tad_Cb_Trip_Command()");
         raise;
   end Tad_Cb_Trip_Command;

   procedure Trim_Ind_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Trim_Ind_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Trim_Ind_Cb_Trip_Command()");
         raise;
   end Trim_Ind_Cb_Trip_Command;

   procedure Pri_Eng_Dis_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Pri_Eng_Dis_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Pri_Eng_Dis_Cb_Trip_Command()");
         raise;
   end Pri_Eng_Dis_Cb_Trip_Command;

   procedure Edm_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Edm_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Edm_Gen_Cb_Trip_Command()");
         raise;
   end Edm_Gen_Cb_Trip_Command;

   procedure Eng_Sys_Dis_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Eng_Sys_Dis_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Eng_Sys_Dis_Cb_Trip_Command()");
         raise;
   end Eng_Sys_Dis_Cb_Trip_Command;

   procedure Fuel_Bal_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fuel_Bal_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Fuel_Bal_Cb_Trip_Command()");
         raise;
   end Fuel_Bal_Cb_Trip_Command;

   procedure Seat_Adj_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Seat_Adj_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Seat_Adj_Cb_Trip_Command()");
         raise;
   end Seat_Adj_Cb_Trip_Command;

   procedure Radio_Rlys_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Radio_Rlys_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Radio_Rlys_Cb_Trip_Command()");
         raise;
   end Radio_Rlys_Cb_Trip_Command;

   procedure Ehsi_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ehsi_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Ehsi_Cb_Trip_Command()");
         raise;
   end Ehsi_Cb_Trip_Command;

   procedure Asi_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Asi_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Asi_Cb_Trip_Command()");
         raise;
   end Asi_Cb_Trip_Command;

   procedure Altm_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Altm_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Altm_Gen_Cb_Trip_Command()");
         raise;
   end Altm_Gen_Cb_Trip_Command;

   procedure Vvi_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Vvi_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Vvi_Cb_Trip_Command()");
         raise;
   end Vvi_Cb_Trip_Command;

   procedure Tas_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Tas_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Tas_Cb_Trip_Command()");
         raise;
   end Tas_Cb_Trip_Command;

   procedure Xpdr_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Xpdr_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Xpdr_Cb_Trip_Command()");
         raise;
   end Xpdr_Cb_Trip_Command;

   procedure Vhf_Comm_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Vhf_Comm_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Vhf_Comm_Cb_Trip_Command()");
         raise;
   end Vhf_Comm_Cb_Trip_Command;

   procedure Vhf_Nav_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Vhf_Nav_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Vhf_Nav_Cb_Trip_Command()");
         raise;
   end Vhf_Nav_Cb_Trip_Command;

   procedure Adc_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Adc_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Adc_Cb_Trip_Command()");
         raise;
   end Adc_Cb_Trip_Command;

   procedure Dme_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Dme_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Dme_Cb_Trip_Command()");
         raise;
   end Dme_Cb_Trip_Command;

   procedure Rmu_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Rmu_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Rmu_Gen_Cb_Trip_Command()");
         raise;
   end Rmu_Gen_Cb_Trip_Command;

   procedure Aft_Avi_Gen_Cb_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aft_Avi_Gen_Do := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Aft_Avi_Gen_Cb_Trip_Command()");
         raise;
   end Aft_Avi_Gen_Cb_Trip_Command;

   procedure Kcbhot_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Kcbhot := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Kcbhot_Command()");
         raise;
   end Kcbhot_Command;

   procedure Kcbin_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Kcbin := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Kcbin_Command()");
         raise;
   end Kcbin_Command;

   procedure Clear_All_Trip_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin

      IOS.Clear_All_Trip := JII.Convert_To_Bool(PData);

      Ios.Ail_El_Trim_Do     := False; Ios.Gyro_Do            := False;
      Ios.Rud_Trim_Do        := False; Ios.Altm_Batt_Do       := False;
      Ios.Ldg_Gr_Cont_Do     := False; Ios.Turn_Rt_Do         := False;
      Ios.Flap_Cont_Do       := False; Ios.Uhf_Comm_Do        := False;
      Ios.Util_Do            := False; Ios.Radio_Rlys_Batt_Do := False;
      Ios.Coll_Do            := False; Ios.Fire_1_Do          := False;
      Ios.Inst_Do            := False; Ios.Stby_Do            := False;
      Ios.Ldg_Do             := False; Ios.Aft_Inst_Do        := False;
      Ios.Cws_Batt_Do        := False; Ios.Air_Cond_Do        := False;
      Ios.Fuel_Qty_Lo_Do     := False; Ios.Ckpt_Temp_Do       := False;
      Ios.Pmu_Do             := False; Ios.Aural_Warn_Do      := False;
      Ios.Boost_Pump_Do      := False; Ios.Evap_Blower_Do     := False;
      Ios.Ign_Do             := False; Ios.Aoa_Ht_Do          := False;
      Ios.Start_Do           := False; Ios.Pitot_Ht_Do        := False;
      Ios.Oil_Trx_Do         := False; Ios.Fuel_Bal_Do        := False;
      Ios.Bat_Sw_Do          := False; Ios.Side_Do            := False;
      Ios.Avi_Mstr_Do        := False; Ios.Nav_Do             := False;
      Ios.Fldt_Do            := False; Ios.Taxi_Do            := False;
      Ios.Alt_Eng_Dis_Do     := False; Ios.Speed_Brake_Do     := False;
      Ios.Edm_Batt_Do        := False; Ios.Nws_Do             := False;
      Ios.Prop_Sys_Do        := False; Ios.Test_Do            := False;
      Ios.Fdr_Do             := False; Ios.Trim_Ind_Do        := False;
      Ios.Aoa_Do             := False; Ios.Edm_Gen_Do         := False;
      Ios.Inflow_Sys_Do      := False; Ios.Gen_Sw_Do          := False;
      Ios.Hyd_Sys_Do         := False; Ios.Fwd_Avi_Gen_Do     := False;
      Ios.Audio_Do           := False; Ios.Fire_2_Do          := False;
      Ios.Aft_Bat_Do         := False; Ios.Eng_Sys_Dis_Do     := False;
      Ios.Aux_Bat_Do         := False; Ios.Pri_Eng_Dis_Do     := False;
      Ios.Fwd_Avi_Batt_Do    := False; Ios.Tad_Do             := False;
      Ios.Eadi_Do            := False; Ios.Seat_Adj_Do        := False;
      Ios.Gps_Do             := False; Ios.Cws_Gen_Do         := False;
      Ios.Ahrs_Do            := False; Ios.Aft_Gen_Do         := False;
      Ios.Aft_Avi_Batt_Do    := False; Ios.Adc_Do             := False;
      Ios.Altm_Gen_Do        := False; Ios.Ehsi_Do            := False;
      Ios.Vhf_Nav_Do         := False; Ios.Xpdr_Do            := False;
      Ios.Dme_Do             := False; Ios.Tas_Do             := False;
      Ios.Radio_Rlys_Do      := False; Ios.Vhf_Comm_Do        := False;
      Ios.Vvi_Do             := False; Ios.Asi_Do             := False;
      Ios.Rmu_Gen_Do         := False; Ios.Aft_Avi_Gen_Do     := False;

      IOS.Clear_All_Trip := FALSE;

   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Clear_All_Trip_Command()");
         raise;
   end Clear_All_Trip_Command;

   procedure Gpu_Connector_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
--       package Ctnr     renames Container;
--       package Sim_Acft renames Jpats_Simulated_Aircraft;
--       package Alt      renames Length_Types;
--       package Vel      renames Length_Types;
--       package JII renames Jpats_Ios_Interface;
--       Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
--       Altitude     : constant Alt.Feet         := Sim_Acft.Get_Aircraft_Height_Above_Local_Terrain;
--       Ground_Speed : constant Vel.Feet_per_Sec := Sim_Acft.Get_Ground_Speed;
--       Ground_Service_Available : constant Boolean := Altitude < 10.0 and Ground_Speed < 5.0;
   begin
--       if Ground_Service_Available then
--          Ios.The_Gpu_Connector_In := JII.Convert_To_Bool(PData);
--       else
--          Ios.The_Gpu_Connector_In := False;
--       end if;
      Ios.The_Gpu_Connector_In := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Gpu_Connector_Command()");
         raise;
   end Gpu_Connector_Command;

   procedure Gpu_Power_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.The_Gpu_Power_On := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Gpu_Power_Command()");
         raise;
   end Gpu_Power_Command;

   procedure Battery_Reset_COMMAND
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Battery_Reset :=  JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Battery_Reset_COMMAND()");
         raise;
   end Battery_Reset_COMMAND;

   procedure Gcu_Fail_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gcu_Fail := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Gcu_Fail_Command()");
         raise;
   end Gcu_Fail_Command;

   procedure Open_Batt_Bus_Current_Limiter_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Open_Batt_Bus_Current_Limiter := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Open_Batt_Bus_Current_Limiter_Command()");
         raise;
   end Open_Batt_Bus_Current_Limiter_Command;

   procedure Dead_Aux_Batt_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Dead_Aux_Batt := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Dead_Aux_Batt_Command()");
         raise;
   end Dead_Aux_Batt_Command;

   procedure Open_Bus_Tie_Relay_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Open_Bus_Tie_Relay := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Open_Bus_Tie_Relay_Command()");
         raise;
   end Open_Bus_Tie_Relay_Command;

   procedure Low_Battery_Voltage_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Low_Battery_Voltage := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Low_Battery_Voltage_Command()");
         raise;
   end Low_Battery_Voltage_Command;

   procedure Open_Gen_Bus_Current_Limiter_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Open_Gen_Bus_Current_Limiter := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Open_Gen_Bus_Current_Limiter_Command()");
         raise;
   end Open_Gen_Bus_Current_Limiter_Command;

   procedure Batt_Bus_Light_Start_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Batt_Bus_Light_Start := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Batt_Bus_Light_Start_Command()");
         raise;
   end Batt_Bus_Light_Start_Command;

   procedure Register_Ios_Variables
   is
   begin
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      --   DEBUG   --
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      JPATS_IOS_Interface.Register
        ( "BattLoad",
          Ios.BattLoad'Address
          );

      JPATS_IOS_Interface.Register
        ( "GenLoad",
          Ios.GenLoad'Address
          );

      JPATS_IOS_Interface.Register
        ( "AuxBattLoad",
          Ios.AuxBattLoad'Address
          );

      JPATS_IOS_Interface.Register
        ( "ExtPwrLoad",
          Ios.ExtPwrLoad'Address
          );

      JPATS_IOS_Interface.Register
        ( "BattIsCharging",
          Ios.BattIsCharging'Address
          );

      JPATS_IOS_Interface.Register
        ( "AuxBattIsCharging",
          Ios.AuxBattIsCharging'Address
          );

      JPATS_IOS_Interface.Register
        ( "StarterLoad",
          Ios.StarterLoad'Address
          );
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      -- batt bus light on battery start
      JPATS_IOS_Interface.Register
        ( "Batt_Bus_Light_Start",
          Ios.Batt_Bus_Light_Start'Address,
          Batt_Bus_Light_Start_Command'Access );

      -- low battery voltage
      JPATS_IOS_Interface.Register
        ( "Low_Battery_voltage",
          Ios.Low_Battery_voltage'Address,
          Low_Battery_Voltage_Command'Access );

      -- Gcu_Fail
      JPATS_IOS_Interface.Register
        ( "Gcu_Fail",
          Ios.Gcu_Fail'Address,
          Gcu_Fail_Command'Access );

      -- Open_Batt_Bus_Current_Limiter
      JPATS_IOS_Interface.Register
        ( "Open_Batt_Bus_Current_Limiter",
          Ios.Open_Batt_Bus_Current_Limiter'Address,
          Open_Batt_Bus_Current_Limiter_Command'access );

      -- Dead_Aux_Batt
      JPATS_IOS_Interface.Register
        ( "Dead_Aux_Batt",
          Ios.Dead_Aux_Batt'Address,
          Dead_Aux_Batt_Command'access );

      -- Open_Bus_Tie_Relay
      JPATS_IOS_Interface.Register
        ( "Open_Bus_Tie_Relay",
          Ios.Open_Bus_Tie_Relay'Address,
          Open_Bus_Tie_Relay_Command'access );

      -- Open_Gen_Bus_Current_Limiter
      JPATS_IOS_Interface.Register
        ( "Open_Gen_Bus_Current_Limiter",
          Ios.Open_Gen_Bus_Current_Limiter'Address,
          Open_Gen_Bus_Current_Limiter_Command'access );

      -- Master_Bat_On_Sw
      JPATS_IOS_Interface.Register
        ( "Master_Bat_On_Sw",
          Io.Master_Bat_On_Sw'Address
          );

      -- Master_Gen_On_Sw
      JPATS_IOS_Interface.Register
        ( "Master_Gen_On_Sw",
          Io.Master_Gen_On_Sw'Address
          );

      -- Aux_Bat_On_Sw
      JPATS_IOS_Interface.Register
        ( "Aux_Bat_On_Sw",
          Io.Aux_Bat_On_Sw'Address
          );

      -- Gen_Reset_Sw
      JPATS_IOS_Interface.Register
        ( "Gen_Reset_Sw",
          Io.Gen_Reset_Sw'Address
          );

      -- Aux_Batt_Test_Sw
      JPATS_IOS_Interface.Register
        ( "Aux_Batt_Test_Sw",
          Io.Aux_Batt_Test_Sw'Address
          );

      -- Avionics_Master_On_Sw
      JPATS_IOS_Interface.Register
        ( "Avionics_Master_On_Sw",
          Io.Avionics_Master_On_Sw'Address
          );

      -- Bus_Tie_Open_Sw
      JPATS_IOS_Interface.Register
        ( "Bus_Tie_Open_Sw",
          Io.Bus_Tie_Open_Sw'Address
          );

      -- display VOLTAGE
      JPATS_IOS_Interface.Register
        ( "Display_Voltage",
          Ios.Display_Voltage'Address
          );

      -- display LOAD
      JPATS_IOS_Interface.Register
        ( "Display_Load",
          Ios.Display_Load'Address
          );

      -- GPU CONNECTOR COMMAND
      JPATS_IOS_Interface.Register
        ( "The_Gpu_Connector_In",
          Ios.The_Gpu_Connector_In'Address,
          Gpu_Connector_Command'access );

        -- GPU POWER COMMAND
        JPATS_IOS_Interface.Register
        ( "The_Gpu_Power_On",
          Ios.The_Gpu_Power_On'Address,
          Gpu_Power_Command'access );

        -- BATTERY RESET
        JPATS_IOS_Interface.Register
        ( "Battery_Reset",
          Ios.Battery_Reset'Address,
          BATTERY_RESET_Command'access );

        -- KCBHOT
        JPATS_IOS_Interface.Register
        ( "Kcbhot",
          Ios.Kcbhot'Address,
          Kcbhot_Command'access );

        -- KCBIN
        JPATS_IOS_Interface.Register
        ( "Kcbin",
          Ios.Kcbin'Address,
          Kcbin_Command'access );

        -- CLEAR ALL TRIP COMMAND
        JPATS_IOS_Interface.Register
        ( "Clear_All_Trip",
          Ios.Clear_All_Trip'Address,
          Clear_All_Trip_Command'access );

        -- CIRCUIT BREAKERS

        -- Cws_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fire_1_Di",
          Io.Fire_1_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fire_1_Do",
          Ios.Fire_1_Do'Address,
          Fire_1_Cb_Trip_Command'access );

        -- Cws_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Cws_Batt_Di",
          Io.Cws_Batt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Cws_Batt_Do",
          Ios.Cws_Batt_Do'Address,
          Cws_Batt_Cb_Trip_Command'access );

        -- Fuel_Qty_Lo_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fuel_Qty_Lo_Di",
          Io.Fuel_Qty_Lo_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fuel_Qty_Lo_Do",
          Ios.Fuel_Qty_Lo_Do'Address,
          Fuel_Qty_Lo_Cb_Trip_Command'access );

        -- Fldt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fldt_Di",
          Io.Fldt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fldt_Do",
          Ios.Fldt_Do'Address,
          Fldt_Cb_Trip_Command'access );

        -- Aux_Bat_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aux_Bat_Di",
          Io.Aux_Bat_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aux_Bat_Do",
          Ios.Aux_Bat_Do'Address,
          Aux_Bat_Cb_Trip_Command'access );

        -- Fwd_Avi_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fwd_Avi_Batt_Di",
          Io.Fwd_Avi_Batt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fwd_Avi_Batt_Do",
          Ios.Fwd_Avi_Batt_Do'Address,
          Fwd_Avi_Batt_Cb_Trip_Command'access );

        -- Aft_Bat_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aft_Bat_Di",
          Io.Aft_Bat_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aft_Bat_Do",
          Ios.Aft_Bat_Do'Address,
          Aft_Bat_Cb_Trip_Command'access );

        -- Avi_Mstr_Di/Do
        JPATS_IOS_Interface.Register
        ( "Avi_Mstr_Di",
          Io.Avi_Mstr_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Avi_Mstr_Do",
          Ios.Avi_Mstr_Do'Address,
          Avi_Mstr_Cb_Trip_Command'access );

        -- Bat_Sw_Di/Do
        JPATS_IOS_Interface.Register
        ( "Bat_Sw_Di",
          Io.Bat_Sw_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Bat_Sw_Do",
          Ios.Bat_Sw_Do'Address,
          Bat_Sw_Cb_Trip_Command'access );

        -- Ldg_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ldg_Di",
          Io.Ldg_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ldg_Do",
          Ios.Ldg_Do'Address,
          Ldg_Cb_Trip_Command'access );

        -- Inst_Di/Do
        JPATS_IOS_Interface.Register
        ( "Inst_Di",
          Io.Inst_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Inst_Do",
          Ios.Inst_Do'Address,
          Inst_Cb_Trip_Command'access );

        -- Coll_Di/Do
        JPATS_IOS_Interface.Register
        ( "Coll_Di",
          Io.Coll_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Coll_Do",
          Ios.Coll_Do'Address,
          Coll_Cb_Trip_Command'access );

        -- Stby_Di/Do
        JPATS_IOS_Interface.Register
        ( "Stby_Di",
          Io.Stby_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Stby_Do",
          Ios.Stby_Do'Address,
          Stby_Cb_Trip_Command'access );

        -- Util_Di/Do
        JPATS_IOS_Interface.Register
        ( "Util_Di",
          Io.Util_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Util_Do",
          Ios.Util_Do'Address,
          Util_Cb_Trip_Command'access );

        -- Ail_El_Trim_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ail_El_Trim_Di",
          Io.Ail_El_Trim_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ail_El_Trim_Do",
          Ios.Ail_El_Trim_Do'Address,
          Ail_El_Trim_Cb_Trip_Command'access );

        -- Rud_Trim_Di/Do
        JPATS_IOS_Interface.Register
        ( "Rud_Trim_Di",
          Io.Rud_Trim_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Rud_Trim_Do",
          Ios.Rud_Trim_Do'Address,
          Rud_Trim_Cb_Trip_Command'access );

        -- Ldg_Gr_Cont_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ldg_Gr_Cont_Di",
          Io.Ldg_Gr_Cont_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ldg_Gr_Cont_Do",
          Ios.Ldg_Gr_Cont_Do'Address,
          Ldg_Gr_Cont_Cb_Trip_Command'access );

        -- Flap_Cont_Di/Do
        JPATS_IOS_Interface.Register
        ( "Flap_Cont_Di",
          Io.Flap_Cont_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Flap_Cont_Do",
          Ios.Flap_Cont_Do'Address,
          Flap_Cont_Cb_Trip_Command'access );

        -- Hyd_Sys_Di/Do
        JPATS_IOS_Interface.Register
        ( "Hyd_Sys_Di",
          Io.Hyd_Sys_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Hyd_Sys_Do",
          Ios.Hyd_Sys_Do'Address,
          Hyd_Sys_Cb_Trip_Command'access );

        -- Inflow_Sys_Di/Do
        JPATS_IOS_Interface.Register
        ( "Inflow_Sys_Di",
          Io.Inflow_Sys_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Inflow_Sys_Do",
          Ios.Inflow_Sys_Do'Address,
          Inflow_Sys_Cb_Trip_Command'access );

        -- Alt_Eng_dis_Di/Do
        JPATS_IOS_Interface.Register
        ( "Alt_Eng_Dis_Di",
          Io.Alt_Eng_Dis_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Alt_Eng_Dis_Do",
          Ios.Alt_Eng_Dis_Do'Address,
          Alt_Eng_Dis_Cb_Trip_Command'access );

        -- Edm_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Edm_Batt_Di",
          Io.Edm_Batt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Edm_Batt_Do",
          Ios.Edm_Batt_Do'Address,
          Edm_Batt_Cb_Trip_Command'access );

        -- Oil_Trx_Di/Do
        JPATS_IOS_Interface.Register
        ( "Oil_Trx_Di",
          Io.Oil_Trx_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Oil_Trx_Do",
          Ios.Oil_Trx_Do'Address,
          Oil_Trx_Cb_Trip_Command'access );

        -- Start_Di/Do
        JPATS_IOS_Interface.Register
        ( "Start_Di",
          Io.Start_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Start_Do",
          Ios.Start_Do'Address,
          Start_Cb_Trip_Command'access );

        -- Ign_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ign_Di",
          Io.Ign_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ign_Do",
          Ios.Ign_Do'Address,
          Ign_Cb_Trip_Command'access );

        -- Boost_Pump_Di/Do
        JPATS_IOS_Interface.Register
        ( "Boost_Pump_Di",
          Io.Boost_Pump_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Boost_Pump_Do",
          Ios.Boost_Pump_Do'Address,
          Boost_Pump_Cb_Trip_Command'access );

        -- Pmu_Di/Do
        JPATS_IOS_Interface.Register
        ( "Pmu_Di",
          Io.Pmu_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Pmu_Do",
          Ios.Pmu_Do'Address,
          Pmu_Cb_Trip_Command'access );

        -- Radio_Rlys_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Radio_Rlys_Batt_Di",
          Io.Radio_Rlys_Batt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Radio_Rlys_Batt_Do",
          Ios.Radio_Rlys_Batt_Do'Address,
          Radio_Rlys_Batt_Cb_Trip_Command'access );

        -- Prop_Sys_Di/Do
        JPATS_IOS_Interface.Register
        ( "Prop_Sys_Di",
          Io.Prop_Sys_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Prop_Sys_Do",
          Ios.Prop_Sys_Do'Address,
          Prop_Sys_Cb_Trip_Command'access );

        -- Fdr_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fdr_Di",
          Io.Fdr_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fdr_Do",
          Ios.Fdr_Do'Address,
          Fdr_Cb_Trip_Command'access );

        -- Aoa_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aoa_Di",
          Io.Aoa_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aoa_Do",
          Ios.Aoa_Do'Address,
          Aoa_Cb_Trip_Command'access );

        -- Turn_Rt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Turn_Rt_Di",
          Io.Turn_Rt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Turn_Rt_Do",
          Ios.Turn_Rt_Do'Address,
          Turn_Rt_Cb_Trip_Command'access );

        -- Altm_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Altm_Batt_Di",
          Io.Altm_Batt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Altm_Batt_Do",
          Ios.Altm_Batt_Do'Address,
          Altm_Batt_Cb_Trip_Command'access );

        -- Gyro_Di/Do
        JPATS_IOS_Interface.Register
        ( "Gyro_Di",
          Io.Gyro_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Gyro_Do",
          Ios.Gyro_Do'Address,
          Gyro_Cb_Trip_Command'access );

        -- Uhf_Comm_Di/Do
        JPATS_IOS_Interface.Register
        ( "Uhf_Comm_Di",
          Io.Uhf_Comm_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Uhf_Comm_Do",
          Ios.Uhf_Comm_Do'Address,
          Uhf_Comm_Cb_Trip_Command'access );

        -- Aft_Inst_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aft_Inst_Di",
          Io.Aft_Inst_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aft_Inst_Do",
          Ios.Aft_Inst_Do'Address,
          Aft_Inst_Cb_Trip_Command'access );

        -- Gps_Di/Do
        JPATS_IOS_Interface.Register
        ( "Gps_Di",
          Io.Gps_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Gps_Do",
          Ios.Gps_Do'Address,
          Gps_Cb_Trip_Command'access );

        -- Eadi_Di/Do
        JPATS_IOS_Interface.Register
        ( "Eadi_Di",
          Io.Eadi_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Eadi_Do",
          Ios.Eadi_Do'Address,
          Eadi_Cb_Trip_Command'access );

        -- Aft_Avi_Batt_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aft_Avi_Batt_Di",
          Io.Aft_Avi_Batt_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aft_Avi_Batt_Do",
          Ios.Aft_Avi_Batt_Do'Address,
          Aft_Avi_Batt_Cb_Trip_Command'access );

        -- Ahrs_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ahrs_Di",
          Io.Ahrs_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ahrs_Do",
          Ios.Ahrs_Do'Address,
          Ahrs_Cb_Trip_Command'access );

        -- Audio_Di/Do
        JPATS_IOS_Interface.Register
        ( "Audio_Di",
          Io.Audio_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Audio_Do",
          Ios.Audio_Do'Address,
          Audio_Cb_Trip_Command'access );

        -- generator bus cb panel D/Is

        -- Fire_2_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fire_2_Di",
          Io.Fire_2_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fire_2_Do",
          Ios.Fire_2_Do'Address,
          Fire_2_Cb_Trip_Command'access );

        -- Cws_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Cws_Gen_Di",
          Io.Cws_Gen_Di'Address
          );


      JPATS_IOS_Interface.Register
        ( "Cws_Gen_Do",
          Ios.Cws_Gen_Do'Address,
          Cws_Gen_Cb_Trip_Command'access );

        -- Aural_Warn_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aural_Warn_Di",
          Io.Aural_Warn_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aural_Warn_Do",
          Ios.Aural_Warn_Do'Address,
          Aural_Warn_Cb_Trip_Command'access );

        -- Air_Cond_Di/Do
        JPATS_IOS_Interface.Register
        ( "Air_Cond_Di",
          Io.Air_Cond_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Air_Cond_Do",
          Ios.Air_Cond_Do'Address,
          Air_Cond_Cb_Trip_Command'access );

        -- Evap_Blower_Di/Do
        JPATS_IOS_Interface.Register
        ( "Evap_Blower_Di",
          Io.Evap_Blower_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Evap_Blower_Do",
          Ios.Evap_Blower_Do'Address,
          Evap_Blower_Cb_Trip_Command'access );

        -- Ckpt_Temp_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ckpt_Temp_Di",
          Io.Ckpt_Temp_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ckpt_Temp_Do",
          Ios.Ckpt_Temp_Do'Address,
          Ckpt_Temp_Cb_Trip_Command'access );

        -- Aoa_Ht_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aoa_Ht_Di",
          Io.Aoa_Ht_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aoa_Ht_Do",
          Ios.Aoa_Ht_Do'Address,
          Aoa_Ht_Cb_Trip_Command'access );

        -- Pitot_Ht_Di/Do
        JPATS_IOS_Interface.Register
        ( "Pitot_Ht_Di",
          Io.Pitot_Ht_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Pitot_Ht_Do",
          Ios.Pitot_Ht_Do'Address,
          Pitot_Ht_Cb_Trip_Command'access );

        -- Fwd_Avi_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fwd_Avi_Gen_Di",
          Io.Fwd_Avi_Gen_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fwd_Avi_Gen_Do",
          Ios.Fwd_Avi_Gen_Do'Address,
          Fwd_Avi_Gen_Cb_Trip_Command'access );

        -- Aft_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aft_Gen_Di",
          Io.Aft_Gen_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aft_Gen_Do",
          Ios.Aft_Gen_Do'Address,
          Aft_Gen_Cb_Trip_Command'access );

        -- Gen_Sw_Di/Do
        JPATS_IOS_Interface.Register
        ( "Gen_Sw_Di",
          Io.Gen_Sw_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Gen_Sw_Do",
          Ios.Gen_Sw_Do'Address,
          Gen_Sw_Cb_Trip_Command'access );

        -- Taxi_Di/Do
        JPATS_IOS_Interface.Register
        ( "Taxi_Di",
          Io.Taxi_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Taxi_Do",
          Ios.Taxi_Do'Address,
          Taxi_Cb_Trip_Command'access );

        -- Side_Di/Do
        JPATS_IOS_Interface.Register
        ( "Side_Di",
          Io.Side_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Side_Do",
          Ios.Side_Do'Address,
          Side_Cb_Trip_Command'access );

        -- Nav_Di/Do
        JPATS_IOS_Interface.Register
        ( "Nav_Di",
          Io.Nav_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Nav_Do",
          Ios.Nav_Do'Address,
          Nav_Cb_Trip_Command'access );

        -- Test_Di/Do
        JPATS_IOS_Interface.Register
        ( "Test_Di",
          Io.Test_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Test_Do",
          Ios.Test_Do'Address,
          Test_Cb_Trip_Command'access );

        -- Speed_Brake_Di/Do
        JPATS_IOS_Interface.Register
        ( "Speed_Brake_Di",
          Io.Speed_Brake_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Speed_Brake_Do",
          Ios.Speed_Brake_Do'Address,
          Speed_Brake_Cb_Trip_Command'access );

        -- Nws_Di/Do
        JPATS_IOS_Interface.Register
        ( "Nws_Di",
          Io.Nws_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Nws_Do",
          Ios.Nws_Do'Address,
          Nws_Cb_Trip_Command'access );

        -- Tad_Di/Do
        JPATS_IOS_Interface.Register
        ( "Tad_Di",
          Io.Tad_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Tad_Do",
          Ios.Tad_Do'Address,
          Tad_Cb_Trip_Command'access );

        -- Trim_Ind_Di/Do
        JPATS_IOS_Interface.Register
        ( "Trim_Ind_Di",
          Io.Trim_Ind_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Trim_Ind_Do",
          Ios.Trim_Ind_Do'Address,
          Trim_Ind_Cb_Trip_Command'access );

        -- Pri_Eng_dis_Di/Do
        JPATS_IOS_Interface.Register
        ( "Pri_Eng_Dis_Di",
          Io.Pri_Eng_Dis_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Pri_Eng_Dis_Do",
          Ios.Pri_Eng_Dis_Do'Address,
          Pri_Eng_Dis_Cb_Trip_Command'access );

        -- Edm_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Edm_Gen_Di",
          Io.Edm_Gen_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Edm_Gen_Do",
          Ios.Edm_Gen_Do'Address,
          Edm_Gen_Cb_Trip_Command'access );

        -- Eng_Sys_dis_Di/Do
        JPATS_IOS_Interface.Register
        ( "Eng_Sys_Dis_Di",
          Io.Eng_Sys_Dis_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Eng_Sys_Dis_Do",
          Ios.Eng_Sys_Dis_Do'Address,
          Eng_Sys_Dis_Cb_Trip_Command'access );

        -- Fuel_Bal_Di/Do
        JPATS_IOS_Interface.Register
        ( "Fuel_Bal_Di",
          Io.Fuel_Bal_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Fuel_Bal_Do",
          Ios.Fuel_Bal_Do'Address,
          Fuel_Bal_Cb_Trip_Command'access );

        -- Seat_Adj_Di/Do
        JPATS_IOS_Interface.Register
        ( "Seat_Adj_Di",
          Io.Seat_Adj_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Seat_Adj_Do",
          Ios.Seat_Adj_Do'Address,
          Seat_Adj_Cb_Trip_Command'access );

        -- Radio_Rlys_Di/Do
        JPATS_IOS_Interface.Register
        ( "Radio_Rlys_Di",
          Io.Radio_Rlys_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Radio_Rlys_Do",
          Ios.Radio_Rlys_Do'Address,
          Radio_Rlys_Cb_Trip_Command'access );

        -- Ehsi_Di/Do
        JPATS_IOS_Interface.Register
        ( "Ehsi_Di",
          Io.Ehsi_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Ehsi_Do",
          Ios.Ehsi_Do'Address,
          Ehsi_Cb_Trip_Command'access );

        -- Asi_Di/Do
        JPATS_IOS_Interface.Register
        ( "Asi_Di",
          Io.Asi_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Asi_Do",
          Ios.Asi_Do'Address,
          Asi_Cb_Trip_Command'access );

        -- Altm_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Altm_Gen_Di",
          Io.Altm_Gen_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Altm_Gen_Do",
          Ios.Altm_Gen_Do'Address,
          Altm_Gen_Cb_Trip_Command'access );

        -- Vvi_Di/Do
        JPATS_IOS_Interface.Register
        ( "Vvi_Di",
          Io.Vvi_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Vvi_Do",
          Ios.Vvi_Do'Address,
          Vvi_Cb_Trip_Command'access );

        -- Tas_Di/Do
        JPATS_IOS_Interface.Register
        ( "Tas_Di",
          Io.Tas_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Tas_Do",
          Ios.Tas_Do'Address,
          Tas_Cb_Trip_Command'access );

        -- Xpdr_Di/Do
        JPATS_IOS_Interface.Register
        ( "Xpdr_Di",
          Io.Xpdr_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Xpdr_Do",
          Ios.Xpdr_Do'Address,
          Xpdr_Cb_Trip_Command'access );

        -- Vhf_Comm_Di/Do
        JPATS_IOS_Interface.Register
        ( "Vhf_Comm_Di",
          Io.Vhf_Comm_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Vhf_Comm_Do",
          Ios.Vhf_Comm_Do'Address,
          Vhf_Comm_Cb_Trip_Command'access );

        -- Vhf_Nav_Di/Do
        JPATS_IOS_Interface.Register
        ( "Vhf_Nav_Di",
          Io.Vhf_Nav_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Vhf_Nav_Do",
          Ios.Vhf_Nav_Do'Address,
          Vhf_Nav_Cb_Trip_Command'access );

        -- Adc_Di/Do
        JPATS_IOS_Interface.Register
        ( "Adc_Di",
          Io.Adc_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Adc_Do",
          Ios.Adc_Do'Address,
          Adc_Cb_Trip_Command'access );

        -- Dme_Di/Do
        JPATS_IOS_Interface.Register
        ( "Dme_Di",
          Io.Dme_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Dme_Do",
          Ios.Dme_Do'Address,
          Dme_Cb_Trip_Command'access );

        -- Rmu_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Rmu_Gen_Di",
          Io.Rmu_Gen_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Rmu_Gen_Do",
          Ios.Rmu_Gen_Do'Address,
          Rmu_Gen_Cb_Trip_Command'Access
          );

        -- Aft_Avi_Gen_Di/Do
        JPATS_IOS_Interface.Register
        ( "Aft_Avi_Gen_Di",
          Io.Aft_Avi_Gen_Di'Address
          );

      JPATS_IOS_Interface.Register
        ( "Aft_Avi_Gen_Do",
          Ios.Aft_Avi_Gen_Do'Address,
          Aft_Avi_Gen_Cb_Trip_Command'Access
      );

   exception
      when others =>
         Log.Report("Jpats_Electrical.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Electrical.Ios_Interface;







