-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Electrical.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Electrical.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_BAT_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Master_Bat_On_Sw'Address,
         A_Size          => Io.Master_Bat_On_Sw'Size);
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_GEN_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Master_Gen_On_Sw'Address,
         A_Size          => Io.Master_Gen_On_Sw'Size);
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AUX_BAT_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aux_Bat_On_Sw'Address,
         A_Size          => Io.Aux_Bat_On_Sw'Size);
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "GEN_RESET_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Gen_Reset_Sw'Address,
         A_Size          => Io.Gen_Reset_Sw'Size);
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AUX_BATT_TEST_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aux_Batt_Test_Sw'Address,
         A_Size          => Io.Aux_Batt_Test_Sw'Size);
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AVIONICS_MASTER_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Avionics_Master_On_Sw'Address,
         A_Size          => Io.Avionics_Master_On_Sw'Size);
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "BUS_TIE_OPEN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Bus_Tie_Open_Sw'Address,
         A_Size          => Io.Bus_Tie_Open_Sw'Size);

      -- battery cb panel cb D/Is


      Jpats_Io.Map_To_Icd_Mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_FIRE_1",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fire_1_Di'Address,
         A_Size          => Io.Fire_1_Di'Size);


      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_CWS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Cws_Batt_Di'Address,
         A_Size          => Io.Cws_Batt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_FUEL_QTY_LO",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fuel_Qty_Lo_Di'Address,
         A_Size          => Io.Fuel_Qty_Lo_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_FLDT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fldt_Di'Address,
         A_Size          => Io.Fldt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AUX_BAT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aux_Bat_Di'Address,
         A_Size          => Io.Aux_Bat_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_FWD_AVI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fwd_Avi_Batt_Di'Address,
         A_Size          => Io.Fwd_Avi_Batt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AFT_BAT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aft_Bat_Di'Address,
         A_Size          => Io.Aft_Bat_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AVI_MSTR",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Avi_Mstr_Di'Address,
         A_Size          => Io.Avi_Mstr_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_BAT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Bat_Sw_Di'Address,
         A_Size          => Io.Bat_Sw_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_LDG",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ldg_Di'Address,
         A_Size          => Io.Ldg_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_INST",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Inst_Di'Address,
         A_Size          => Io.Inst_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_COLL",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Coll_Di'Address,
         A_Size          => Io.Coll_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_STBY",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Stby_Di'Address,
         A_Size          => Io.Stby_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_UTIL",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Util_Di'Address,
         A_Size          => Io.Util_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AIL_EL_TRIM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ail_El_Trim_Di'Address,
         A_Size          => Io.Ail_El_Trim_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_RUD_TRIM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Rud_Trim_Di'Address,
         A_Size          => Io.Rud_Trim_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_LDG_GR_CONT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ldg_Gr_Cont_Di'Address,
         A_Size          => Io.Ldg_Gr_Cont_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_FLAP_CONT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Flap_Cont_Di'Address,
         A_Size          => Io.Flap_Cont_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_HYD_SYS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Hyd_Sys_Di'Address,
         A_Size          => Io.Hyd_Sys_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_INFLOW_SYS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Inflow_Sys_Di'Address,
         A_Size          => Io.Inflow_Sys_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_ALT_ENG_DIS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Alt_Eng_Dis_Di'Address,
         A_Size          => Io.Alt_Eng_Dis_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_EDM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Edm_Batt_Di'Address,
         A_Size          => Io.Edm_Batt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_OIL_TRX",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Oil_Trx_Di'Address,
         A_Size          => Io.Oil_Trx_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_START",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Start_Di'Address,
         A_Size          => Io.Start_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_IGN",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ign_Di'Address,
         A_Size          => Io.Ign_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_BOOST_PUMP",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Boost_Pump_Di'Address,
         A_Size          => Io.Boost_Pump_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_PMU",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Pmu_Di'Address,
         A_Size          => Io.Pmu_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_RADIO_RELAYS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Radio_Rlys_Batt_Di'Address,
         A_Size          => Io.Radio_Rlys_Batt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_PROP_SYS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Prop_Sys_Di'Address,
         A_Size          => Io.Prop_Sys_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_FDR",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fdr_Di'Address,
         A_Size          => Io.Fdr_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AOA",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aoa_Di'Address,
         A_Size          => Io.Aoa_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_TURN_RT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Turn_Rt_Di'Address,
         A_Size          => Io.Turn_Rt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_ALTM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Altm_Batt_Di'Address,
         A_Size          => Io.Altm_Batt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_GYRO",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Gyro_Di'Address,
         A_Size          => Io.Gyro_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_UHF_COMM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Uhf_Comm_Di'Address,
         A_Size          => Io.Uhf_Comm_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AFT_INST",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aft_Inst_Di'Address,
         A_Size          => Io.Aft_Inst_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_GPS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Gps_Di'Address,
         A_Size          => Io.Gps_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_EADI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Eadi_Di'Address,
         A_Size          => Io.Eadi_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AFT_AVI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aft_Avi_Batt_Di'Address,
         A_Size          => Io.Aft_Avi_Batt_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AHRS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ahrs_Di'Address,
         A_Size          => Io.Ahrs_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_L_AUDIO",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Audio_Di'Address,
         A_Size          => Io.Audio_Di'Size);



      -- generator bus cb panel D/Is

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_FIRE_2",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fire_2_Di'Address,
         A_Size          => Io.Fire_2_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_CWS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Cws_Gen_Di'Address,
         A_Size          => Io.Cws_Gen_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_AURAL_WARN",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aural_Warn_Di'Address,
         A_Size          => Io.Aural_Warn_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_AIR_COND",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Air_Cond_Di'Address,
         A_Size          => Io.Air_Cond_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_EVAP_BLWR",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Evap_Blower_Di'Address,
         A_Size          => Io.Evap_Blower_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_CKPT_TEMP",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ckpt_Temp_Di'Address,
         A_Size          => Io.Ckpt_Temp_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_AOA_HT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aoa_Ht_Di'Address,
         A_Size          => Io.Aoa_Ht_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_PITOT_HT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Pitot_Ht_Di'Address,
         A_Size          => Io.Pitot_Ht_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_FWD_AVI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fwd_Avi_Gen_Di'Address,
         A_Size          => Io.Fwd_Avi_Gen_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_AFT_GEN",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aft_Gen_Di'Address,
         A_Size          => Io.Aft_Gen_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_GEN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Gen_Sw_Di'Address,
         A_Size          => Io.Gen_Sw_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_TAXI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Taxi_Di'Address,
         A_Size          => Io.Taxi_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_SIDE",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Side_Di'Address,
         A_Size          => Io.Side_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_NAV",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Nav_Di'Address,
         A_Size          => Io.Nav_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_TEST",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Test_Di'Address,
         A_Size          => Io.Test_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_SPEED_BRAKE",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Speed_Brake_Di'Address,
         A_Size          => Io.Speed_Brake_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_NWS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Nws_Di'Address,
         A_Size          => Io.Nws_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_TAD",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Tad_Di'Address,
         A_Size          => Io.Tad_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_TRIM_IND",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Trim_Ind_Di'Address,
         A_Size          => Io.Trim_Ind_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_PRI_ENG_DIS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Pri_Eng_Dis_Di'Address,
         A_Size          => Io.Pri_Eng_Dis_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_EDM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Edm_Gen_Di'Address,
         A_Size          => Io.Edm_Gen_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_ENG_SYS_DIS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Eng_Sys_Dis_Di'Address,
         A_Size          => Io.Eng_Sys_Dis_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_FUEL_BAL",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fuel_Bal_Di'Address,
         A_Size          => Io.Fuel_Bal_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_SEAT_ADJ",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Seat_Adj_Di'Address,
         A_Size          => Io.Seat_Adj_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_RADIO_RLYS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Radio_Rlys_Di'Address,
         A_Size          => Io.Radio_Rlys_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_EHSI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ehsi_Di'Address,
         A_Size          => Io.Ehsi_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_ASI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Asi_Di'Address,
         A_Size          => Io.Asi_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_ALTM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Altm_Gen_Di'Address,
         A_Size          => Io.Altm_Gen_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_VVI",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Vvi_Di'Address,
         A_Size          => Io.Vvi_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_TAS",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Tas_Di'Address,
         A_Size          => Io.Tas_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_XPDR",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Xpdr_Di'Address,
         A_Size          => Io.Xpdr_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_VHF_COMM",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Vhf_Comm_Di'Address,
         A_Size          => Io.Vhf_Comm_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_VHF_NAV",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Vhf_Nav_Di'Address,
         A_Size          => Io.Vhf_Nav_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_ADC",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Adc_Di'Address,
         A_Size          => Io.Adc_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_DME",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Dme_Di'Address,
         A_Size          => Io.Dme_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_RMU",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Rmu_Gen_Di'Address,
         A_Size          => Io.Rmu_Gen_Di'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBI_R_AFT_AVI_GEN",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aft_Avi_Gen_Di'Address,
         A_Size          => Io.Aft_Avi_Gen_Di'Size);




      -- DIGITAL OUTPUT

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AUX_BATT_LAMP",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aux_Batt_Lamp'Address,
         A_Size          => Io.Aux_Batt_Lamp'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_BAT_ON",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Master_Bat_On'Address,
         A_Size          => Io.Master_Bat_On'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_GEN_ON",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Master_Gen_On'Address,
         A_Size          => Io.Master_Gen_On'Size);



      -- battery cb panel cb D/Os

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_FIRE_1",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fire_1_Do'Address,
         A_Size          => Io.Fire_1_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_CWS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Cws_Batt_Do'Address,
         A_Size          => Io.Cws_Batt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_FUEL_QTY_LO",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fuel_Qty_Lo_Do'Address,
         A_Size          => Io.Fuel_Qty_Lo_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_FLDT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fldt_Do'Address,
         A_Size          => Io.Fldt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AUX_BAT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aux_Bat_Do'Address,
         A_Size          => Io.Aux_Bat_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_FWD_AVI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fwd_Avi_Batt_Do'Address,
         A_Size          => Io.Fwd_Avi_Batt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AFT_BAT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aft_Bat_Do'Address,
         A_Size          => Io.Aft_Bat_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AVI_MSTR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Avi_Mstr_Do'Address,
         A_Size          => Io.Avi_Mstr_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_BAT_SW",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Bat_Sw_Do'Address,
         A_Size          => Io.Bat_Sw_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_LDG",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ldg_Do'Address,
         A_Size          => Io.Ldg_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_INST",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Inst_Do'Address,
         A_Size          => Io.Inst_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_COLL",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Coll_Do'Address,
         A_Size          => Io.Coll_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_STBY",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Stby_Do'Address,
         A_Size          => Io.Stby_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_UTIL",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Util_Do'Address,
         A_Size          => Io.Util_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AIL_EL_TRIM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ail_El_Trim_Do'Address,
         A_Size          => Io.Ail_El_Trim_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_RUD_TRIM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Rud_Trim_Do'Address,
         A_Size          => Io.Rud_Trim_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_LDG_GR_CONT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ldg_Gr_Cont_Do'Address,
         A_Size          => Io.Ldg_Gr_Cont_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_FLAP_CONT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Flap_Cont_Do'Address,
         A_Size          => Io.Flap_Cont_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_HYD_SYS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Hyd_Sys_Do'Address,
         A_Size          => Io.Hyd_Sys_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_INFLOW_SYS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Inflow_Sys_Do'Address,
         A_Size          => Io.Inflow_Sys_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_ALT_ENG_DIS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Alt_Eng_Dis_Do'Address,
         A_Size          => Io.Alt_Eng_Dis_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_EDM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Edm_Batt_Do'Address,
         A_Size          => Io.Edm_Batt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_OIL_TRX",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Oil_Trx_Do'Address,
         A_Size          => Io.Oil_Trx_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_START",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Start_Do'Address,
         A_Size          => Io.Start_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_IGN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ign_Do'Address,
         A_Size          => Io.Ign_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_BOOST_PUMP",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Boost_Pump_Do'Address,
         A_Size          => Io.Boost_Pump_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_PMU",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Pmu_Do'Address,
         A_Size          => Io.Pmu_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_RADIO_RELAYS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Radio_Rlys_Batt_Do'Address,
         A_Size          => Io.Radio_Rlys_Batt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_PROP_SYS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Prop_Sys_Do'Address,
         A_Size          => Io.Prop_Sys_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_FDR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fdr_Do'Address,
         A_Size          => Io.Fdr_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AOA",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aoa_Do'Address,
         A_Size          => Io.Aoa_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_TURN_RT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Turn_Rt_Do'Address,
         A_Size          => Io.Turn_Rt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_ALTM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Altm_Batt_Do'Address,
         A_Size          => Io.Altm_Batt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_GYRO",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Gyro_Do'Address,
         A_Size          => Io.Gyro_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_UHF_COMM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Uhf_Comm_Do'Address,
         A_Size          => Io.Uhf_Comm_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AFT_INST",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aft_Inst_Do'Address,
         A_Size          => Io.Aft_Inst_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_GPS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Gps_Do'Address,
         A_Size          => Io.Gps_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_EADI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Eadi_Do'Address,
         A_Size          => Io.Eadi_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AFT_AVI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aft_Avi_Batt_Do'Address,
         A_Size          => Io.Aft_Avi_Batt_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AHRS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ahrs_Do'Address,
         A_Size          => Io.Ahrs_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_L_AUDIO",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Audio_Do'Address,
         A_Size          => Io.Audio_Do'Size);



      -- generator bus cb panel D/Os

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_FIRE_2",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fire_2_Do'Address,
         A_Size          => Io.Fire_2_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_CWS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Cws_Gen_Do'Address,
         A_Size          => Io.Cws_Gen_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_AURAL_WARN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aural_Warn_Do'Address,
         A_Size          => Io.Aural_Warn_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_AIR_COND",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Air_Cond_Do'Address,
         A_Size          => Io.Air_Cond_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_EVAP_BLWR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Evap_Blower_Do'Address,
         A_Size          => Io.Evap_Blower_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_CKPT_TEMP",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ckpt_Temp_Do'Address,
         A_Size          => Io.Ckpt_Temp_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_AOA_HT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aoa_Ht_Do'Address,
         A_Size          => Io.Aoa_Ht_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_PITOT_HT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Pitot_Ht_Do'Address,
         A_Size          => Io.Pitot_Ht_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_FWD_AVI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fwd_Avi_Gen_Do'Address,
         A_Size          => Io.Fwd_Avi_Gen_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_AFT_GEN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aft_Gen_Do'Address,
         A_Size          => Io.Aft_Gen_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_GEN_SW",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Gen_Sw_Do'Address,
         A_Size          => Io.Gen_Sw_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_TAXI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Taxi_Do'Address,
         A_Size          => Io.Taxi_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_SIDE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Side_Do'Address,
         A_Size          => Io.Side_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_NAV",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Nav_Do'Address,
         A_Size          => Io.Nav_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_TEST",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Test_Do'Address,
         A_Size          => Io.Test_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_SPEED_BRAKE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Speed_Brake_Do'Address,
         A_Size          => Io.Speed_Brake_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_NWS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Nws_Do'Address,
         A_Size          => Io.Nws_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_TAD",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Tad_Do'Address,
         A_Size          => Io.Tad_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_TRIM_IND",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Ind_Do'Address,
         A_Size          => Io.Trim_Ind_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_PRI_ENG_DIS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Pri_Eng_Dis_Do'Address,
         A_Size          => Io.Pri_Eng_Dis_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_EDM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Edm_Gen_Do'Address,
         A_Size          => Io.Edm_Gen_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_ENG_SYS_DIS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Eng_Sys_Dis_Do'Address,
         A_Size          => Io.Eng_Sys_Dis_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_FUEL_BAL",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fuel_Bal_Do'Address,
         A_Size          => Io.Fuel_Bal_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_SEAT_ADJ",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Seat_Adj_Do'Address,
         A_Size          => Io.Seat_Adj_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_RADIO_RLYS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Radio_Rlys_Do'Address,
         A_Size          => Io.Radio_Rlys_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_EHSI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ehsi_Do'Address,
         A_Size          => Io.Ehsi_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_ASI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Asi_Do'Address,
         A_Size          => Io.Asi_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_ALTM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Altm_Gen_Do'Address,
         A_Size          => Io.Altm_Gen_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_VVI",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Vvi_Do'Address,
         A_Size          => Io.Vvi_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_TAS",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Tas_Do'Address,
         A_Size          => Io.Tas_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_XPDR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Xpdr_Do'Address,
         A_Size          => Io.Xpdr_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_VHF_COMM",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Vhf_Comm_Do'Address,
         A_Size          => Io.Vhf_Comm_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_VHF_NAV",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Vhf_Nav_Do'Address,
         A_Size          => Io.Vhf_Nav_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_ADC",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Adc_Do'Address,
         A_Size          => Io.Adc_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_DME",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Dme_Do'Address,
         A_Size          => Io.Dme_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_RMU",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Rmu_Gen_Do'Address,
         A_Size          => Io.Rmu_Gen_Do'Size);

      Jpats_Io.Map_To_Icd_Mnemonic
        (An_interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CBO_R_AFT_AVI_GEN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Aft_Avi_Gen_Do'Address,
         A_Size          => Io.Aft_Avi_Gen_Do'Size);


      -- analog input
      -- analog output

   exception
      when others =>
         Log.Report("Jpats_Electrical.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Electrical.Io_Interface;

