-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Circuit_Breaker_G;
with Circuit_Breaker_Collection_G;
with Bus_G;
with Bus_Collection_G;
with Coil_Relay_G;
with Coil_Relay_Collection_G;
with Path_G;
with Path_Collection_G;
with Current_Limiter_G;
with Current_Limiter_Collection_G;
with Generator_Control_Unit_G;
with Auxiliary_Battery_Mount_G;
with Voltmeter_G;

with Electrical_Units_Types;
with Jpats_Electrical_Types;

with Power_Supply.Battery;
with Power_Supply.Auxiliary_Battery;
with Power_Supply.Generator;
with Power_Supply.External_Power;



private package Jpats_Electrical.Container is

-- circuit breakers
   package Circuit_Breaker is new Circuit_Breaker_G
     (Package_Name => "Jpats_Electrical.Container.Circuit_Breaker");
   type Array_Of_Circuit_Breaker_Type is array
     (Jpats_Electrical_Types.Circuit_Breaker_Name_Type) of Circuit_Breaker.Instance;
   type Circuit_Breaker_Array_Of_Boolean is array
     (Jpats_Electrical_Types.Circuit_Breaker_Name_Type) of Boolean;
   package Circuit_Breaker_Collection is new Circuit_Breaker_Collection_G
     (Circuit_Breaker_Name_Type     => Jpats_Electrical_Types.Circuit_Breaker_Name_Type,
      Circuit_Breaker_Type          => Circuit_Breaker.Instance,
      Array_Of_Circuit_Breaker_Type => Array_Of_Circuit_Breaker_Type,
      Array_Of_Boolean_Type         => Circuit_Breaker_Array_Of_Boolean,
      Power_Circuit_Breaker         => Circuit_Breaker.Power,
      Unpower_Circuit_Breaker       => Circuit_Breaker.Unpower,
      Circuit_Breaker_Is_Powered    => Circuit_Breaker.Is_Powered,
      Circuit_Breaker_Is_Unpowered  => Circuit_Breaker.Is_Unpowered,
      Update_Circuit_Breaker        => Circuit_Breaker.Update,
      Initialize_Circuit_Breaker    => Circuit_Breaker.Initialize,
      Package_Name                  => "Jpats_Electrical.Container.Circuit_Breaker_Collection");

-- buses
   package Bus is new Bus_G
     (Voltage_Type              => Electrical_Units_Types.Volts_Dc,
      Ampere_Type               => Electrical_Units_Types.Amps,
      Powered_Voltage_Threshold => 5.0,
      Package_Name              => "Jpats_Electrical.Container.Bus");
   type Array_Of_Bus_Type is array (Jpats_Electrical_Types.Bus_Name_Type) of Bus.Instance;
   type Array_Of_Bus_Voltages is array (Jpats_Electrical_Types.Bus_Name_Type) of Electrical_Units_Types.Volts_Dc;
   type Array_Of_Bus_Loads is array (Jpats_Electrical_Types.Bus_Name_Type) of Electrical_Units_Types.Amps;
   type Bus_Array_Of_Boolean is array (Jpats_Electrical_Types.Bus_Name_Type) of Boolean;
   package Bus_Collection is new Bus_Collection_G
     (Voltage_Type          => Electrical_Units_Types.Volts_Dc,
      Ampere_Type           => Electrical_Units_Types.Amps,
      Bus_Name_Type         => Jpats_Electrical_Types.Bus_Name_Type,
      Bus_Type              => Bus.Instance,
      Array_Of_Bus_Type     => Array_Of_Bus_Type,
      Array_Of_Bus_Voltages => Array_Of_Bus_Voltages,
      Array_Of_Bus_Loads    => Array_Of_Bus_Loads,
      Power_A_Bus           => Bus.Power,
      Unpower_A_Bus         => Bus.Unpower,
      Set_A_Bus_Load        => Bus.Set_Load,
      A_Bus_Voltage         => Bus.Voltage,
      A_Bus_Is_Powered      => Bus.Is_Powered,
      A_Bus_Load            => Bus.Load,
      Update_A_Bus          => Bus.Update,
      Initialize_A_Bus      => Bus.Initialize,
      Package_Name          => "Jpats_Electrical.Container.Bus_Collection");

-- relays
   package Coil_Relay is new Coil_Relay_G
     (Ampere_Type  => Electrical_Units_Types.Amps,
      Closed_Load  => 0.05,
      Package_Name => "Jpats_Electrical.Container.Coil_Relay");
   type Array_Of_Relay_Type is array
     (Jpats_Electrical_Types.Relay_Name_Type) of Coil_Relay.Instance;
   type Relay_Array_Of_Boolean is array
     (Jpats_Electrical_Types.Relay_Name_Type) of Boolean;
   package Coil_Relay_Collection is new Coil_Relay_Collection_G
     (Ampere_Type           => Electrical_Units_Types.Amps,
      Relay_Name_Type       => Jpats_Electrical_Types.Relay_Name_Type,
      Relay_Type            => Coil_Relay.Instance,
      Array_Of_Relay_Type   => Array_Of_Relay_Type,
      Array_Of_Boolean_Type => Relay_Array_Of_Boolean,
      Open_A_Relay          => Coil_Relay.Open,
      Close_A_Relay         => Coil_Relay.Close,
      Initialize_A_Relay    => Coil_Relay.Initialize,
      A_Relay_Load          => Coil_Relay.Load,
      A_Relay_Is_Open       => Coil_Relay.Is_Open,
      A_Relay_Is_Closed     => Coil_Relay.Is_Closed,
      Update_A_Relay        => Coil_Relay.Update,
      Package_Name          => "Jpats_Electrical.Container.Coil_Relay_Collection");

-- paths
   package Path is new Path_G
     (Voltage_Type => Electrical_Units_Types.Volts_Dc,
      Package_Name => "Jpats_Electrical.Container.Path");
   type Power_Source_Name_Type is (Battery,
                                   Generator,
                                   Auxiliary_Battery,
                                   External_Power);
   type Array_Of_Path_Type is array
     (Power_Source_Name_Type, Jpats_Electrical_Types.Bus_Name_Type) of Path.Instance;
   type Path_Array_Of_Boolean_Type is array
     (Power_Source_Name_Type, Jpats_Electrical_Types.Bus_Name_Type) of Boolean;
   type Array_Of_Power_Source_Voltage_Type is array
     (Power_Source_Name_Type) of Electrical_Units_Types.Volts_Dc;
   package Path_Collection is new Path_Collection_G
     (Voltage_Type                       => Electrical_Units_Types.Volts_Dc,
      Power_Source_Name_Type             => Power_Source_Name_Type,
      Bus_Name_Type                      => Jpats_Electrical_Types.Bus_Name_Type,
      Path_Type                          => Path.Instance,
      Array_Of_Path_Type                 => Array_Of_Path_Type,
      Array_Of_Boolean_Type              => Path_Array_Of_Boolean_Type,
      Array_Of_Power_Source_Voltage_Type => Array_Of_Power_Source_Voltage_Type,
      Complete_A_Path                    => Path.Complete,
      Incomplete_A_Path                  => Path.Incomplete,
      Is_A_Path_Complete                 => Path.Is_Complete,
      A_Path_Voltage                     => Path.Voltage,
      Update_A_Path                      => Path.Update,
      Initialize_A_Path                  => Path.Initialize,
      Package_Name                       => "Jpats_Electrical.Container.Path_Collection");


-- current limiters
   package Current_Limiter is new Current_Limiter_G
     (Package_Name => "Jpats_Electrical.Container.Current_Limiter");
   type Current_Limiter_Name_Type is (Battery_Bus_Current_Limiter,
                                      Generator_Bus_Current_Limiter);
   type Array_Of_Current_Limiter_Type is array
     (Current_Limiter_Name_Type) of Current_Limiter.Instance;
   type Current_Limiter_Boolean_Array is array
     (Current_Limiter_Name_Type) of Boolean;
   package Current_Limiter_Collection is new Current_Limiter_Collection_G
     (Current_Limiter_Name_Type     => Current_Limiter_Name_Type,
      Current_Limiter_Type          => Current_Limiter.Instance,
      Array_Of_Current_Limiter_Type => Array_Of_Current_Limiter_Type,
      Array_Of_Boolean              => Current_Limiter_Boolean_Array,
      Open_A_Current_Limiter        => Current_Limiter.Open,
      Close_A_Current_Limiter       => Current_Limiter.Close,
      Initialize_A_Current_Limiter  => Current_Limiter.Initialize,
      Update_A_Current_Limiter      => Current_Limiter.Update,
      A_Current_Limiter_Open        => Current_Limiter.Is_Open,
      A_Current_Limiter_Closed      => Current_Limiter.Is_Closed,
      Package_Name                  => "Jpats_Electrical.Container.Current_Limiter_Collection");

-- GCU
   package Generator_Control_Unit is new Generator_Control_Unit_G
     (Voltage_Type => Electrical_Units_Types.Volts_Dc,
      Ampere_Type  => Electrical_Units_Types.Amps,
      Package_Name => "Jpats_Electrical.Container.Generator_Control_Unit");

-- auxiliary battery mount
   package Auxiliary_Battery_Mount is new Auxiliary_Battery_Mount_G
     (Voltage_Type => Electrical_Units_Types.Volts_Dc,
      Package_Name => "Jpats_Electrical.Container.Auxiliary_Battery_Mount");

-- voltmeter
   package Voltmeter is new Voltmeter_G
     (Voltage_Type => Electrical_Units_Types.Volts_Dc,
      Ampere_Type  => Electrical_Units_Types.Amps,
      Package_Name => "Jpats_Electrical.Container.Voltmeter");


   type Instance is
      record
         The_Circuit_Breakers        : Circuit_Breaker_Collection.Instance;
         The_Buses                   : Bus_Collection.Instance;
         The_Relays                  : Coil_Relay_Collection.Instance;
         The_Paths                   : Path_Collection.Instance;
         The_Current_Limiters        : Current_Limiter_Collection.Instance;
         The_Generator_Control_Unit  : Generator_Control_Unit.Instance;
         The_Auxiliary_Battery_Mount : Auxiliary_Battery_Mount.Instance;
         The_Voltmeter               : Voltmeter.Instance;
         The_Battery                 : Power_Supply.Battery.Instance;
         The_Auxiliary_Battery       : Power_Supply.Auxiliary_Battery.Instance;
         The_Generator               : Power_Supply.Generator.Instance;
         The_External_Power          : Power_Supply.External_Power.Instance;

         Cb_Hot       : Circuit_Breaker_Array_Of_Boolean := (others=>False);
         Cb_In        : Circuit_Breaker_Array_Of_Boolean := (others=>True);
         Cb_Force_Hot : Circuit_Breaker_Array_Of_Boolean := (others=>True);

         Bus_Power_Last_Pass : Bus_Array_Of_Boolean := (others=>False);

         Low_Battery_Voltage_Malf_Lp : Boolean := False;
         Batt_Bus_Light_Start_Malf_Lp : Boolean := False;
         Dead_Aux_Batt_Commanded_Last_Pass : Boolean := False;

         VM_Noise          : Float := 0.0;
         VM_Noise_Tmr      : Float := 0.0;
         VM_Noise_Duration : Float := 0.0;
         VM_Five_Min_Timer : Float := 0.0;
         VM_Twenty_Min_Timer : Float := 0.0;
         VM_Battery_Charging_Off_Gen : Boolean := False;

         Ext_Pwr_Connector_In    : Boolean := False;
         Ext_Pwr_On              : Boolean := False;

      end record;

   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         -- DIGITAL INPUT
         Master_Bat_On_Sw            : Boolean := True;
         Master_Gen_On_Sw            : Boolean := False;
         Aux_Bat_On_Sw               : Boolean := False;
         Gen_Reset_Sw                : Boolean := False;
         Aux_Batt_Test_Sw            : Boolean := False;
         Avionics_Master_On_Sw       : Boolean := False;
         Bus_Tie_Open_Sw             : Boolean := False;


         -- battery cb panel cb D/Is
         Fire_1_Di                      : Boolean := True;
         Cws_Batt_Di                    : Boolean := True;
         Fuel_Qty_Lo_Di                 : Boolean := True;
         Fldt_Di                        : Boolean := True;
         Aux_Bat_Di                     : Boolean := True;
         Fwd_Avi_Batt_Di                : Boolean := True;
         Aft_Bat_Di                     : Boolean := True;
         Avi_Mstr_Di                    : Boolean := True;
         Bat_Sw_Di                      : Boolean := True;
         Ldg_Di                         : Boolean := True;
         Inst_Di                        : Boolean := True;
         Coll_Di                        : Boolean := True;
         Stby_Di                        : Boolean := True;
         Util_Di                        : Boolean := True;
         Ail_El_Trim_Di                 : Boolean := True;
         Rud_Trim_Di                    : Boolean := True;
         Ldg_Gr_Cont_Di                 : Boolean := True;
         Flap_Cont_Di                   : Boolean := True;
         Hyd_Sys_Di                     : Boolean := True;
         Inflow_Sys_Di                  : Boolean := True;
         Alt_Eng_Dis_Di                 : Boolean := True;
         Edm_Batt_Di                    : Boolean := True;
         Oil_Trx_Di                     : Boolean := True;
         Start_Di                       : Boolean := True;
         Ign_Di                         : Boolean := True;
         Boost_Pump_Di                  : Boolean := True;
         Pmu_Di                         : Boolean := True;
         Radio_Rlys_Batt_Di             : Boolean := True;
         Prop_Sys_Di                    : Boolean := True;
         Fdr_Di                         : Boolean := True;
         Aoa_Di                         : Boolean := True;
         Turn_Rt_Di                     : Boolean := True;
         Altm_Batt_Di                   : Boolean := True;
         Gyro_Di                        : Boolean := True;
         Uhf_Comm_Di                    : Boolean := True;
         Aft_Inst_Di                    : Boolean := True;
         Gps_Di                         : Boolean := True;
         Eadi_Di                        : Boolean := True;
         Aft_Avi_Batt_Di                : Boolean := True;
         Ahrs_Di                        : Boolean := True;
         Audio_Di                       : Boolean := True;


         -- generator bus cb panel D/Is
         Fire_2_Di                      : Boolean := True;
         Cws_Gen_Di                     : Boolean := True;
         Aural_Warn_Di                  : Boolean := True;
         Air_Cond_Di                    : Boolean := True;
         Evap_Blower_Di                 : Boolean := True;
         Ckpt_Temp_Di                   : Boolean := True;
         Aoa_Ht_Di                      : Boolean := True;
         Pitot_Ht_Di                    : Boolean := True;
         Fwd_Avi_Gen_Di                 : Boolean := True;
         Aft_Gen_Di                     : Boolean := True;
         Gen_Sw_Di                      : Boolean := True;
         Taxi_Di                        : Boolean := True;
         Side_Di                        : Boolean := True;
         Nav_Di                         : Boolean := True;
         Test_Di                        : Boolean := True;
         Speed_Brake_Di                 : Boolean := True;
         Nws_Di                         : Boolean := True;
         Tad_Di                         : Boolean := True;
         Trim_Ind_Di                    : Boolean := True;
         Pri_Eng_Dis_Di                 : Boolean := True;
         Edm_Gen_Di                     : Boolean := True;
         Eng_Sys_Dis_Di                 : Boolean := True;
         Fuel_Bal_Di                    : Boolean := True;
         Seat_Adj_Di                    : Boolean := True;
         Radio_Rlys_Di                  : Boolean := True;
         Ehsi_Di                        : Boolean := True;
         Asi_Di                         : Boolean := True;
         Altm_Gen_Di                    : Boolean := True;
         Vvi_Di                         : Boolean := True;
         Tas_Di                         : Boolean := True;
         Xpdr_Di                        : Boolean := True;
         Vhf_Comm_Di                    : Boolean := True;
         Vhf_Nav_Di                     : Boolean := True;
         Adc_Di                         : Boolean := True;
         Dme_Di                         : Boolean := True;
         Rmu_Gen_Di                     : Boolean := True;
         Aft_Avi_Gen_Di                 : Boolean := True;



         -- DIGITAL OUTPUT
         Aux_Batt_Lamp                  : Boolean := False;
         Master_Bat_On                  : Boolean := False;
         Master_Gen_On                  : Boolean := False;


         -- battery cb panel cb D/Os
         Fire_1_Do                      : Boolean := False;
         Cws_Batt_Do                    : Boolean := False;
         Fuel_Qty_Lo_Do                 : Boolean := False;
         Fldt_Do                        : Boolean := False;
         Aux_Bat_Do                     : Boolean := False;
         Fwd_Avi_Batt_Do                : Boolean := False;
         Aft_Bat_Do                     : Boolean := False;
         Avi_Mstr_Do                    : Boolean := False;
         Bat_Sw_Do                      : Boolean := False;
         Ldg_Do                         : Boolean := False;
         Inst_Do                        : Boolean := False;
         Coll_Do                        : Boolean := False;
         Stby_Do                        : Boolean := False;
         Util_Do                        : Boolean := False;
         Ail_El_Trim_Do                 : Boolean := False;
         Rud_Trim_Do                    : Boolean := False;
         Ldg_Gr_Cont_Do                 : Boolean := False;
         Flap_Cont_Do                   : Boolean := False;
         Hyd_Sys_Do                     : Boolean := False;
         Inflow_Sys_Do                  : Boolean := False;
         Alt_Eng_Dis_Do                 : Boolean := False;
         Edm_Batt_Do                    : Boolean := False;
         Oil_Trx_Do                     : Boolean := False;
         Start_Do                       : Boolean := False;
         Ign_Do                         : Boolean := False;
         Boost_Pump_Do                  : Boolean := False;
         Pmu_Do                         : Boolean := False;
         Radio_Rlys_Batt_Do             : Boolean := False;
         Prop_Sys_Do                    : Boolean := False;
         Fdr_Do                         : Boolean := False;
         Aoa_Do                         : Boolean := False;
         Turn_Rt_Do                     : Boolean := False;
         Altm_Batt_Do                   : Boolean := False;
         Gyro_Do                        : Boolean := False;
         Uhf_Comm_Do                    : Boolean := False;
         Aft_Inst_Do                    : Boolean := False;
         Gps_Do                         : Boolean := False;
         Eadi_Do                        : Boolean := False;
         Aft_Avi_Batt_Do                : Boolean := False;
         Ahrs_Do                        : Boolean := False;
         Audio_Do                       : Boolean := False;


         -- generator bus cb panel D/Os
         Fire_2_Do                      : Boolean := False;
         Cws_Gen_Do                     : Boolean := False;
         Aural_Warn_Do                  : Boolean := False;
         Air_Cond_Do                    : Boolean := False;
         Evap_Blower_Do                 : Boolean := False;
         Ckpt_Temp_Do                   : Boolean := False;
         Aoa_Ht_Do                      : Boolean := False;
         Pitot_Ht_Do                    : Boolean := False;
         Fwd_Avi_Gen_Do                 : Boolean := False;
         Aft_Gen_Do                     : Boolean := False;
         Gen_Sw_Do                      : Boolean := False;
         Taxi_Do                        : Boolean := False;
         Side_Do                        : Boolean := False;
         Nav_Do                         : Boolean := False;
         Test_Do                        : Boolean := False;
         Speed_Brake_Do                 : Boolean := False;
         Nws_Do                         : Boolean := False;
         Tad_Do                         : Boolean := False;
         Trim_Ind_Do                    : Boolean := False;
         Pri_Eng_Dis_Do                 : Boolean := False;
         Edm_Gen_Do                     : Boolean := False;
         Eng_Sys_Dis_Do                 : Boolean := False;
         Fuel_Bal_Do                    : Boolean := False;
         Seat_Adj_Do                    : Boolean := False;
         Radio_Rlys_Do                  : Boolean := False;
         Ehsi_Do                        : Boolean := False;
         Asi_Do                         : Boolean := False;
         Altm_Gen_Do                    : Boolean := False;
         Vvi_Do                         : Boolean := False;
         Tas_Do                         : Boolean := False;
         Xpdr_Do                        : Boolean := False;
         Vhf_Comm_Do                    : Boolean := False;
         Vhf_Nav_Do                     : Boolean := False;
         Adc_Do                         : Boolean := False;
         Dme_Do                         : Boolean := False;
         Rmu_Gen_Do                     : Boolean := False;
         Aft_Avi_Gen_Do                 : Boolean := False;

         -- analog input
         -- analog output
--         Display_Voltage                : Float;
--         Display_Load                   : Float;

         -- spare
         Spare_Io_1                      : Boolean := False;
      end record;


   Io_Size : constant Integer := 4;

   for Io_Interface_Instance use
      record
         -- spare
         Spare_Io_1                  at  000*Io_Size range 0..31;


         -- DIGITAL INPUT
         Master_Bat_On_Sw            at  001*Io_Size range 0..31;
         Master_Gen_On_Sw            at  002*Io_Size range 0..31;
         Aux_Bat_On_Sw               at  003*Io_Size range 0..31;
         Gen_Reset_Sw                at  004*Io_Size range 0..31;
         Aux_Batt_Test_Sw            at  005*Io_Size range 0..31;
         Avionics_Master_On_Sw       at  006*Io_Size range 0..31;
         Bus_Tie_Open_Sw             at  007*Io_Size range 0..31;


         -- battery cb panel cb D/Is
         Fire_1_Di                      at  008*Io_Size range 0..31;
         Cws_Batt_Di                    at  009*Io_Size range 0..31;
         Fuel_Qty_Lo_Di                 at  010*Io_Size range 0..31;
         Fldt_Di                        at  011*Io_Size range 0..31;
         Aux_Bat_Di                     at  012*Io_Size range 0..31;
         Fwd_Avi_Batt_Di                at  013*Io_Size range 0..31;
         Aft_Bat_Di                     at  014*Io_Size range 0..31;
         Avi_Mstr_Di                    at  015*Io_Size range 0..31;
         Bat_Sw_Di                      at  016*Io_Size range 0..31;
         Ldg_Di                         at  017*Io_Size range 0..31;
         Inst_Di                        at  018*Io_Size range 0..31;
         Coll_Di                        at  019*Io_Size range 0..31;
         Stby_Di                        at  020*Io_Size range 0..31;
         Util_Di                        at  021*Io_Size range 0..31;
         Ail_El_Trim_Di                 at  022*Io_Size range 0..31;
         Rud_Trim_Di                    at  023*Io_Size range 0..31;
         Ldg_Gr_Cont_Di                 at  024*Io_Size range 0..31;
         Flap_Cont_Di                   at  025*Io_Size range 0..31;
         Hyd_Sys_Di                     at  026*Io_Size range 0..31;
         Inflow_Sys_Di                  at  027*Io_Size range 0..31;
         Alt_Eng_Dis_Di                 at  028*Io_Size range 0..31;
         Edm_Batt_Di                    at  029*Io_Size range 0..31;
         Oil_Trx_Di                     at  030*Io_Size range 0..31;
         Start_Di                       at  031*Io_Size range 0..31;
         Ign_Di                         at  032*Io_Size range 0..31;
         Boost_Pump_Di                  at  033*Io_Size range 0..31;
         Pmu_Di                         at  034*Io_Size range 0..31;
         Radio_Rlys_Batt_Di             at  035*Io_Size range 0..31;
         Prop_Sys_Di                    at  036*Io_Size range 0..31;
         Fdr_Di                         at  037*Io_Size range 0..31;
         Aoa_Di                         at  038*Io_Size range 0..31;
         Turn_Rt_Di                     at  039*Io_Size range 0..31;
         Altm_Batt_Di                   at  040*Io_Size range 0..31;
         Gyro_Di                        at  041*Io_Size range 0..31;
         Uhf_Comm_Di                    at  042*Io_Size range 0..31;
         Aft_Inst_Di                    at  043*Io_Size range 0..31;
         Gps_Di                         at  044*Io_Size range 0..31;
         Eadi_Di                        at  045*Io_Size range 0..31;
         Aft_Avi_Batt_Di                at  046*Io_Size range 0..31;
         Ahrs_Di                        at  047*Io_Size range 0..31;
         Audio_Di                       at  048*Io_Size range 0..31;


         -- generator bus cb panel D/Is
         Fire_2_Di                      at  049*Io_Size range 0..31;
         Cws_Gen_Di                     at  050*Io_Size range 0..31;
         Aural_Warn_Di                  at  051*Io_Size range 0..31;
         Air_Cond_Di                    at  052*Io_Size range 0..31;
         Evap_Blower_Di                 at  053*Io_Size range 0..31;
         Ckpt_Temp_Di                   at  054*Io_Size range 0..31;
         Aoa_Ht_Di                      at  055*Io_Size range 0..31;
         Pitot_Ht_Di                    at  056*Io_Size range 0..31;
         Fwd_Avi_Gen_Di                 at  057*Io_Size range 0..31;
         Aft_Gen_Di                     at  058*Io_Size range 0..31;
         Gen_Sw_Di                      at  059*Io_Size range 0..31;
         Taxi_Di                        at  060*Io_Size range 0..31;
         Side_Di                        at  061*Io_Size range 0..31;
         Nav_Di                         at  062*Io_Size range 0..31;
         Test_Di                        at  063*Io_Size range 0..31;
         Speed_Brake_Di                 at  064*Io_Size range 0..31;
         Nws_Di                         at  065*Io_Size range 0..31;
         Tad_Di                         at  066*Io_Size range 0..31;
         Trim_Ind_Di                    at  067*Io_Size range 0..31;
         Pri_Eng_Dis_Di                 at  068*Io_Size range 0..31;
         Edm_Gen_Di                     at  069*Io_Size range 0..31;
         Eng_Sys_Dis_Di                 at  070*Io_Size range 0..31;
         Fuel_Bal_Di                    at  071*Io_Size range 0..31;
         Seat_Adj_Di                    at  072*Io_Size range 0..31;
         Radio_Rlys_Di                  at  073*Io_Size range 0..31;
         Ehsi_Di                        at  074*Io_Size range 0..31;
         Asi_Di                         at  075*Io_Size range 0..31;
         Altm_Gen_Di                    at  076*Io_Size range 0..31;
         Vvi_Di                         at  077*Io_Size range 0..31;
         Tas_Di                         at  078*Io_Size range 0..31;
         Xpdr_Di                        at  079*Io_Size range 0..31;
         Vhf_Comm_Di                    at  080*Io_Size range 0..31;
         Vhf_Nav_Di                     at  081*Io_Size range 0..31;
         Adc_Di                         at  082*Io_Size range 0..31;
         Dme_Di                         at  083*Io_Size range 0..31;
         Rmu_Gen_Di                     at  084*Io_Size range 0..31;
         Aft_Avi_Gen_Di                 at  085*Io_Size range 0..31;



         -- DIGITAL OUTPUT
         Aux_Batt_Lamp                  at  086*Io_Size range 0..31;
         Master_Bat_On                  at  087*Io_Size range 0..31;
         Master_Gen_On                  at  088*Io_Size range 0..31;


         -- battery cb panel cb D/Os
         Fire_1_Do                      at  089*Io_Size range 0..31;
         Cws_Batt_Do                    at  090*Io_Size range 0..31;
         Fuel_Qty_Lo_Do                 at  091*Io_Size range 0..31;
         Fldt_Do                        at  092*Io_Size range 0..31;
         Aux_Bat_Do                     at  093*Io_Size range 0..31;
         Fwd_Avi_Batt_Do                at  094*Io_Size range 0..31;
         Aft_Bat_Do                     at  095*Io_Size range 0..31;
         Avi_Mstr_Do                    at  096*Io_Size range 0..31;
         Bat_Sw_Do                      at  097*Io_Size range 0..31;
         Ldg_Do                         at  098*Io_Size range 0..31;
         Inst_Do                        at  099*Io_Size range 0..31;
         Coll_Do                        at  100*Io_Size range 0..31;
         Stby_Do                        at  101*Io_Size range 0..31;
         Util_Do                        at  102*Io_Size range 0..31;
         Ail_El_Trim_Do                 at  103*Io_Size range 0..31;
         Rud_Trim_Do                    at  104*Io_Size range 0..31;
         Ldg_Gr_Cont_Do                 at  105*Io_Size range 0..31;
         Flap_Cont_Do                   at  106*Io_Size range 0..31;
         Hyd_Sys_Do                     at  107*Io_Size range 0..31;
         Inflow_Sys_Do                  at  108*Io_Size range 0..31;
         Alt_Eng_Dis_Do                 at  109*Io_Size range 0..31;
         Edm_Batt_Do                    at  110*Io_Size range 0..31;
         Oil_Trx_Do                     at  111*Io_Size range 0..31;
         Start_Do                       at  112*Io_Size range 0..31;
         Ign_Do                         at  113*Io_Size range 0..31;
         Boost_Pump_Do                  at  114*Io_Size range 0..31;
         Pmu_Do                         at  115*Io_Size range 0..31;
         Radio_Rlys_Batt_Do             at  116*Io_Size range 0..31;
         Prop_Sys_Do                    at  117*Io_Size range 0..31;
         Fdr_Do                         at  118*Io_Size range 0..31;
         Aoa_Do                         at  119*Io_Size range 0..31;
         Turn_Rt_Do                     at  120*Io_Size range 0..31;
         Altm_Batt_Do                   at  121*Io_Size range 0..31;
         Gyro_Do                        at  122*Io_Size range 0..31;
         Uhf_Comm_Do                    at  123*Io_Size range 0..31;
         Aft_Inst_Do                    at  124*Io_Size range 0..31;
         Gps_Do                         at  125*Io_Size range 0..31;
         Eadi_Do                        at  126*Io_Size range 0..31;
         Aft_Avi_Batt_Do                at  127*Io_Size range 0..31;
         Ahrs_Do                        at  128*Io_Size range 0..31;
         Audio_Do                       at  129*Io_Size range 0..31;


         -- generator bus cb panel D/Os
         Fire_2_Do                      at  130*Io_Size range 0..31;
         Cws_Gen_Do                     at  131*Io_Size range 0..31;
         Aural_Warn_Do                  at  132*Io_Size range 0..31;
         Air_Cond_Do                    at  133*Io_Size range 0..31;
         Evap_Blower_Do                 at  134*Io_Size range 0..31;
         Ckpt_Temp_Do                   at  135*Io_Size range 0..31;
         Aoa_Ht_Do                      at  136*Io_Size range 0..31;
         Pitot_Ht_Do                    at  137*Io_Size range 0..31;
         Fwd_Avi_Gen_Do                 at  138*Io_Size range 0..31;
         Aft_Gen_Do                     at  139*Io_Size range 0..31;
         Gen_Sw_Do                      at  140*Io_Size range 0..31;
         Taxi_Do                        at  141*Io_Size range 0..31;
         Side_Do                        at  142*Io_Size range 0..31;
         Nav_Do                         at  143*Io_Size range 0..31;
         Test_Do                        at  144*Io_Size range 0..31;
         Speed_Brake_Do                 at  145*Io_Size range 0..31;
         Nws_Do                         at  146*Io_Size range 0..31;
         Tad_Do                         at  147*Io_Size range 0..31;
         Trim_Ind_Do                    at  148*Io_Size range 0..31;
         Pri_Eng_Dis_Do                 at  149*Io_Size range 0..31;
         Edm_Gen_Do                     at  150*Io_Size range 0..31;
         Eng_Sys_Dis_Do                 at  151*Io_Size range 0..31;
         Fuel_Bal_Do                    at  152*Io_Size range 0..31;
         Seat_Adj_Do                    at  153*Io_Size range 0..31;
         Radio_Rlys_Do                  at  154*Io_Size range 0..31;
         Ehsi_Do                        at  155*Io_Size range 0..31;
         Asi_Do                         at  156*Io_Size range 0..31;
         Altm_Gen_Do                    at  157*Io_Size range 0..31;
         Vvi_Do                         at  158*Io_Size range 0..31;
         Tas_Do                         at  159*Io_Size range 0..31;
         Xpdr_Do                        at  160*Io_Size range 0..31;
         Vhf_Comm_Do                    at  161*Io_Size range 0..31;
         Vhf_Nav_Do                     at  162*Io_Size range 0..31;
         Adc_Do                         at  163*Io_Size range 0..31;
         Dme_Do                         at  164*Io_Size range 0..31;
         Rmu_Gen_Do                     at  165*Io_Size range 0..31;
         Aft_Avi_Gen_Do                 at  166*Io_Size range 0..31;

         -- analog input
         -- analog output
--         Display_Voltage                : Float;
--         Display_Load                   : Float;

      end record;

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         -------------------------------------------------------------
         -----  DEBUG  -----------------------------------------------
         -------------------------------------------------------------
         BattLoad                       : Float := 0.0;
         GenLoad                        : Float := 0.0;
         AuxBattLoad                    : Float := 0.0;
         ExtPwrLoad                     : Float := 0.0;
         BattIsCharging                 : Boolean := False;
         AuxBattIsCharging              : Boolean := False;
         StarterLoad                    : Float := 0.0;
         -------------------------------------------------------------
         -------------------------------------------------------------
         -------------------------------------------------------------

         -- malfs
         Gcu_Fail                       : Boolean := False;
         Open_Batt_Bus_Current_Limiter  : Boolean := False;
         Dead_Aux_Batt                  : Boolean := False;
         Open_Bus_Tie_Relay             : Boolean := False;
         Low_Battery_Voltage            : Boolean := False;
         Open_Gen_Bus_Current_Limiter   : Boolean := False;
         Batt_Bus_Light_Start           : Boolean := False;

         -- configurations
         The_Gpu_Connector_In          : Boolean := False;
         The_Gpu_Power_On              : Boolean := False;
         Battery_Reset                 : Boolean := False;

         -- status
         Display_Voltage               : Float := 0.0;
         Display_Load                  : Float := 0.0;

         -- cbs
         Kcbhot                        : Boolean := False;
         Kcbin                         : Boolean := false;
         Clear_All_Trip                : Boolean := False;

         Fire_1_Do                      : Boolean := False;
         Cws_Batt_Do                    : Boolean := False;
         Fuel_Qty_Lo_Do                 : Boolean := False;
         Fldt_Do                        : Boolean := False;
         Aux_Bat_Do                     : Boolean := False;
         Fwd_Avi_Batt_Do                : Boolean := False;
         Aft_Bat_Do                     : Boolean := False;
         Avi_Mstr_Do                    : Boolean := False;
         Bat_Sw_Do                      : Boolean := False;
         Ldg_Do                         : Boolean := False;
         Inst_Do                        : Boolean := False;
         Coll_Do                        : Boolean := False;
         Stby_Do                        : Boolean := False;
         Util_Do                        : Boolean := False;
         Ail_El_Trim_Do                 : Boolean := False;
         Rud_Trim_Do                    : Boolean := False;
         Ldg_Gr_Cont_Do                 : Boolean := False;
         Flap_Cont_Do                   : Boolean := False;
         Hyd_Sys_Do                     : Boolean := False;
         Inflow_Sys_Do                  : Boolean := False;
         Alt_Eng_Dis_Do                 : Boolean := False;
         Edm_Batt_Do                    : Boolean := False;
         Oil_Trx_Do                     : Boolean := False;
         Start_Do                       : Boolean := False;
         Ign_Do                         : Boolean := False;
         Boost_Pump_Do                  : Boolean := False;
         Pmu_Do                         : Boolean := False;
         Radio_Rlys_Batt_Do             : Boolean := False;
         Prop_Sys_Do                    : Boolean := False;
         Fdr_Do                         : Boolean := False;
         Aoa_Do                         : Boolean := False;
         Turn_Rt_Do                     : Boolean := False;
         Altm_Batt_Do                   : Boolean := False;
         Gyro_Do                        : Boolean := False;
         Uhf_Comm_Do                    : Boolean := False;
         Aft_Inst_Do                    : Boolean := False;
         Gps_Do                         : Boolean := False;
         Eadi_Do                        : Boolean := False;
         Aft_Avi_Batt_Do                : Boolean := False;
         Ahrs_Do                        : Boolean := False;
         Audio_Do                       : Boolean := False;


         -- generator bus cb panel D/Os
         Fire_2_Do                      : Boolean := False;
         Cws_Gen_Do                     : Boolean := False;
         Aural_Warn_Do                  : Boolean := False;
         Air_Cond_Do                    : Boolean := False;
         Evap_Blower_Do                 : Boolean := False;
         Ckpt_Temp_Do                   : Boolean := False;
         Aoa_Ht_Do                      : Boolean := False;
         Pitot_Ht_Do                    : Boolean := False;
         Fwd_Avi_Gen_Do                 : Boolean := False;
         Aft_Gen_Do                     : Boolean := False;
         Gen_Sw_Do                      : Boolean := False;
         Taxi_Do                        : Boolean := False;
         Side_Do                        : Boolean := False;
         Nav_Do                         : Boolean := False;
         Test_Do                        : Boolean := False;
         Speed_Brake_Do                 : Boolean := False;
         Nws_Do                         : Boolean := False;
         Tad_Do                         : Boolean := False;
         Trim_Ind_Do                    : Boolean := False;
         Pri_Eng_Dis_Do                 : Boolean := False;
         Edm_Gen_Do                     : Boolean := False;
         Eng_Sys_Dis_Do                 : Boolean := False;
         Fuel_Bal_Do                    : Boolean := False;
         Seat_Adj_Do                    : Boolean := False;
         Radio_Rlys_Do                  : Boolean := False;
         Ehsi_Do                        : Boolean := False;
         Asi_Do                         : Boolean := False;
         Altm_Gen_Do                    : Boolean := False;
         Vvi_Do                         : Boolean := False;
         Tas_Do                         : Boolean := False;
         Xpdr_Do                        : Boolean := False;
         Vhf_Comm_Do                    : Boolean := False;
         Vhf_Nav_Do                     : Boolean := False;
         Adc_Do                         : Boolean := False;
         Dme_Do                         : Boolean := False;
         Rmu_Gen_Do                     : Boolean := False;
         Aft_Avi_Gen_Do                 : Boolean := False;


      end record;
   This_Ios_Interface : Ios_Interface_Instance;

   type Host_Interface_Instance is
      record
         Fire_1_Do                      : Boolean := False;
         Cws_Batt_Do                    : Boolean := False;
         Fuel_Qty_Lo_Do                 : Boolean := False;
         Fldt_Do                        : Boolean := False;
         Aux_Bat_Do                     : Boolean := False;
         Fwd_Avi_Batt_Do                : Boolean := False;
         Aft_Bat_Do                     : Boolean := False;
         Avi_Mstr_Do                    : Boolean := False;
         Bat_Sw_Do                      : Boolean := False;
         Ldg_Do                         : Boolean := False;
         Inst_Do                        : Boolean := False;
         Coll_Do                        : Boolean := False;
         Stby_Do                        : Boolean := False;
         Util_Do                        : Boolean := False;
         Ail_El_Trim_Do                 : Boolean := False;
         Rud_Trim_Do                    : Boolean := False;
         Ldg_Gr_Cont_Do                 : Boolean := False;
         Flap_Cont_Do                   : Boolean := False;
         Hyd_Sys_Do                     : Boolean := False;
         Inflow_Sys_Do                  : Boolean := False;
         Alt_Eng_Dis_Do                 : Boolean := False;
         Edm_Batt_Do                    : Boolean := False;
         Oil_Trx_Do                     : Boolean := False;
         Start_Do                       : Boolean := False;
         Ign_Do                         : Boolean := False;
         Boost_Pump_Do                  : Boolean := False;
         Pmu_Do                         : Boolean := False;
         Radio_Rlys_Batt_Do             : Boolean := False;
         Prop_Sys_Do                    : Boolean := False;
         Fdr_Do                         : Boolean := False;
         Aoa_Do                         : Boolean := False;
         Turn_Rt_Do                     : Boolean := False;
         Altm_Batt_Do                   : Boolean := False;
         Gyro_Do                        : Boolean := False;
         Uhf_Comm_Do                    : Boolean := False;
         Aft_Inst_Do                    : Boolean := False;
         Gps_Do                         : Boolean := False;
         Eadi_Do                        : Boolean := False;
         Aft_Avi_Batt_Do                : Boolean := False;
         Ahrs_Do                        : Boolean := False;
         Audio_Do                       : Boolean := False;


         -- generator bus cb panel D/Os
         Fire_2_Do                      : Boolean := False;
         Cws_Gen_Do                     : Boolean := False;
         Aural_Warn_Do                  : Boolean := False;
         Air_Cond_Do                    : Boolean := False;
         Evap_Blower_Do                 : Boolean := False;
         Ckpt_Temp_Do                   : Boolean := False;
         Aoa_Ht_Do                      : Boolean := False;
         Pitot_Ht_Do                    : Boolean := False;
         Fwd_Avi_Gen_Do                 : Boolean := False;
         Aft_Gen_Do                     : Boolean := False;
         Gen_Sw_Do                      : Boolean := False;
         Taxi_Do                        : Boolean := False;
         Side_Do                        : Boolean := False;
         Nav_Do                         : Boolean := False;
         Test_Do                        : Boolean := False;
         Speed_Brake_Do                 : Boolean := False;
         Nws_Do                         : Boolean := False;
         Tad_Do                         : Boolean := False;
         Trim_Ind_Do                    : Boolean := False;
         Pri_Eng_Dis_Do                 : Boolean := False;
         Edm_Gen_Do                     : Boolean := False;
         Eng_Sys_Dis_Do                 : Boolean := False;
         Fuel_Bal_Do                    : Boolean := False;
         Seat_Adj_Do                    : Boolean := False;
         Radio_Rlys_Do                  : Boolean := False;
         Ehsi_Do                        : Boolean := False;
         Asi_Do                         : Boolean := False;
         Altm_Gen_Do                    : Boolean := False;
         Vvi_Do                         : Boolean := False;
         Tas_Do                         : Boolean := False;
         Xpdr_Do                        : Boolean := False;
         Vhf_Comm_Do                    : Boolean := False;
         Vhf_Nav_Do                     : Boolean := False;
         Adc_Do                         : Boolean := False;
         Dme_Do                         : Boolean := False;
         Rmu_Gen_Do                     : Boolean := False;
         Aft_Avi_Gen_Do                 : Boolean := False;


         Battery_Reset_Command          : Boolean := False;

   end record;
   This_Host_Interface : Host_Interface_Instance;


end Jpats_Electrical.Container;




