-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Electrical.Container;
with Jpats_Electrical_Types;
with Power_Supply.Battery;
with Power_Supply.Generator;
with Power_Supply.External_Power;
with Jpats_Auto_Test;
with Log;

package body Jpats_Electrical.Circuit_Breaker_Controller is

   package Ele_T        renames Jpats_Electrical_Types;
   package Ctnr         renames Container;
   package Pwr_Src      renames Power_Supply;
   package Buses        renames Ctnr.Bus_Collection;
   package Batt         renames Power_Supply.Battery;
   package Gen          renames Power_Supply.Generator;
   package Ext_Pwr      renames Power_Supply.External_Power;
   package Aux_Batt_Mnt renames Ctnr.Auxiliary_Battery_Mount;
   package Relays       renames Ctnr.Coil_Relay_Collection;
   package Cbs          renames Ctnr.Circuit_Breaker_Collection;

   Cb_Hot       : Ctnr.Circuit_Breaker_Array_Of_Boolean renames Ctnr.This_Subsystem.Cb_Hot;
   Cb_In        : Ctnr.Circuit_Breaker_Array_Of_Boolean renames Ctnr.This_Subsystem.Cb_In;
   Cb_Force_Hot : Ctnr.Circuit_Breaker_Array_Of_Boolean renames Ctnr.This_Subsystem.Cb_Force_Hot;

   Bus_Power_Last_Pass : Ctnr.Bus_Array_Of_Boolean renames Ctnr.This_Subsystem.Bus_Power_Last_Pass;

   Fwd_Batt_Bus_Is_Powered_Last_Pass      : Boolean renames Bus_Power_Last_Pass(Ele_T.Forward_Battery_Bus);
   Fwd_Gen_Bus_Is_Powered_Last_Pass       : Boolean renames Bus_Power_Last_Pass(Ele_T.Forward_Generator_Bus);
   Fwd_Avi_Batt_Bus_Is_Powered_Last_Pass  : Boolean renames Bus_Power_Last_Pass(Ele_T.Forward_Avionics_Battery_Bus);
   Fwd_Avi_Gen_Bus_Is_Powered_Last_Pass   : Boolean renames Bus_Power_Last_Pass(Ele_T.Forward_Avionics_Generator_Bus);
   Hot_Batt_Bus_Is_Powered_Last_Pass      : Boolean renames Bus_Power_Last_Pass(Ele_T.Hot_Battery_Bus);
   Gen_Bus_Is_Powered_Last_Pass           : Boolean renames Bus_Power_Last_Pass(Ele_T.Generator_Bus);
   Aft_Batt_Bus_Is_Powered_Last_Pass      : Boolean renames Bus_Power_Last_Pass(Ele_T.Aft_Battery_Bus);
   Aft_Gen_Bus_Is_Powered_Last_Pass       : Boolean renames Bus_Power_Last_Pass(Ele_T.Aft_Generator_Bus);
   Aft_Aux_Batt_Bus_Is_Powered_Last_Pass  : Boolean renames Bus_Power_Last_Pass(Ele_T.Aft_Auxiliary_Battery_Bus);
   Fwd_Aux_Batt_Bus_Is_Powered_Last_Pass  : Boolean renames Bus_Power_Last_Pass(Ele_T.Forward_Auxiliary_Battery_Bus);
   Aft_Avi_Gen_Bus_Is_Powered_Last_Pass   : Boolean renames Bus_Power_Last_Pass(Ele_T.Aft_Avionics_Generator_Bus);
   Aft_Avi_Batt_Bus_Is_Powered_Last_Pass  : Boolean renames Bus_Power_Last_Pass(Ele_T.Aft_Avionics_Battery_Bus);
   Unused_Var1                            : Boolean renames Bus_Power_Last_Pass(Ele_T.Starter_Distribution_Bus);

   procedure Initialize
   is
   begin
      Container.Circuit_Breaker_Collection.Initialize
        (Container.This_Subsystem.The_Circuit_Breakers);
   exception
      when others =>
         Log.Report("Jpats_Electrical.Circuit_Breaker_Controller.Initialize()");
         raise;
   end Initialize;


   procedure Update
     (Iconst : in Float)
   is

      Io   : Ctnr.Io_Interface_Instance   renames Ctnr.This_Io_Interface;
      Ios  : Ctnr.Ios_Interface_Instance  renames Ctnr.This_Ios_Interface;
      Host : Ctnr.Host_Interface_Instance renames Ctnr.This_Host_Interface;

      The_Buses   : Buses.Instance    renames Ctnr.This_Subsystem.The_Buses;
      The_Batt    : Batt.Instance     renames Ctnr.This_Subsystem.The_Battery;
      The_Gen     : Gen.Instance      renames Ctnr.This_Subsystem.The_Generator;
      The_Ext_Pwr : Ext_Pwr.Instance  renames Ctnr.This_Subsystem.The_External_Power;
      The_Relays  : Relays.Instance   renames Ctnr.This_Subsystem.The_Relays;
      The_Cbs     : Cbs.Instance      renames Ctnr.This_Subsystem.The_Circuit_Breakers;

      Batt_Rly_Closed    : constant Boolean := Relays.Is_Closed (The_Relays, Ele_T.Battery_Relay);
      Gen_Rly_Closed     : constant Boolean := Relays.Is_Closed (The_Relays, Ele_T.Generator_Relay);
      Ext_Pwr_Rly_Closed : constant Boolean := Relays.Is_Closed (The_Relays, Ele_T.External_Power_Relay);
      Bus_Tie_Rly_Closed : constant Boolean := Relays.Is_Closed (The_Relays, Ele_T.Bus_Tie_Relay);

      The_Aux_Batt_Mnt : Aux_Batt_Mnt.Instance renames Ctnr.This_Subsystem.The_Auxiliary_Battery_Mount;

      Fwd_Batt_Bus_Is_Powered     : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Forward_Battery_Bus);
      Fwd_Gen_Bus_Is_Powered      : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Forward_Generator_Bus);
      Fwd_Avi_Batt_Bus_Is_Powered : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Forward_Avionics_Battery_Bus);
      Fwd_Avi_Gen_Bus_Is_Powered  : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Forward_Avionics_Generator_Bus);
      Hot_Batt_Bus_Is_Powered     : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Hot_Battery_Bus);
      Gen_Bus_Is_Powered          : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Generator_Bus);
      Aft_Batt_Bus_Is_Powered     : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Aft_Battery_Bus);
      Aft_Gen_Bus_Is_Powered      : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Aft_Generator_Bus);
      Aft_Aux_Batt_Bus_Is_Powered : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Aft_Auxiliary_Battery_Bus);
      Fwd_Aux_Batt_Bus_Is_Powered : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Forward_Auxiliary_Battery_Bus);
      Aft_Avi_Gen_Bus_Is_Powered  : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Aft_Avionics_Generator_Bus);
      Aft_Avi_Batt_Bus_Is_Powered : constant Boolean := Buses.Is_Powered (The_Buses, Ele_T.Aft_Avionics_Battery_Bus);

      Auto_Test_On : constant Boolean := Jpats_Auto_Test.On;

      Set_Last_Pass_Bus_Power_Vars : Boolean := False;

   begin

      -------------------
      -- get cb position
      -------------------

--       Cb_In (Ele_T.Bus_Tie_Control_Cb) := True;
--       Cb_In (Ele_T.Generator_Sense_Cb) := True;
--       Cb_In (Ele_T.Ext_Pwr_Cb)         := True;
--       Cb_In (Ele_T.Aux_Batt_Cb)        := True;

      -- Generator bus

--       Cb_In (Ele_T.Cond_Blower_Cb)      := True;
--       Cb_In (Ele_T.Heat_Exch_Blower_Cb) := True;
--       Cb_In (Ele_T.Bus_Sense_Cb)        := True;

      -- Hot battery bus

--       Cb_In (Ele_T.Spare_Cb)                   := True;
--       Cb_In (Ele_T.Ram_Air_Valve_Cb)           := True;
--       Cb_In (Ele_T.Battery_Cb)                 := True;
--       Cb_In (Ele_T.Emerg_Flaps_Cb)             := True;
--       Cb_In (Ele_T.Clocks_Cb)                  := True;
--       Cb_In (Ele_T.Elt_Cb)                     := True;
--       Cb_In (Ele_T.Obogs_Cb)                   := True;
--       Cb_In (Ele_T.Fdr_Maint_Epa_Fuel_Pump_Cb) := True;

      -- Forward battery bus

      Cb_In (Ele_T.Ail_El_Trim_Cb)          := Io.Ail_El_Trim_Di;
      Cb_In (Ele_T.Rud_Trim_Cb)             := Io.Rud_Trim_Di;
      Cb_In (Ele_T.Ldg_Gr_Cont_Cb)          := Io.Ldg_Gr_Cont_Di;
      Cb_In (Ele_T.Flap_Cont_Cb)            := Io.Flap_Cont_Di;
      Cb_In (Ele_T.Util_Lt_Cb)              := Io.Util_Di;
      Cb_In (Ele_T.Coll_Lts_Cb)             := Io.Coll_Di;
      Cb_In (Ele_T.Inst_Lts_Cb)             := Io.Inst_Di;
      Cb_In (Ele_T.Ldg_Lts_Cb)              := Io.Ldg_Di;
      Cb_In (Ele_T.Cws_Cb_Fwd_Batt_Bus)     := Io.Cws_Batt_Di;
      Cb_In (Ele_T.Fuel_Qty_Lo_Cb)          := Io.Fuel_Qty_Lo_Di;
      Cb_In (Ele_T.Pmu_Cb)                  := Io.Pmu_Di;
      Cb_In (Ele_T.Boost_Pump_Cb)           := Io.Boost_Pump_Di;
      Cb_In (Ele_T.Ign_Cb)                  := Io.Ign_Di;
      Cb_In (Ele_T.Start_Cb)                := Io.Start_Di;
      Cb_In (Ele_T.Oil_Trx_Cb)              := Io.Oil_Trx_Di;
      Cb_In (Ele_T.Batt_Sw_Cb)              := Io.Bat_Sw_Di;
      Cb_In (Ele_T.Avi_Mstr_Cb)             := Io.Avi_Mstr_Di;
      Cb_In (Ele_T.Fld_Lts_Cb)              := Io.Fldt_Di;
      Cb_In (Ele_T.Alt_Eng_Dis_Cb)          := Io.Alt_Eng_Dis_Di;
      Cb_In (Ele_T.Edm_Cb_Fwd_Batt_Bus)     := Io.Edm_Batt_Di;
      Cb_In (Ele_T.Prop_Sys_Cb)             := Io.Prop_Sys_Di;
      Cb_In (Ele_T.Fdr_Cb)                  := Io.Fdr_Di;
      Cb_In (Ele_T.Aoa_Cb)                  := Io.Aoa_Di;
      Cb_In (Ele_T.Inflow_Sys_Cb)           := Io.Inflow_Sys_Di;
      Cb_In (Ele_T.Hyd_Sys_Cb)              := Io.Hyd_Sys_Di;
      Cb_In (Ele_T.Audio_Cb)                := Io.Audio_Di;
      Cb_In (Ele_T.Aft_Battery_Cb)          := Io.Aft_Bat_Di;
      Cb_In (Ele_T.Aux_Battery_Cb)          := Io.Aux_Bat_Di;
      Cb_In (Ele_T.Fwd_Avi_Cb_Fwd_Batt_Bus) := Io.Fwd_Avi_Batt_Di;

      -- Forward avionics battery bus

      Cb_In (Ele_T.Eadi_Cb)                     := Io.Eadi_Di;
      Cb_In (Ele_T.Gps_Cb)                      := Io.Gps_Di;
      Cb_In (Ele_T.Ahrs_Cb)                     := Io.Ahrs_Di;
      Cb_In (Ele_T.Aft_Avi_Cb_Fwd_Avi_Batt_Bus) := Io.Aft_Avi_Batt_Di;

      -- Aft avionics bus

--      Cb_In (Ele_T.Eadi_Cb_Aft_Avi_Batt_Bus) := True;

      -- Aft battery bus

--       Cb_In (Ele_T.Alt_Eng_Dis_Cb_Aft_Batt_Bus) := True;
--       Cb_In (Ele_T.Audio_Cb_Aft_Batt_Bus)       := True;
--       Cb_In (Ele_T.Util_Lt_Cb_Aft_Batt_Bus)     := True;
--       Cb_In (Ele_T.Inst_Lts_Cb_Aft_Batt_Bus)    := True;
--       Cb_In (Ele_T.Fld_Lts_Cb_Aft_Batt_Bus)     := True;

      -- Aft auxiliary battery bus

--       Cb_In (Ele_T.Altm_Cb_Aft_Aux_Batt_Bus)   := True;
--       Cb_In (Ele_T.Gyro_Cb_Aft_Aux_Batt_Bus)   := True;
--       Cb_In (Ele_T.Trn_Rt_Cb_Aft_Aux_Batt_Bus) := True;

      -- Forward auxiliary battery bus

      Cb_In (Ele_T.Gyro_Cb)                         := Io.Gyro_Di;
      Cb_In (Ele_T.Altm_Cb_Fwd_Aux_Batt_Bus)        := Io.Altm_Batt_Di;
      Cb_In (Ele_T.Trn_Rt_Cb)                       := Io.Turn_Rt_Di;
      Cb_In (Ele_T.Uhf_Comm_Cb)                     := Io.Uhf_Comm_Di;
      Cb_In (Ele_T.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus)  := Io.Radio_Rlys_Batt_Di;
      Cb_In (Ele_T.Fire_Detect_Cb_Fwd_Aux_Batt_Bus) := Io.Fire_1_Di;
      Cb_In (Ele_T.Stby_Lts_Cb)                     := Io.Stby_Di;
      Cb_In (Ele_T.Aft_Stby_Cb)                     := Io.Aft_Inst_Di;

      -- Forward generator bus

      Cb_In (Ele_T.Air_Cond_Cb)                := Io.Air_Cond_Di;
      Cb_In (Ele_T.Ckpt_Temp_Cb)               := Io.Ckpt_Temp_Di;
      Cb_In (Ele_T.Aural_Warn_Cb)              := Io.Aural_Warn_Di;
      Cb_In (Ele_T.Evap_Blower_Cb)             := Io.Evap_Blower_Di;
      Cb_In (Ele_T.Aoa_Ht_Cb)                  := Io.Aoa_Ht_Di;
      Cb_In (Ele_T.Pitot_Ht_Cb)                := Io.Pitot_Ht_Di;
      Cb_In (Ele_T.Fuel_Bal_Cb)                := Io.Fuel_Bal_Di;
      Cb_In (Ele_T.Side_Lts_Cb)                := Io.Side_Di;
      Cb_In (Ele_T.Nav_Lts_Cb)                 := Io.Nav_Di;
      Cb_In (Ele_T.Taxi_Lts_Cb)                := Io.Taxi_Di;
      Cb_In (Ele_T.Speedbrake_Cb)              := Io.Speed_Brake_Di;
      Cb_In (Ele_T.Nws_Cb)                     := Io.Nws_Di;
      Cb_In (Ele_T.Test_Lts_Cb)                := Io.Test_Di;
      Cb_In (Ele_T.Trim_Ind_Cb)                := Io.Trim_Ind_Di;
      Cb_In (Ele_T.Edm_Cb_Fwd_Gen_Bus)         := Io.Edm_Gen_Di;
      Cb_In (Ele_T.Gen_Sw_Cb)                  := Io.Gen_Sw_Di;
      Cb_In (Ele_T.Fwd_Avi_Cb_Fwd_Gen_Bus)     := Io.Fwd_Avi_Gen_Di;
      Cb_In (Ele_T.Fire_Detect_Cb_Fwd_Gen_Bus) := Io.Fire_2_Di;
      Cb_In (Ele_T.Eng_Sys_Dis_Cb)             := Io.Eng_Sys_Dis_Di;
      Cb_In (Ele_T.Pri_Eng_Dis_Cb)             := Io.Pri_Eng_Dis_Di;
      Cb_In (Ele_T.Tad_Cb)                     := Io.Tad_Di;
      Cb_In (Ele_T.Seat_Adj_Cb)                := Io.Seat_Adj_Di;
      Cb_In (Ele_T.Cws_Cb_Fwd_Gen_Bus)         := Io.Cws_Gen_Di;
      Cb_In (Ele_T.Aft_Gen_Cb)                 := Io.Aft_Gen_Di;

      -- Forward avionics generator bus

      Cb_In (Ele_T.Adc_Cb)                        := Io.Adc_Di;
      Cb_In (Ele_T.Ehsi_Cb)                       := Io.Ehsi_Di;
      Cb_In (Ele_T.Xpdr_Cb)                       := Io.Xpdr_Di;
      Cb_In (Ele_T.Tas_Cb)                        := Io.Tas_Di;
      Cb_In (Ele_T.Vhf_Comm_Cb)                   := Io.Vhf_Comm_Di;
      Cb_In (Ele_T.Asi_Cb)                        := Io.Asi_Di;
      Cb_In (Ele_T.Altm_Cb_Fwd_Avi_Gen_Bus)       := Io.Altm_Gen_Di;
      Cb_In (Ele_T.Vhf_Nav_Cb)                    := Io.Vhf_Nav_Di;
      Cb_In (Ele_T.Dme_Cb)                        := Io.Dme_Di;
      Cb_In (Ele_T.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus) := Io.Radio_Rlys_Di;
      Cb_In (Ele_T.Vvi_Cb)                        := Io.Vvi_Di;
      Cb_In (Ele_T.Rmu_Cb)                        := Io.Rmu_Gen_Di;
      Cb_In (Ele_T.Aft_Avi_Cb_Fwd_Avi_Gen_Bus)    := Io.Aft_Avi_Gen_Di;

      -- Aft generator bus

--       Cb_In (Ele_T.Evap_Blower_Cb_Aft_Gen_Bus) := True;
--       Cb_In (Ele_T.Seat_Adj_Cb_Aft_Gen_Bus)    := True;
--       Cb_In (Ele_T.Side_Lts_Cb_Aft_Gen_Bus)    := True;
--       Cb_In (Ele_T.Eng_Sys_Dis_Cb_Aft_Gen_Bus) := True;
--       Cb_In (Ele_T.Pri_Eng_Dis_Cb_Aft_Gen_Bus) := True;
--       Cb_In (Ele_T.Trim_Ind_Cb_Aft_Gen_Bus)    := True;

      -- Aft avionics generator bus

--       Cb_In (Ele_T.Ehsi_Cb_Aft_Avi_Gen_Bus) := True;
--       Cb_In (Ele_T.Rmu_Cb_Aft_Avi_Gen_Bus)  := True;
--       Cb_In (Ele_T.Gps_Cb_Aft_Avi_Gen_Bus)  := True;
--       Cb_In (Ele_T.Altm_Cb_Aft_Avi_Gen_Bus) := True;
--       Cb_In (Ele_T.Asi_Cb_Aft_Avi_Gen_Bus)  := True;
--       Cb_In (Ele_T.Vvi_Cb_Aft_Avi_Gen_Bus)  := True;

      ---------------------------
      -- get bus power for cb's
      ---------------------------

      Cb_Hot (Ele_T.Bus_Tie_Control_Cb) :=
        (Pwr_Src.Power_Available (The_Gen)     and Gen_Rly_Closed)     or
        (Pwr_Src.Power_Available (The_Batt)    and Batt_Rly_Closed )   or
        (Pwr_Src.Power_Available (The_Ext_Pwr) and Ext_Pwr_Rly_Closed);

      Cb_Hot (Ele_T.Generator_Sense_Cb) := Pwr_Src.Power_Available (The_Gen);

      Cb_Hot (Ele_T.Ext_Pwr_Cb) := Pwr_Src.Power_Available (The_Ext_Pwr);

      Cb_Hot (Ele_T.Aux_Batt_Cb) := Aux_Batt_Mnt.Is_Powered (The_Aux_Batt_Mnt);

      -- Generator bus
      if Gen_Bus_Is_Powered /= Gen_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Cond_Blower_Cb)      := Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Heat_Exch_Blower_Cb) := Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Bus_Sense_Cb)        := Gen_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;

      -- Hot battery bus
      if Hot_Batt_Bus_Is_Powered /= Hot_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Spare_Cb)                   := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ram_Air_Valve_Cb)           := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Battery_Cb)                 := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Emerg_Flaps_Cb)             := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Clocks_Cb)                  := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Elt_Cb)                     := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Obogs_Cb)                   := Hot_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fdr_Maint_Epa_Fuel_Pump_Cb) := Hot_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;

      -- Forward battery bus
      if Fwd_Batt_Bus_Is_Powered /= Fwd_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Ail_El_Trim_Cb)          := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Rud_Trim_Cb)             := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ldg_Gr_Cont_Cb)          := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Flap_Cont_Cb)            := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Util_Lt_Cb)              := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Coll_Lts_Cb)             := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Inst_Lts_Cb)             := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ldg_Lts_Cb)              := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Cws_Cb_Fwd_Batt_Bus)     := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fuel_Qty_Lo_Cb)          := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Pmu_Cb)                  := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Boost_Pump_Cb)           := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ign_Cb)                  := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Start_Cb)                := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Oil_Trx_Cb)              := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Batt_Sw_Cb)              := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Avi_Mstr_Cb)             := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fld_Lts_Cb)              := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Alt_Eng_Dis_Cb)          := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Edm_Cb_Fwd_Batt_Bus)     := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Prop_Sys_Cb)             := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fdr_Cb)                  := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aoa_Cb)                  := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Inflow_Sys_Cb)           := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Hyd_Sys_Cb)              := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Audio_Cb)                := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aft_Battery_Cb)          := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aux_Battery_Cb)          := Fwd_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fwd_Avi_Cb_Fwd_Batt_Bus) := Fwd_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;
      -- Forward avionics battery bus
      if Fwd_Avi_Batt_Bus_Is_Powered /= Fwd_Avi_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Eadi_Cb)                     := Fwd_Avi_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Gps_Cb)                      := Fwd_Avi_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ahrs_Cb)                     := Fwd_Avi_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aft_Avi_Cb_Fwd_Avi_Batt_Bus) := Fwd_Avi_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;
      -- Aft avionics bus
      if Aft_Avi_Batt_Bus_Is_Powered /= Aft_Avi_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Eadi_Cb_Aft_Avi_Batt_Bus) := Aft_Avi_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;
      -- Aft battery bus
      if Aft_Batt_Bus_Is_Powered /= Aft_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Alt_Eng_Dis_Cb_Aft_Batt_Bus) := Aft_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Audio_Cb_Aft_Batt_Bus)       := Aft_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Util_Lt_Cb_Aft_Batt_Bus)     := Aft_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Inst_Lts_Cb_Aft_Batt_Bus)    := Aft_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fld_Lts_Cb_Aft_Batt_Bus)     := Aft_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;
      -- Aft auxiliary battery bus
      if Aft_Aux_Batt_Bus_Is_Powered /= Aft_Aux_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Altm_Cb_Aft_Aux_Batt_Bus)   := Aft_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Gyro_Cb_Aft_Aux_Batt_Bus)   := Aft_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Trn_Rt_Cb_Aft_Aux_Batt_Bus) := Aft_Aux_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;
      -- Forward auxiliary battery bus

      if Fwd_Aux_Batt_Bus_Is_Powered /= Fwd_Aux_Batt_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Gyro_Cb)                         := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Altm_Cb_Fwd_Aux_Batt_Bus)        := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Trn_Rt_Cb)                       := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Uhf_Comm_Cb)                     := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus)  := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fire_Detect_Cb_Fwd_Aux_Batt_Bus) := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Stby_Lts_Cb)                     := Fwd_Aux_Batt_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aft_Stby_Cb)                     := Fwd_Aux_Batt_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;

      -- Forward generator bus
      if Fwd_Gen_Bus_Is_Powered /= Fwd_Gen_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Air_Cond_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ckpt_Temp_Cb)               := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aural_Warn_Cb)              := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Evap_Blower_Cb)             := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aoa_Ht_Cb)                  := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Pitot_Ht_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fuel_Bal_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Side_Lts_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Nav_Lts_Cb)                 := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Taxi_Lts_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Speedbrake_Cb)              := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Nws_Cb)                     := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Test_Lts_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Trim_Ind_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Edm_Cb_Fwd_Gen_Bus)         := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Gen_Sw_Cb)                  := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fwd_Avi_Cb_Fwd_Gen_Bus)     := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Fire_Detect_Cb_Fwd_Gen_Bus) := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Eng_Sys_Dis_Cb)             := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Pri_Eng_Dis_Cb)             := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Tad_Cb)                     := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Seat_Adj_Cb)                := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Cws_Cb_Fwd_Gen_Bus)         := Fwd_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aft_Gen_Cb)                 := Fwd_Gen_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;

      -- Forward avionics generator bus
      if Fwd_Avi_Gen_Bus_Is_Powered /= Fwd_Avi_Gen_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Adc_Cb)                        := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Ehsi_Cb)                       := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Xpdr_Cb)                       := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Tas_Cb)                        := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Vhf_Comm_Cb)                   := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Asi_Cb)                        := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Altm_Cb_Fwd_Avi_Gen_Bus)       := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Vhf_Nav_Cb)                    := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Dme_Cb)                        := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus) := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Vvi_Cb)                        := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Rmu_Cb)                        := Fwd_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Aft_Avi_Cb_Fwd_Avi_Gen_Bus)    := Fwd_Avi_Gen_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;
      -- Aft generator bus
      if Aft_Gen_Bus_Is_Powered /= Aft_Gen_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Evap_Blower_Cb_Aft_Gen_Bus) := Aft_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Seat_Adj_Cb_Aft_Gen_Bus)    := Aft_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Side_Lts_Cb_Aft_Gen_Bus)    := Aft_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Eng_Sys_Dis_Cb_Aft_Gen_Bus) := Aft_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Pri_Eng_Dis_Cb_Aft_Gen_Bus) := Aft_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Trim_Ind_Cb_Aft_Gen_Bus)    := Aft_Gen_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;

      -- Aft avionics generator bus
      if Aft_Avi_Gen_Bus_Is_Powered /= Aft_Avi_Gen_Bus_Is_Powered_Last_Pass then
         Cb_Hot (Ele_T.Ehsi_Cb_Aft_Avi_Gen_Bus) := Aft_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Rmu_Cb_Aft_Avi_Gen_Bus)  := Aft_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Gps_Cb_Aft_Avi_Gen_Bus)  := Aft_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Altm_Cb_Aft_Avi_Gen_Bus) := Aft_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Asi_Cb_Aft_Avi_Gen_Bus)  := Aft_Avi_Gen_Bus_Is_Powered;
         Cb_Hot (Ele_T.Vvi_Cb_Aft_Avi_Gen_Bus)  := Aft_Avi_Gen_Bus_Is_Powered;
         Set_Last_Pass_Bus_Power_Vars := True;
      end if;

      if Set_Last_Pass_Bus_Power_Vars then
         Fwd_Batt_Bus_Is_Powered_Last_Pass     := Fwd_Batt_Bus_Is_Powered;
         Fwd_Gen_Bus_Is_Powered_Last_Pass      := Fwd_Gen_Bus_Is_Powered;
         Fwd_Avi_Batt_Bus_Is_Powered_Last_Pass := Fwd_Avi_Batt_Bus_Is_Powered;
         Fwd_Avi_Gen_Bus_Is_Powered_Last_Pass  := Fwd_Avi_Gen_Bus_Is_Powered;
         Hot_Batt_Bus_Is_Powered_Last_Pass     := Hot_Batt_Bus_Is_Powered;
         Gen_Bus_Is_Powered_Last_Pass          := Gen_Bus_Is_Powered;
         Aft_Batt_Bus_Is_Powered_Last_Pass     := Aft_Batt_Bus_Is_Powered;
         Aft_Gen_Bus_Is_Powered_Last_Pass      := Aft_Gen_Bus_Is_Powered;
         Aft_Aux_Batt_Bus_Is_Powered_Last_Pass := Aft_Aux_Batt_Bus_Is_Powered;
         Fwd_Aux_Batt_Bus_Is_Powered_Last_Pass := Fwd_Aux_Batt_Bus_Is_Powered;
         Aft_Avi_Gen_Bus_Is_Powered_Last_Pass  := Aft_Avi_Gen_Bus_Is_Powered;
         Aft_Avi_Batt_Bus_Is_Powered_Last_Pass := Aft_Avi_Batt_Bus_Is_Powered;
      end if;
      --------------
      -- Update cbs
      --------------
      if Ios.Kcbhot or Auto_Test_On then

         Cbs.Update
           (An_Instance => The_Cbs,
            Has_Power   => Cb_Force_Hot,
            Is_In       => Cb_Force_Hot);

      elsif Ios.Kcbin then

         Cbs.Update
           (An_Instance => The_Cbs,
            Has_Power   => Cb_Hot,
            Is_In       => Cb_Force_Hot);

      else

         Cbs.Update
           (An_Instance => The_Cbs,
            Has_Power   => Cb_Hot,
            Is_In       => Cb_In);

      end if;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      -- set cb trip hardware


      Io.Ail_El_Trim_Do     :=       Host.Ail_El_Trim_Do or else Ios.Ail_El_Trim_Do;
      Io.Rud_Trim_Do        :=          Host.Rud_Trim_Do or else Ios.Rud_Trim_Do;
      Io.Ldg_Gr_Cont_Do     :=       Host.Ldg_Gr_Cont_Do or else Ios.Ldg_Gr_Cont_Do;
      Io.Flap_Cont_Do       :=         Host.Flap_Cont_Do or else Ios.Flap_Cont_Do;
      Io.Util_Do            :=              Host.Util_Do or else Ios.Util_Do;
      Io.Coll_Do            :=              Host.Coll_Do or else Ios.Coll_Do;
      Io.Inst_Do            :=              Host.Inst_Do or else Ios.Inst_Do;
      Io.Ldg_Do             :=               Host.Ldg_Do or else Ios.Ldg_Do;
      Io.Cws_Batt_Do        :=          Host.Cws_Batt_Do or else Ios.Cws_Batt_Do;
      Io.Fuel_Qty_Lo_Do     :=       Host.Fuel_Qty_Lo_Do or else Ios.Fuel_Qty_Lo_Do;
      Io.Pmu_Do             :=               Host.Pmu_Do or else Ios.Pmu_Do;
      Io.Boost_Pump_Do      :=        Host.Boost_Pump_Do or else Ios.Boost_Pump_Do;
      Io.Ign_Do             :=               Host.Ign_Do or else Ios.Ign_Do;
      Io.Start_Do           :=             Host.Start_Do or else Ios.Start_Do;
      Io.Oil_Trx_Do         :=           Host.Oil_Trx_Do or else Ios.Oil_Trx_Do;
      Io.Bat_Sw_Do          :=            Host.Bat_Sw_Do or else Ios.Bat_Sw_Do;
      Io.Avi_Mstr_Do        :=          Host.Avi_Mstr_Do or else Ios.Avi_Mstr_Do;
      Io.Fldt_Do            :=              Host.Fldt_Do or else Ios.Fldt_Do;
      Io.Alt_Eng_Dis_Do     :=       Host.Alt_Eng_Dis_Do or else Ios.Alt_Eng_Dis_Do;
      Io.Edm_Batt_Do        :=          Host.Edm_Batt_Do or else Ios.Edm_Batt_Do;
      Io.Prop_Sys_Do        :=          Host.Prop_Sys_Do or else Ios.Prop_Sys_Do;
      Io.Fdr_Do             :=               Host.Fdr_Do or else Ios.Fdr_Do;
      Io.Aoa_Do             :=               Host.Aoa_Do or else Ios.Aoa_Do;
      Io.Inflow_Sys_Do      :=        Host.Inflow_Sys_Do or else Ios.Inflow_Sys_Do;
      Io.Hyd_Sys_Do         :=           Host.Hyd_Sys_Do or else Ios.Hyd_Sys_Do;
      Io.Audio_Do           :=             Host.Audio_Do or else Ios.Audio_Do;
      Io.Aft_Bat_Do         :=           Host.Aft_Bat_Do or else Ios.Aft_Bat_Do;
      Io.Aux_Bat_Do         :=           Host.Aux_Bat_Do or else Ios.Aux_Bat_Do;
      Io.Fwd_Avi_Batt_Do    :=      Host.Fwd_Avi_Batt_Do or else Ios.Fwd_Avi_Batt_Do;

      Io.Eadi_Do            :=              Host.Eadi_Do or else Ios.Eadi_Do;
      Io.Gps_Do             :=               Host.Gps_Do or else Ios.Gps_Do;
      Io.Ahrs_Do            :=              Host.Ahrs_Do or else Ios.Ahrs_Do;
      Io.Aft_Avi_Batt_Do    :=      Host.Aft_Avi_Batt_Do or else Ios.Aft_Avi_Batt_Do;

      Io.Gyro_Do            :=              Host.Gyro_Do or else Ios.Gyro_Do;
      Io.Altm_Batt_Do       :=         Host.Altm_Batt_Do or else Ios.Altm_Batt_Do;
      Io.Turn_Rt_Do         :=           Host.Turn_Rt_Do or else Ios.Turn_Rt_Do;
      Io.Uhf_Comm_Do        :=          Host.Uhf_Comm_Do or else Ios.Uhf_Comm_Do;
      Io.Radio_Rlys_Batt_Do :=   Host.Radio_Rlys_Batt_Do or else Ios.Radio_Rlys_Batt_Do;
      Io.Fire_1_Do          :=            Host.Fire_1_Do or else Ios.Fire_1_Do;
      Io.Stby_Do            :=              Host.Stby_Do or else Ios.Stby_Do;
      Io.Aft_Inst_Do        :=          Host.Aft_Inst_Do or else Ios.Aft_Inst_Do;



      Io.Air_Cond_Do        :=          Host.Air_Cond_Do or else Ios.Air_Cond_Do;
      Io.Ckpt_Temp_Do       :=         Host.Ckpt_Temp_Do or else Ios.Ckpt_Temp_Do;
      Io.Aural_Warn_Do      :=        Host.Aural_Warn_Do or else Ios.Aural_Warn_Do;
      Io.Evap_Blower_Do     :=       Host.Evap_Blower_Do or else Ios.Evap_Blower_Do;
      Io.Aoa_Ht_Do          :=            Host.Aoa_Ht_Do or else Ios.Aoa_Ht_Do;
      Io.Pitot_Ht_Do        :=          Host.Pitot_Ht_Do or else Ios.Pitot_Ht_Do;
      Io.Fuel_Bal_Do        :=          Host.Fuel_Bal_Do or else Ios.Fuel_Bal_Do;
      Io.Side_Do            :=              Host.Side_Do or else Ios.Side_Do;
      Io.Nav_Do             :=               Host.Nav_Do or else Ios.Nav_Do;
      Io.Taxi_Do            :=              Host.Taxi_Do or else Ios.Taxi_Do;
      Io.Speed_Brake_Do     :=       Host.Speed_Brake_Do or else Ios.Speed_Brake_Do;
      Io.Nws_Do             :=               Host.Nws_Do or else Ios.Nws_Do;
      Io.Test_Do            :=              Host.Test_Do or else Ios.Test_Do;
      Io.Trim_Ind_Do        :=          Host.Trim_Ind_Do or else Ios.Trim_Ind_Do;
      Io.Edm_Gen_Do         :=           Host.Edm_Gen_Do or else Ios.Edm_Gen_Do;
      Io.Gen_Sw_Do          :=            Host.Gen_Sw_Do or else Ios.Gen_Sw_Do;
      Io.Fwd_Avi_Gen_Do     :=       Host.Fwd_Avi_Gen_Do or else Ios.Fwd_Avi_Gen_Do;
      Io.Fire_2_Do          :=            Host.Fire_2_Do or else Ios.Fire_2_Do;
      Io.Eng_Sys_Dis_Do     :=       Host.Eng_Sys_Dis_Do or else Ios.Eng_Sys_Dis_Do;
      Io.Pri_Eng_Dis_Do     :=       Host.Pri_Eng_Dis_Do or else Ios.Pri_Eng_Dis_Do;
      Io.Tad_Do             :=               Host.Tad_Do or else Ios.Tad_Do;
      Io.Seat_Adj_Do        :=          Host.Seat_Adj_Do or else Ios.Seat_Adj_Do;
      Io.Cws_Gen_Do         :=           Host.Cws_Gen_Do or else Ios.Cws_Gen_Do;
      Io.Aft_Gen_Do         :=           Host.Aft_Gen_Do or else Ios.Aft_Gen_Do;

      Io.Adc_Do             :=               Host.Adc_Do or else Ios.Adc_Do;
      Io.Ehsi_Do            :=              Host.Ehsi_Do or else Ios.Ehsi_Do;
      Io.Xpdr_Do            :=              Host.Xpdr_Do or else Ios.Xpdr_Do;
      Io.Tas_Do             :=               Host.Tas_Do or else Ios.Tas_Do;
      Io.Vhf_Comm_Do        :=          Host.Vhf_Comm_Do or else Ios.Vhf_Comm_Do;
      Io.Asi_Do             :=               Host.Asi_Do or else Ios.Asi_Do;
      Io.Altm_Gen_Do        :=          Host.Altm_Gen_Do or else Ios.Altm_Gen_Do;
      Io.Vhf_Nav_Do         :=           Host.Vhf_Nav_Do or else Ios.Vhf_Nav_Do;
      Io.Dme_Do             :=               Host.Dme_Do or else Ios.Dme_Do;
      Io.Radio_Rlys_Do      :=        Host.Radio_Rlys_Do or else Ios.Radio_Rlys_Do;
      Io.Vvi_Do             :=               Host.Vvi_Do or else Ios.Vvi_Do;
      Io.Rmu_Gen_Do         :=           Host.Rmu_Gen_Do or else Ios.Rmu_Gen_Do;
      Io.Aft_Avi_Gen_Do     :=       Host.Aft_Avi_Gen_Do or else Ios.Aft_Avi_Gen_Do;



   exception
      when others =>
         Log.Report("Jpats_Electrical.Circuit_Breaker_Controller.Update()");
         raise;
   end Update;


end Jpats_Electrical.Circuit_Breaker_Controller;


