-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  BATTERY BUS
--  The battery bus is divided into a front and rear bus for the
--  respective cockpit, and includes the avionics and aircraft
--  systems which are powered by the battery. See Figure 1-19 (dash one)
--  for the circuit breaker functions and capacities for the front
--  and rear battery buses. A red BAT BUS annunciator on the
--  annunciator panel in each cockpit illuminates when there is
--  a malfunction of the battery bus.
--  Power for the front and rear cockpit battery bus avionics is
--  provided through circuit breakers placarded FWD AVI and
--  AFT AVI, located on the battery bus circuit breaker panel in
--  the front cockpit. Power for the rear cockpit battery bus is
--  provided through a circuit breaker placarded AFT BAT,
--  located on the battery bus circuit breaker panel in the front
--  cockpit. Power for the rear cockpit standby instruments is
--  provided through a circuit breaker placarded AFT STBY,
--  located on the battery bus circuit breaker panel in the front
--  cockpit.

--  GENERATOR BUS
--  The generator bus is divided into a front and rear bus for the
--  respective cockpit, and includes the avionics and aircraft
--  systems which are powered by the generator. See Figure 1-19
--  for the circuit breaker functions and capacities for the
--  front and rear generator buses. A red GEN BUS annunciator
--  on the annunciator panel in each cockpit illuminates when
--  there is a malfunction of the generator bus.
--  Power for the front and rear cockpit generator bus avionics
--  is provided through circuit breakers placarded FWD AVI
--  and AFT AVI, located on the generator bus circuit breaker
--  panel in the front cockpit. Power for the rear cockpit generator
--  bus is provided through a circuit breaker placarded AFT
--  GEN, located on the generator bus circuit breaker panel in
--  the front cockpit.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------

private package Jpats_Electrical.Bus_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Electrical.Bus_Controller;

