-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--   Primary aircraft power is provided by the generator function
--   of the starter/generator, which is regulated and monitored by
--   a generator control unit.
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- Data source:  Raytheon Phase X Data Package
-- Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--               Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------

generic

   type Voltage_Type is digits <>;
   type Ampere_Type is digits <>;
   Package_Name : in String;

package Generator_Control_Unit_G is

   type Instance is private;

   procedure Initialize
     (An_Instance : in out Instance);
   procedure Update
     (An_Instance        : in out Instance;
      Iconst             : in     Float;
      Voltage_In         : in     Voltage_Type;
      Bus_Sense_Voltage  : in     Voltage_Type;
      Current_In         : in     Ampere_Type;
      Reverse_Current_In : in     Ampere_Type;
      Gen_Reset_In       : in     Boolean;
      Fail_Demanded      : in     Boolean);

   function Line_Control
     (An_Instance : in Instance)
      return Boolean;

private

   type Instance is
      record
         Line_Control : Boolean;

         Over_Voltage_Timer_32_Vdc   : Float := 0.0;
         Over_Voltage_Timer_33_Vdc   : Float := 0.0;
         Over_Voltage_Timer_34_Vdc   : Float := 0.0;
         Over_Voltage_Timer_35_Vdc   : Float := 0.0;
         Over_Voltage_Timer_36_Vdc   : Float := 0.0;
         Over_Voltage_Timer_37_Vdc   : Float := 0.0;
         Over_Voltage_Timer_38_Vdc   : Float := 0.0;
         Over_Voltage_Timer_39_Vdc   : Float := 0.0;
         Over_Voltage_Timer_40_Vdc   : Float := 0.0;

         Under_Voltage_Timer_20_Vdc  : Float := 0.0;

         Over_Current_Timer_450_Amps : Float := 0.0;

         Gen_Reset_Timer             : Float := 0.0;

         Voltage_In_Last_Pass        : Voltage_Type := 0.0;


      end record;

end Generator_Control_Unit_G;



