-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Generator_Control_Unit_G is

--    Over_Voltage_Timer_32_Vdc   : Float;
--    Over_Voltage_Timer_33_Vdc   : Float;
--    Over_Voltage_Timer_34_Vdc   : Float;
--    Over_Voltage_Timer_35_Vdc   : Float;
--    Over_Voltage_Timer_36_Vdc   : Float;
--    Over_Voltage_Timer_37_Vdc   : Float;
--    Over_Voltage_Timer_38_Vdc   : Float;
--    Over_Voltage_Timer_39_Vdc   : Float;
--    Over_Voltage_Timer_40_Vdc   : Float;

--    Under_Voltage_Timer_20_Vdc  : Float;

--    Over_Current_Timer_450_Amps : Float;

--    Gen_Reset_Timer             : Float;

--    Voltage_In_Last_Pass        : Voltage_Type;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Line_Control := False;

      An_Instance.Over_Voltage_Timer_32_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_33_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_34_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_35_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_36_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_37_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_38_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_39_Vdc   := 0.0;
      An_Instance.Over_Voltage_Timer_40_Vdc   := 0.0;
      An_Instance.Under_Voltage_Timer_20_Vdc  := 0.0;
      An_Instance.Over_Current_Timer_450_Amps := 0.0;
      An_Instance.Gen_Reset_Timer             := 0.0;
      An_Instance.Voltage_In_Last_Pass        := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


   procedure Update
     (An_Instance        : in out Instance;
      Iconst             : in     Float;
      Voltage_In         : in     Voltage_Type;
      Bus_Sense_Voltage  : in     Voltage_Type;
      Current_In         : in     Ampere_Type;
      Reverse_Current_In : in     Ampere_Type;
      Gen_Reset_In       : in     Boolean;
      Fail_Demanded      : in     Boolean)
   is

      Line_Control : Boolean renames An_Instance.Line_Control;

      Over_Voltage         : Boolean;
      Under_Voltage        : Boolean;
      Over_Current         : Boolean;
      Over_Reverse_Current : Boolean;
      Trip                 : Boolean;

      A,B,C : Boolean := False;


      Over_Voltage_Timer_32_Vdc   : Float renames An_Instance.Over_Voltage_Timer_32_Vdc;
      Over_Voltage_Timer_33_Vdc   : Float renames An_Instance.Over_Voltage_Timer_33_Vdc;
      Over_Voltage_Timer_34_Vdc   : Float renames An_Instance.Over_Voltage_Timer_34_Vdc;
      Over_Voltage_Timer_35_Vdc   : Float renames An_Instance.Over_Voltage_Timer_35_Vdc;
      Over_Voltage_Timer_36_Vdc   : Float renames An_Instance.Over_Voltage_Timer_36_Vdc;
      Over_Voltage_Timer_37_Vdc   : Float renames An_Instance.Over_Voltage_Timer_37_Vdc;
      Over_Voltage_Timer_38_Vdc   : Float renames An_Instance.Over_Voltage_Timer_38_Vdc;
      Over_Voltage_Timer_39_Vdc   : Float renames An_Instance.Over_Voltage_Timer_39_Vdc;
      Over_Voltage_Timer_40_Vdc   : Float renames An_Instance.Over_Voltage_Timer_40_Vdc;

      Under_Voltage_Timer_20_Vdc  : Float renames An_Instance.Under_Voltage_Timer_20_Vdc;

      Over_Current_Timer_450_Amps : Float renames An_Instance.Over_Current_Timer_450_Amps;

      Gen_Reset_Timer             : Float renames An_Instance.Gen_Reset_Timer;

      Voltage_In_Last_Pass        : Voltage_Type renames An_Instance.Voltage_In_Last_Pass;


   begin

      -- over voltage
      if Voltage_In >= 32.0 then
         Over_Voltage_Timer_32_Vdc := Over_Voltage_Timer_32_Vdc + Iconst;
      else
         Over_Voltage_Timer_32_Vdc := 0.0;
      end if;
      if Voltage_In >= 33.0 then
         Over_Voltage_Timer_33_Vdc := Over_Voltage_Timer_33_Vdc + Iconst;
      else
         Over_Voltage_Timer_33_Vdc := 0.0;
      end if;
      if  Voltage_In >= 34.0 then
         Over_Voltage_Timer_34_Vdc := Over_Voltage_Timer_34_Vdc + Iconst;
      else
         Over_Voltage_Timer_34_Vdc := 0.0;
      end if;
      if  Voltage_In >= 35.0 then
         Over_Voltage_Timer_35_Vdc := Over_Voltage_Timer_35_Vdc + Iconst;
      else
         Over_Voltage_Timer_35_Vdc := 0.0;
      end if;
      if  Voltage_In >= 36.0 then
         Over_Voltage_Timer_36_Vdc := Over_Voltage_Timer_36_Vdc + Iconst;
      else
         Over_Voltage_Timer_36_Vdc := 0.0;
      end if;
      if  Voltage_In >= 37.0 then
         Over_Voltage_Timer_37_Vdc := Over_Voltage_Timer_37_Vdc + Iconst;
      else
         Over_Voltage_Timer_37_Vdc := 0.0;
      end if;
      if  Voltage_In >= 38.0 then
         Over_Voltage_Timer_38_Vdc := Over_Voltage_Timer_38_Vdc + Iconst;
      else
         Over_Voltage_Timer_38_Vdc := 0.0;
      end if;
      if  Voltage_In >= 39.0 then
         Over_Voltage_Timer_39_Vdc := Over_Voltage_Timer_39_Vdc + Iconst;
      else
         Over_Voltage_Timer_39_Vdc := 0.0;
      end if;
      if  Voltage_In >= 40.0 then
         Over_Voltage_Timer_40_Vdc := Over_Voltage_Timer_40_Vdc + Iconst;
      else
         Over_Voltage_Timer_40_Vdc := 0.0;
      end if;

      Over_Voltage :=
        Over_Voltage_Timer_32_Vdc >= 10.0 or
        Over_Voltage_Timer_33_Vdc >= 8.75 or
        Over_Voltage_Timer_34_Vdc >= 7.5  or
        Over_Voltage_Timer_35_Vdc >= 6.25 or
        Over_Voltage_Timer_36_Vdc >= 5.0  or
        Over_Voltage_Timer_37_Vdc >= 3.75 or
        Over_Voltage_Timer_38_Vdc >= 2.5  or
        Over_Voltage_Timer_39_Vdc >= 1.25 or
        Over_Voltage_Timer_40_Vdc >  0.0;


      -- under voltage
      if Voltage_In < 20.0 then
         Under_Voltage_Timer_20_Vdc := Under_Voltage_Timer_20_Vdc + Iconst;
      else
         Under_Voltage_Timer_20_Vdc := 0.0;
      end if;

      Under_Voltage := Under_Voltage_Timer_20_Vdc >= 10.0;


      -- over current
      if Current_In >= 450.0 then
         Over_Current_Timer_450_Amps := Over_Current_Timer_450_Amps + Iconst;
      else
         Over_Current_Timer_450_Amps := 0.0;
      end if;

      Over_Current := Over_Current_Timer_450_Amps > 10.0;


      -- reverse current
      Over_Reverse_Current := Reverse_Current_In >= 75.0;


      Trip :=
        Over_Voltage          or
        Under_Voltage         or
        Over_Current          or
        Over_Reverse_Current  or
        Fail_Demanded         or
        Voltage_In < 5.0;

      if Line_Control then

         Line_Control := not Trip;

      else

         A := Gen_Reset_Timer > 0.5 and not Gen_Reset_In;

         if Gen_Reset_In then
            Gen_Reset_Timer := Gen_Reset_Timer + Iconst;
         else
            Gen_Reset_Timer := 0.0;
         end if;

         B := (Voltage_In > (Bus_Sense_Voltage - 0.5)) and (Voltage_In_Last_Pass < (Bus_Sense_Voltage - 0.5));

         C := not Trip;

         Line_Control := (A or B) and C;

      end if;

      Voltage_In_Last_Pass := Voltage_In;

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   function Line_Control
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Line_Control;
   exception
      when others =>
         Log.Report(Package_Name & ".Line_Control()");
         raise;
   end Line_Control;


end Generator_Control_Unit_G;
