-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic

   type Current_Limiter_Name_Type is (<>);
   type Current_Limiter_Type is private;
   type Array_Of_Current_Limiter_Type is array (Current_Limiter_Name_Type) of Current_Limiter_Type;
   type Array_Of_Boolean is array (Current_Limiter_Name_Type) of Boolean;
   with procedure Open_A_Current_Limiter (A_Current_Limiter : in out Current_Limiter_Type);
   with procedure Close_A_Current_Limiter (A_Current_Limiter : in out Current_Limiter_Type);
   with procedure Initialize_A_Current_Limiter (A_Current_Limiter : in out Current_Limiter_Type);
   with procedure Update_A_Current_Limiter (A_Current_Limiter : in out Current_Limiter_Type;
                                            Opens             : in     Boolean);
   with function A_Current_Limiter_Open (A_Current_Limiter : in Current_Limiter_Type) return Boolean;
   with function A_Current_Limiter_Closed (A_Current_Limiter : in Current_Limiter_Type) return Boolean;
   Package_Name : in String;

package Current_Limiter_Collection_G is

   type Instance is private;

   procedure Open_Current_Limiter
     (An_Instance : in out Instance;
      Name        : in     Current_Limiter_Name_Type);

   procedure Close_Current_Limiter
     (An_Instance : in out Instance;
      Name        : in     Current_Limiter_Name_Type);

   procedure Open
     (An_Instance : in out Instance);

   procedure Close
     (An_Instance : in out Instance);

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance : in out Instance;
      Opens       : in     Array_Of_Boolean);

   function Is_Open
     (An_Instance : in Instance;
      Name        : in Current_Limiter_Name_Type)
      return Boolean;

   function Is_Closed
     (An_Instance : in Instance;
      Name        : in Current_Limiter_Name_Type)
      return Boolean;

private

   type Instance is
      record
         The_Current_Limiters : Array_Of_Current_Limiter_Type;
      end record;

end Current_Limiter_Collection_G;
