-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Current_Limiter_Collection_G is

   procedure Open_Current_Limiter
     (An_Instance : in out Instance;
      Name        : in     Current_Limiter_Name_Type)
   is
   begin
      Open_A_Current_Limiter (An_Instance.The_Current_Limiters (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Open_Current_Limiter()");
         raise;
   end Open_Current_Limiter;

   procedure Close_Current_Limiter
     (An_Instance : in out Instance;
      Name        : in     Current_Limiter_Name_Type)
   is
   begin
      Close_A_Current_Limiter (An_Instance.The_Current_Limiters (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Close_Current_Limiter()");
         raise;
   end Close_Current_Limiter;

   procedure Open
     (An_Instance : in out Instance)
   is
   begin
      for Name in Current_Limiter_Name_Type
        loop
           Open_A_Current_Limiter (An_Instance.The_Current_Limiters (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Open()");
         raise;
   end Open;

   procedure Close
     (An_Instance : in out Instance)
   is
   begin
      for Name in Current_Limiter_Name_Type
        loop
           Close_A_Current_Limiter (An_Instance.The_Current_Limiters (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Close()");
         raise;
   end Close;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Name in Current_Limiter_Name_Type
        loop
           Initialize_A_Current_Limiter (An_Instance.The_Current_Limiters (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;


   procedure Update
     (An_Instance : in out Instance;
      Opens       : in     Array_Of_Boolean)
   is
   begin
      for Name in Current_Limiter_Name_Type
      loop
         Update_A_Current_Limiter
           (An_Instance.The_Current_Limiters (Name), Opens (Name));
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   function Is_Open
     (An_Instance : in Instance;
      Name        : in Current_Limiter_Name_Type)
     return Boolean
   is
   begin
      return A_Current_Limiter_Open (An_Instance.The_Current_Limiters (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

   function Is_Closed
     (An_Instance : in Instance;
      Name        : in Current_Limiter_Name_Type)
     return Boolean
   is
   begin
      return A_Current_Limiter_Closed (An_Instance.The_Current_Limiters (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;

end Current_Limiter_Collection_G;
