-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic

   type Ampere_Type is digits <>;
   type Relay_Name_Type is (<>);
   type Relay_Type is private;
   type Array_Of_Relay_Type is array (Relay_Name_Type) of Relay_Type;
   type Array_Of_Boolean_Type is array (Relay_Name_Type) of Boolean;

   with procedure Open_A_Relay (A_Relay : in out Relay_Type);
   with procedure Close_A_Relay (A_Relay : in out Relay_Type);
   with procedure Initialize_A_Relay (A_Relay : in out Relay_Type);

   with function A_Relay_Load (A_Relay : in Relay_Type) return Ampere_Type;
   with function A_Relay_Is_Open (A_Relay : in Relay_Type) return Boolean;
   with function A_Relay_Is_Closed (A_Relay : in Relay_Type) return Boolean;
   with procedure Update_A_Relay (A_Relay        : in out Relay_Type;
                                  Pwr_And_Ground : in     Boolean);
   Package_Name : in String;

package Coil_Relay_Collection_G is

   type Instance is private;

   procedure Open_Relay
     (An_Instance : in out Instance;
      Relay_Name  : in     Relay_Name_Type);

   procedure Close_Relay
     (An_Instance : in out Instance;
      Relay_Name  : in     Relay_Name_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance      : in out Instance;
      Power_And_Ground : in     Array_Of_Boolean_Type);

   function Load
     (An_Instance : in Instance;
      Relay_Name  : in Relay_Name_Type)
      return Ampere_Type;

   function Is_Open
     (An_Instance : in Instance;
      Relay_Name  : in Relay_Name_Type)
      return Boolean;

   function Is_Closed
     (An_Instance : in Instance;
      Relay_Name  : in Relay_Name_Type)
      return Boolean;

private

   type Instance is
      record
         The_Relays : Array_Of_Relay_Type;
      end record;

end Coil_Relay_Collection_G;

