-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Coil_Relay_Collection_G is

   procedure Open_Relay
     (An_Instance : in out Instance;
      Relay_Name  : in     Relay_Name_Type)
   is
   begin
      Open_A_Relay (An_Instance.The_Relays (Relay_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Open_Relay()");
         raise;
   end Open_Relay;

   procedure Close_Relay
     (An_Instance : in out Instance;
      Relay_Name  : in     Relay_Name_Type)
   is
   begin
      Close_A_Relay (An_Instance.The_Relays (Relay_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Close_Relay()");
         raise;
   end Close_Relay;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Name in Relay_Name_Type
        loop
           Initialize_A_Relay (An_Instance.The_Relays (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance      : in out Instance;
      Power_And_Ground : in     Array_Of_Boolean_Type)
   is
   begin
      for Name in Relay_Name_Type
        loop
           Update_A_Relay (An_Instance.The_Relays (Name), Power_And_Ground (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   function Load
     (An_Instance : in Instance;
      Relay_Name  : in Relay_Name_Type)
     return Ampere_Type
   is
   begin
      return A_Relay_Load (An_Instance.The_Relays (Relay_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   function Is_Open
     (An_Instance : in Instance;
      Relay_Name  : in Relay_Name_Type)
     return Boolean
   is
   begin
      return A_Relay_Is_Open (An_Instance.The_Relays (Relay_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

   function Is_Closed
     (An_Instance : in Instance;
      Relay_Name  : in Relay_Name_Type)
     return Boolean
   is
   begin
      return A_Relay_Is_Closed (An_Instance.The_Relays (Relay_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;


end Coil_Relay_Collection_G;

