-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Circuit_Breaker_G is

   procedure Power
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Powered;
   exception
      when others =>
         Log.Report(Package_Name & ".Power()");
         raise;
   end Power;

   procedure Unpower
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.State := Unpowered;
   exception
      when others =>
         Log.Report(Package_Name & ".Unpower()");
         raise;
   end Unpower;

   function Is_Powered
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Powered;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Powered()");
         raise;
   end Is_Powered;

   function Is_Unpowered
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.State = Unpowered;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Unpowered()");
         raise;
   end Is_Unpowered;

   function State
     (An_Instance : in Instance)
     return State_Type
   is
   begin
      return An_Instance.State;
   exception
      when others =>
         Log.Report(Package_Name & ".State()");
         raise;
   end State;

   procedure Update
     (An_Instance : in out Instance;
      Has_Power   : in     Boolean;
      Is_In       : in     Boolean)
   is
      Cb_Should_Be_Powered : Boolean := Is_In and then Has_Power;
   begin
      if Cb_Should_Be_Powered and Is_Unpowered (An_Instance) then
         Power (An_Instance);
      elsif not Cb_Should_Be_Powered and Is_Powered (An_Instance) then
         Unpower (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      Unpower (An_Instance);
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

end Circuit_Breaker_G;


