-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


generic

   type Circuit_Breaker_Name_Type is (<>);
   type Circuit_Breaker_Type is private;
   type Array_Of_Circuit_Breaker_Type is array (Circuit_Breaker_Name_Type) of Circuit_Breaker_Type;
   type Array_Of_Boolean_Type is array (Circuit_Breaker_Name_Type) of Boolean;
   with procedure Power_Circuit_Breaker (A_Circuit_Breaker : in out Circuit_Breaker_Type);
   with procedure Unpower_Circuit_Breaker (A_Circuit_Breaker : in out Circuit_Breaker_Type);
   with function Circuit_Breaker_Is_Powered (A_Circuit_Breaker : in Circuit_Breaker_Type) return Boolean;
   with function Circuit_Breaker_Is_Unpowered (A_Circuit_Breaker : in Circuit_Breaker_Type) return Boolean;
   with procedure Update_Circuit_Breaker (A_Circuit_Breaker : in out Circuit_Breaker_Type;
                                          Has_Power         : in     Boolean;
                                          Is_In             : in     Boolean);
   with procedure Initialize_Circuit_Breaker (A_Circuit_Breaker : in out Circuit_Breaker_Type);
   Package_Name : in String;

package Circuit_Breaker_Collection_G is

   type Instance is private;

   procedure Power
     (An_Instance : in out Instance);

   procedure Unpower
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance : in out Instance;
      Has_Power   : in     Array_Of_Boolean_Type;
      Is_In       : in     Array_Of_Boolean_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Is_Powered
     (An_Instance : in Instance;
      Name        : in Circuit_Breaker_Name_Type)
      return Boolean;
   function Is_Unpowered
     (An_Instance : in Instance;
      Name        : in Circuit_Breaker_Name_Type)
      return Boolean;

private

   type Instance is
      record
         The_Circuit_Breakers : Array_Of_Circuit_Breaker_Type;
      end record;

end Circuit_Breaker_Collection_G;
