-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Circuit_Breaker_Collection_G is

   procedure Power
     (An_Instance : in out Instance)
   is
   begin
        for Name in Circuit_Breaker_Name_Type
          loop
             Power_Circuit_Breaker (An_Instance.The_Circuit_Breakers (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Power()");
         raise;
   end Power;

   procedure Unpower
     (An_Instance : in out Instance)
   is
   begin
        for Name in Circuit_Breaker_Name_Type
          loop
             Unpower_Circuit_Breaker (An_Instance.The_Circuit_Breakers (Name));
          end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Unpower()");
         raise;
   end Unpower;

   procedure Update
     (An_Instance : in out Instance;
      Has_Power   : in     Array_Of_Boolean_Type;
      Is_In       : in     Array_Of_Boolean_Type)
   is
   begin
      for Name in Circuit_Breaker_Name_Type
        loop
           Update_Circuit_Breaker (A_Circuit_Breaker => An_Instance.The_Circuit_Breakers (Name),
                                   Has_Power       => Has_Power (Name),
                                   Is_In           => Is_In (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Name in Circuit_Breaker_Name_Type
        loop
           Initialize_Circuit_Breaker (An_Instance.The_Circuit_Breakers (Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Is_Powered
     (An_Instance : in Instance;
      Name        : in Circuit_Breaker_Name_Type)
     return Boolean
   is
   begin
      return Circuit_Breaker_Is_Powered (An_Instance.The_Circuit_Breakers (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Powered()");
         raise;
   end Is_Powered;

   function Is_Unpowered
     (An_Instance : in Instance;
      Name        : in Circuit_Breaker_Name_Type)
     return Boolean
   is
   begin
      return Circuit_Breaker_Is_Unpowered (An_Instance.The_Circuit_Breakers (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Unpowered()");
         raise;
   end Is_Unpowered;

end Circuit_Breaker_Collection_G;

