-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic

   type Voltage_Type is digits <>;
   type Ampere_Type is digits <>;
   Powered_Voltage_Threshold : in Voltage_Type;
   Package_Name : in String;

package Bus_G is

   type Instance is private;

   procedure Power
     (An_Instance : in out Instance;
      Voltage     : in     Voltage_Type);

   procedure Unpower
     (An_Instance : in out Instance);

   procedure Set_Load
     (An_Instance : in out Instance;
      Load        : in     Ampere_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Voltage
     (An_Instance : in Instance)
      return Voltage_Type;

   function Is_Powered
     (An_Instance : in Instance)
      return Boolean;

   function Load
     (An_Instance : in Instance)
      return Ampere_Type;

   procedure Update
     (An_Instance : in out Instance;
      Voltage     : in     Voltage_Type;
      Load        : in     Ampere_Type);

private

   type Instance is
      record
         Voltage    : Voltage_Type;
         Is_Powered : Boolean;
         Load       : Ampere_Type;
      end record;

end Bus_G;
