-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Bus_G is

   procedure Power
     (An_Instance : in out Instance;
      Voltage     : in     Voltage_Type)
   is
   begin
      An_Instance.Is_Powered := True;
      An_Instance.Voltage    := Voltage;
   exception
      when others =>
         Log.Report(Package_Name & ".Power()");
         raise;
   end Power;

   procedure Unpower
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Powered := False;
      An_Instance.Voltage    := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Unpower()");
         raise;
   end Unpower;

   procedure Set_Load
     (An_Instance : in out Instance;
      Load        : in     Ampere_Type)
   is
   begin
      An_Instance.Load := Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Load()");
         raise;
   end Set_Load;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Voltage    := 0.0;
      An_Instance.Is_Powered := False;
      An_Instance.Load       := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Voltage
     (An_Instance : in Instance)
     return Voltage_Type
   is
   begin
      return An_Instance.Voltage;
   exception
      when others =>
         Log.Report(Package_Name & ".Voltage()");
         raise;
   end Voltage;

   function Is_Powered
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Powered;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Powered()");
         raise;
   end Is_Powered;

   function Load
     (An_Instance : in Instance)
     return Ampere_Type
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   procedure Update
     (An_Instance : in out Instance;
      Voltage     : in     Voltage_Type;
      Load        : in     Ampere_Type)
   is
   begin
      An_Instance.Voltage := Voltage;
      An_Instance.Load := Load;
      An_Instance.Is_Powered := Voltage >= Powered_Voltage_Threshold;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;


end Bus_G;

