-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------



generic

   type Voltage_Type is digits <>;
   type Ampere_Type is digits <>;
   type Bus_Name_Type is (<>);
   type Bus_Type is private;
   type Array_Of_Bus_Type is array (Bus_Name_Type) of Bus_Type;
   type Array_Of_Bus_Voltages is array (Bus_Name_Type) of Voltage_Type;
   type Array_Of_Bus_Loads is array (Bus_Name_Type) of Ampere_Type;

   with procedure Power_A_Bus (A_Bus       : in out Bus_Type;
                               Bus_Voltage : in     Voltage_Type);
   with procedure Unpower_A_Bus (A_Bus : in out Bus_Type);
   with procedure Set_A_Bus_Load (A_Bus    : in out Bus_Type;
                                  Bus_Load : in     Ampere_Type);
   with function A_Bus_Voltage (A_Bus : in Bus_type) return Voltage_Type;
   with function A_Bus_Is_Powered (A_Bus : in Bus_type) return Boolean;
   with function A_Bus_Load (A_Bus : in Bus_type) return Ampere_Type;
   with procedure Update_A_Bus (A_Bus   : in out Bus_Type;
                                Voltage : in     Voltage_Type;
                                Load    : in     Ampere_Type);
   with procedure Initialize_A_Bus (A_Bus : in out Bus_Type);
   Package_Name : in String;
package Bus_Collection_G is

   type Instance is private;

   procedure Power_Bus
     (An_Instance : in out Instance;
      Bus_Name    : in     Bus_Name_Type;
      Bus_Voltage : in     Voltage_Type);
   procedure Unpower_Bus
     (An_Instance : in out Instance;
      Bus_Name    : in     Bus_Name_Type);
   procedure Set_Bus_Load
     (An_Instance : in out Instance;
      Bus_Name    : in     Bus_Name_Type;
      Bus_Load    : in     Ampere_Type);
   procedure Power_Buses
     (An_Instance : in out Instance;
      Voltage     : in     Voltage_Type);
   procedure Unpower_Buses
     (An_Instance : in out Instance);
   procedure Initialize
     (An_Instance : in out Instance);

   function Voltage
     (An_Instance : in Instance;
      Bus_Name    : in Bus_Name_Type)
      return Voltage_Type;
   function Is_Powered
     (An_Instance : in Instance;
      Bus_Name    : in Bus_Name_Type)
      return Boolean;
   function Load
     (An_Instance : in Instance;
      Bus_Name    : in Bus_Name_Type)
      return Ampere_Type;

   procedure Update
     (An_Instance  : in out Instance;
      Bus_Voltages : in     Array_Of_Bus_Voltages;
      Bus_Loads    : in     Array_Of_Bus_Loads);

private

   type Instance is
      record
         The_Buses : Array_Of_Bus_Type;
      end record;

end Bus_Collection_G;
