-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Bus_Collection_G is

   procedure Power_Bus
     (An_Instance : in out Instance;
      Bus_Name    : in     Bus_Name_Type;
      Bus_Voltage : in     Voltage_Type)
   is
   begin
      Power_A_Bus (An_Instance.The_Buses (Bus_Name), Bus_Voltage);
   exception
      when others =>
         Log.Report(Package_Name & ".Power_Bus()");
         raise;
   end Power_Bus;

   procedure Unpower_Bus
     (An_Instance : in out Instance;
      Bus_Name    : in     Bus_Name_Type)
   is
   begin
      Unpower_A_Bus (An_Instance.The_Buses (Bus_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Unpower_Bus()");
         raise;
   end Unpower_Bus;

   procedure Set_Bus_Load
     (An_Instance : in out Instance;
      Bus_Name    : in     Bus_Name_Type;
      Bus_Load    : in     Ampere_Type)
   is
   begin
      Set_A_Bus_Load (An_Instance.The_Buses (Bus_Name), Bus_Load);
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Bus_Load()");
         raise;
   end Set_Bus_Load;

   procedure Power_Buses
     (An_Instance : in out Instance;
      Voltage     : in     Voltage_Type)
   is
   begin
      for Name in Bus_Name_Type
        loop
           Power_Bus (An_Instance, Name, Voltage);
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Power_Buses()");
         raise;
   end Power_Buses;

   procedure Unpower_Buses
     (An_Instance : in out Instance)
   is
   begin
      for Name in Bus_Name_Type
        loop
           Unpower_Bus (An_Instance, Name);
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Unpower_Buses()");
         raise;
   end Unpower_Buses;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Name in Bus_Name_Type
        loop
           Initialize_A_Bus (An_Instance.The_Buses(Name));
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Voltage
     (An_Instance : in Instance;
      Bus_Name    : in Bus_Name_Type)
     return Voltage_Type
   is
   begin
      return A_Bus_Voltage (An_Instance.The_Buses (Bus_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Voltage()");
         raise;
   end Voltage;

   function Is_Powered
     (An_Instance : in Instance;
      Bus_Name    : in Bus_Name_Type)
     return Boolean
   is
   begin
      return A_Bus_Is_Powered (An_Instance.The_Buses (Bus_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Powered()");
         raise;
   end Is_Powered;

   function Load
     (An_Instance : in Instance;
      Bus_Name    : in Bus_Name_Type)
     return Ampere_Type
   is
   begin
      return A_Bus_Load (An_Instance.The_Buses (Bus_Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Load()");
         raise;
   end Load;

   procedure Update
     (An_Instance  : in out Instance;
      Bus_Voltages : in     Array_Of_Bus_Voltages;
      Bus_Loads    : in     Array_Of_Bus_Loads)
   is
   begin
      for Name in Bus_Name_Type
      loop
         Update_A_Bus (An_Instance.The_Buses (Name), Bus_Voltages (Name), Bus_Loads (Name));
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

end Bus_Collection_G;


